/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselSocket;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByFilter;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselGUI;
import org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselGeneralViewPanel;
import org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselSocketPanel;
import org.lsst.ccs.subsystems.fcs.carousel.ui.FilterListPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenDevicePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GatherPanel;

public class CarouselGatherPanel
extends GatherPanel {
    private static final long serialVersionUID = -975949078768889254L;
    private final String[] socketNames = new String[]{"socket1", "socket2", "socket3", "socket4", "socket5"};
    private final CarouselGeneralViewPanel caGeneralViewPanel = new CarouselGeneralViewPanel();
    protected final transient Map<String, CarouselSocketPanel> socketPanels = new TreeMap<String, CarouselSocketPanel>();
    protected CarouselGUI subs;
    private EPOSControllerPanel clampXminusControllerPanel;
    private EPOSControllerPanel clampXplusControllerPanel;
    private EPOSControllerPanel carouselControllerPanel;
    private CanOpenDevicePanel hyTTCPanel;
    private CanOpenDevicePanel cancbxAI420_1Panel;
    private CanOpenDevicePanel cancbxAI420_2Panel;
    private FilterListPanel filterListPanel;

    public CarouselGatherPanel(String tcpProxyName) {
        super(tcpProxyName);
        this.initPanels();
    }

    public CarouselGatherPanel(CarouselGUI subs, String tcpProxyName) {
        super(tcpProxyName);
        this.initPanels();
        this.subs = subs;
        this.clampXminusControllerPanel.setSubsystem(subs);
        this.clampXplusControllerPanel.setSubsystem(subs);
        this.carouselControllerPanel.setSubsystem(subs);
        this.caGeneralViewPanel.setSubsystem(subs);
        this.socketPanels.entrySet().stream().forEach(entry -> ((CarouselSocketPanel)entry.getValue()).setSubsystem(subs));
    }

    public EPOSControllerPanel getClampXminusControllerPanel() {
        return this.clampXminusControllerPanel;
    }

    public EPOSControllerPanel getClampXplusControllerPanel() {
        return this.clampXplusControllerPanel;
    }

    public EPOSControllerPanel getCarouselControllerPanel() {
        return this.carouselControllerPanel;
    }

    public CanOpenDevicePanel getHyTTCPanel() {
        return this.hyTTCPanel;
    }

    public CanOpenDevicePanel getCancbxAI420_1Panel() {
        return this.cancbxAI420_1Panel;
    }

    public CanOpenDevicePanel getCancbxAI420_2Panel() {
        return this.cancbxAI420_2Panel;
    }

    public CarouselGeneralViewPanel getCaGeneralViewPanel() {
        return this.caGeneralViewPanel;
    }

    public FilterListPanel getFilterListPanel() {
        return this.filterListPanel;
    }

    public void onStatusMessage(StatusMessage msg) {
        StatusSubsystemData d = (StatusSubsystemData)msg;
        KeyValueData data = (KeyValueData)d.getObject();
        if (data.getValue() instanceof StatusDataPublishedByHardware) {
            this.updateCanOpenHardwarePanel((StatusDataPublishedByHardware)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByEPOSController) {
            this.updateControllerPanel(data.getKey(), (StatusDataPublishedByEPOSController)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByFilter) {
            this.updateFilterListPanel(data.getKey(), (StatusDataPublishedByFilter)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByCarouselClamp) {
            this.updateSocketPanels((StatusDataPublishedByCarouselClamp)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByCarouselSocket) {
            this.updateSocketPanels(data.getKey(), (StatusDataPublishedByCarouselSocket)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByCarousel) {
            FCSLOG.debug((Object)"STATUS data coming from carousel.");
            this.caGeneralViewPanel.update((StatusDataPublishedByCarousel)data.getValue());
        } else {
            FCSLOG.warning((Object)(this.getName() + " An unexpected dataType was read on the status bus:" + data.getKey()));
        }
    }

    @Override
    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, List<String> hardwareNames) throws InterruptedException, InvocationTargetException {
        super.initializeGUIWithConfigInfo(configInfo, hardwareNames);
        SwingUtilities.invokeAndWait(new GuiInitialization(configInfo));
    }

    @Override
    public void initializeGUIWithFiltersInfo(ConfigurationInfo configInfo, List<String> filterNamesList) throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(new GuiInitializationFilterListPanel(configInfo, filterNamesList));
    }

    protected void updateControllerPanel(String controllerName, StatusDataPublishedByEPOSController s) {
        switch (controllerName) {
            case "clampXminusController": {
                this.clampXminusControllerPanel.updateController(s);
                break;
            }
            case "clampXplusController": {
                this.clampXplusControllerPanel.updateController(s);
                break;
            }
            case "carouselController": {
                this.carouselControllerPanel.updateController(s);
                break;
            }
            default: {
                FCSLOG.error((Object)(this.getName() + " :received an unknown controller name on STATUS bus:" + controllerName));
                assert (false);
                break;
            }
        }
    }

    private void updateFilterListPanel(String filterName, StatusDataPublishedByFilter s) {
        this.filterListPanel.updateFilterListPanel(filterName, s);
    }

    private void updateSocketPanels(StatusDataPublishedByCarouselClamp s) {
        String clampName = s.getName();
        char num = clampName.charAt(clampName.length() - 1);
        String socketName = "socket" + num;
        this.socketPanels.get(socketName).update(s);
    }

    private void updateSocketPanels(String socketName, StatusDataPublishedByCarouselSocket s) {
        this.socketPanels.get(socketName).updateSocket(s);
    }

    private void initPanels() {
        this.clampXminusControllerPanel = new EPOSControllerPanel("clampXminusController");
        this.clampXplusControllerPanel = new EPOSControllerPanel("clampXplusController");
        this.carouselControllerPanel = new EPOSControllerPanel("carouselController");
        this.hyTTCPanel = new CanOpenDevicePanel("clampsSensorsReaderDevice");
        this.cancbxAI420_1Panel = new CanOpenDevicePanel("ai420_1");
        this.cancbxAI420_2Panel = new CanOpenDevicePanel("ai420_2");
        for (String socketName : this.socketNames) {
            this.socketPanels.put(socketName, new CarouselSocketPanel(socketName));
        }
        this.filterListPanel = new FilterListPanel();
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            CarouselGatherPanel.this.clampXminusControllerPanel.initializeGui(this.configInfo);
            CarouselGatherPanel.this.clampXplusControllerPanel.initializeGui(this.configInfo);
            CarouselGatherPanel.this.carouselControllerPanel.initializeGui(this.configInfo);
            CarouselGatherPanel.this.hyTTCPanel.initializeGui(this.configInfo);
            CarouselGatherPanel.this.cancbxAI420_1Panel.initializeGui(this.configInfo);
            CarouselGatherPanel.this.cancbxAI420_2Panel.initializeGui(this.configInfo);
            CarouselGatherPanel.this.caGeneralViewPanel.initializeGui(this.configInfo);
            CarouselGatherPanel.this.socketPanels.entrySet().stream().forEach(entry -> ((CarouselSocketPanel)entry.getValue()).initializeGui(this.configInfo));
        }
    }

    private class GuiInitializationFilterListPanel
    implements Runnable {
        private final ConfigurationInfo configInfo;
        private final List<String> filterNamesList;

        public GuiInitializationFilterListPanel(ConfigurationInfo configInfo, List<String> filterNamesList) {
            this.configInfo = configInfo;
            this.filterNamesList = new ArrayList<String>();
            this.filterNamesList.addAll(filterNamesList);
        }

        @Override
        public void run() {
            CarouselGatherPanel.this.filterListPanel.initializeGui(this.configInfo, this.filterNamesList);
        }
    }
}

