/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerGUI;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerGeneralViewPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerThreeOnlineClampsPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerTrucksPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerTwoLatchesPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GatherPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.PlutoGatewayPanel;

public class AutochangerGatherPanel
extends GatherPanel {
    private static final long serialVersionUID = -975949078768889254L;
    protected AutochangerGUI subs;
    protected EPOSControllerPanel linearRailMasterControllerPanel;
    protected EPOSControllerPanel linearRailSlaveControllerPanel;
    protected EPOSControllerPanel latchXminusControllerPanel;
    protected EPOSControllerPanel latchXplusControllerPanel;
    protected EPOSControllerPanel onlineClampXminusControllerPanel;
    protected EPOSControllerPanel onlineClampXplusControllerPanel;
    protected EPOSControllerPanel onlineClampYminusControllerPanel;
    protected PlutoGatewayPanel plutoGatewayPanel;
    protected AutochangerThreeOnlineClampsPanel onlineClampsPanel;
    private AutochangerTrucksPanel acTrucksPanel;
    private AutochangerTwoLatchesPanel acLatchesPanel = new AutochangerTwoLatchesPanel();
    private AutochangerThreeOnlineClampsPanel acClampsPanel = new AutochangerThreeOnlineClampsPanel();
    private final AutochangerGeneralViewPanel acGeneralViewPanel = new AutochangerGeneralViewPanel();

    public AutochangerGatherPanel(String tcpProxyName) {
        super(tcpProxyName);
        this.initPanels();
    }

    public AutochangerGatherPanel(AutochangerGUI subs, String tcpProxyName) {
        super(tcpProxyName);
        this.initPanels();
        this.subs = subs;
        this.acClampsPanel.setSubsystem(subs);
        this.acLatchesPanel.setSubsystem(subs);
        this.acTrucksPanel.setSubsystem(subs);
        this.linearRailMasterControllerPanel.setSubsystem(subs);
        this.linearRailSlaveControllerPanel.setSubsystem(subs);
        this.latchXminusControllerPanel.setSubsystem(subs);
        this.latchXplusControllerPanel.setSubsystem(subs);
        this.onlineClampXminusControllerPanel.setSubsystem(subs);
        this.onlineClampXplusControllerPanel.setSubsystem(subs);
        this.onlineClampYminusControllerPanel.setSubsystem(subs);
    }

    public AutochangerTrucksPanel getAcTrucksPanel() {
        return this.acTrucksPanel;
    }

    public AutochangerTwoLatchesPanel getAcLatchesPanel() {
        return this.acLatchesPanel;
    }

    public AutochangerThreeOnlineClampsPanel getAcClampsPanel() {
        return this.acClampsPanel;
    }

    public AutochangerGeneralViewPanel getAcGeneralViewPanel() {
        return this.acGeneralViewPanel;
    }

    public EPOSControllerPanel getLinearRailMasterControllerPanel() {
        return this.linearRailMasterControllerPanel;
    }

    public EPOSControllerPanel getLinearRailSlaveControllerPanel() {
        return this.linearRailSlaveControllerPanel;
    }

    public EPOSControllerPanel getLatchXminusControllerPanel() {
        return this.latchXminusControllerPanel;
    }

    public EPOSControllerPanel getLatchXplusControllerPanel() {
        return this.latchXplusControllerPanel;
    }

    public EPOSControllerPanel getOnlineClampXminusControllerPanel() {
        return this.onlineClampXminusControllerPanel;
    }

    public EPOSControllerPanel getOnlineClampXplusControllerPanel() {
        return this.onlineClampXplusControllerPanel;
    }

    public EPOSControllerPanel getOnlineClampZControllerPanel() {
        return this.onlineClampYminusControllerPanel;
    }

    public PlutoGatewayPanel getPlutoGatewayPanel() {
        return this.plutoGatewayPanel;
    }

    @Override
    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, List<String> hardwareNames) throws InterruptedException, InvocationTargetException {
        super.initializeGUIWithConfigInfo(configInfo, hardwareNames);
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    public void onStatusMessage(StatusMessage msg) {
        StatusSubsystemData d = (StatusSubsystemData)msg;
        KeyValueData data = (KeyValueData)d.getObject();
        FCSLOG.debug((Object)(this.subs.getName() + " read data dataType:" + data.getKey()));
        switch (data.getKey()) {
            case "tcpProxy": {
                this.updateCanOpenHardwarePanel((StatusDataPublishedByHardware)data.getValue());
                break;
            }
            case "autochangerGeneral": {
                this.updateAutochanger((StatusDataPublishedByAutoChanger)data.getValue());
                break;
            }
            case "linearRailMasterController": {
                this.updateLinearRailMasterController((StatusDataPublishedByEPOSController)data.getValue());
                break;
            }
            case "linearRailSlaveController": {
                this.updateLinearRailSlaveController((StatusDataPublishedByEPOSController)data.getValue());
                break;
            }
            case "latchXminusController": {
                this.updateLatchXminusController((StatusDataPublishedByEPOSController)data.getValue());
                break;
            }
            case "latchXplusController": {
                this.updateLatchXplusController((StatusDataPublishedByEPOSController)data.getValue());
                break;
            }
            case "onlineClampXminusController": {
                this.updateOnlineClampXminusController((StatusDataPublishedByEPOSController)data.getValue());
                break;
            }
            case "onlineClampXplusController": {
                this.updateOnlineClampXplusController((StatusDataPublishedByEPOSController)data.getValue());
                break;
            }
            case "onlineClampYminusController": {
                this.updateOnlineClampYminusController((StatusDataPublishedByEPOSController)data.getValue());
                break;
            }
            case "autochangerTrucks": {
                FCSLOG.finest((Object)(this.getName() + " Data published by Trucks= " + ((StatusDataPublishedByAutoChangerTrucks)data.getValue()).toString()));
                this.updateTrucks((StatusDataPublishedByAutoChangerTrucks)data.getValue());
                break;
            }
            case "latchXminus": {
                FCSLOG.finest((Object)(this.getName() + " Data published by Latch= " + ((StatusDataPublishedByAutochangerLatch)data.getValue()).toString()));
                this.updateLatch((StatusDataPublishedByAutochangerLatch)data.getValue());
                break;
            }
            case "latchXplus": {
                FCSLOG.finest((Object)(this.getName() + " Data published by Latch= " + ((StatusDataPublishedByAutochangerLatch)data.getValue()).toString()));
                this.updateLatch((StatusDataPublishedByAutochangerLatch)data.getValue());
                break;
            }
            case "autochangerLatches": {
                FCSLOG.debug((Object)(this.getName() + " Data published by Latches= " + ((StatusDataPublishedByAutochangerTwoLatches)data.getValue()).toString()));
                this.updateLatches((StatusDataPublishedByAutochangerTwoLatches)data.getValue());
                break;
            }
            case "onlineClampXminus": {
                FCSLOG.debug((Object)(this.getName() + " Data published by ClampXminus= " + ((StatusDataPublishedByAutochangerOnlineClamp)data.getValue()).toString()));
                this.updateClampXminus((StatusDataPublishedByAutochangerOnlineClamp)data.getValue());
                break;
            }
            case "onlineClampXplus": {
                FCSLOG.debug((Object)(this.getName() + " Data published by ClampXplus= " + ((StatusDataPublishedByAutochangerOnlineClamp)data.getValue()).toString()));
                this.updateClampXplus((StatusDataPublishedByAutochangerOnlineClamp)data.getValue());
                break;
            }
            case "onlineClampZ": {
                FCSLOG.debug((Object)(this.getName() + " Data published by ClampZ= " + ((StatusDataPublishedByAutochangerOnlineClamp)data.getValue()).toString()));
                this.updateClampZ((StatusDataPublishedByAutochangerOnlineClamp)data.getValue());
                break;
            }
            case "autochangerClamps": {
                FCSLOG.debug((Object)(this.getName() + " Data published by Clamps= " + ((StatusDataPublishedByAutochangerThreeClamps)data.getValue()).toString()));
                this.updateClamps((StatusDataPublishedByAutochangerThreeClamps)data.getValue());
                break;
            }
            default: {
                FCSLOG.warning((Object)(this.getName() + " An unexpected dataType was read on the status bus:" + data.getType()));
            }
        }
    }

    protected void updateLinearRailMasterController(StatusDataPublishedByEPOSController s) {
        this.linearRailMasterControllerPanel.updateController(s);
    }

    protected void updateLinearRailSlaveController(StatusDataPublishedByEPOSController s) {
        this.linearRailSlaveControllerPanel.updateController(s);
    }

    protected void updateLatchXminusController(StatusDataPublishedByEPOSController s) {
        this.latchXminusControllerPanel.updateController(s);
    }

    protected void updateLatchXplusController(StatusDataPublishedByEPOSController s) {
        this.latchXplusControllerPanel.updateController(s);
    }

    protected void updateOnlineClampXminusController(StatusDataPublishedByEPOSController s) {
        this.onlineClampXminusControllerPanel.updateController(s);
    }

    protected void updateOnlineClampXplusController(StatusDataPublishedByEPOSController s) {
        this.onlineClampXplusControllerPanel.updateController(s);
    }

    protected void updateOnlineClampYminusController(StatusDataPublishedByEPOSController s) {
        this.onlineClampYminusControllerPanel.updateController(s);
    }

    protected void updateClampXminus(StatusDataPublishedByAutochangerOnlineClamp s) {
        this.acClampsPanel.updateClampXminus(s);
    }

    protected void updateClampXplus(StatusDataPublishedByAutochangerOnlineClamp s) {
        this.acClampsPanel.updateClampXplus(s);
    }

    protected void updateClampZ(StatusDataPublishedByAutochangerOnlineClamp s) {
        this.acClampsPanel.updateClampZ(s);
    }

    protected void updateClamps(StatusDataPublishedByAutochangerThreeClamps s) {
        this.acClampsPanel.updateClamps(s);
        this.acGeneralViewPanel.updateClamps(s);
    }

    protected void updateAutochanger(StatusDataPublishedByAutoChanger s) {
        this.acGeneralViewPanel.updateAutochanger(s);
    }

    protected void updateLatch(StatusDataPublishedByAutochangerLatch s) {
        this.acLatchesPanel.updateLatch(s);
    }

    protected void updateLatches(StatusDataPublishedByAutochangerTwoLatches s) {
        this.acLatchesPanel.updateLatches(s);
        this.acGeneralViewPanel.updateLatches(s);
    }

    protected void updateTrucks(StatusDataPublishedByAutoChangerTrucks s) {
        FCSLOG.finest((Object)(" Data published by Trucks= " + s.toString()));
        this.acTrucksPanel.updateTrucks(s);
        this.acGeneralViewPanel.updateTrucks(s);
    }

    private void initPanels() {
        this.linearRailMasterControllerPanel = new EPOSControllerPanel("linearRailMasterController");
        this.linearRailSlaveControllerPanel = new EPOSControllerPanel("linearRailSlaveController");
        this.latchXminusControllerPanel = new EPOSControllerPanel("latchXminusController");
        this.latchXplusControllerPanel = new EPOSControllerPanel("latchXplusController");
        this.onlineClampXminusControllerPanel = new EPOSControllerPanel("onlineClampXminusController");
        this.onlineClampXplusControllerPanel = new EPOSControllerPanel("onlineClampXplusController");
        this.onlineClampYminusControllerPanel = new EPOSControllerPanel("onlineClampZController");
        this.plutoGatewayPanel = new PlutoGatewayPanel("plutoGateway");
        this.acClampsPanel = new AutochangerThreeOnlineClampsPanel();
        this.acLatchesPanel = new AutochangerTwoLatchesPanel();
        this.acTrucksPanel = new AutochangerTrucksPanel("trucks");
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            AutochangerGatherPanel.this.acGeneralViewPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.acClampsPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.acLatchesPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.acTrucksPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.linearRailMasterControllerPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.linearRailSlaveControllerPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.latchXminusControllerPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.latchXplusControllerPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.onlineClampXminusControllerPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.onlineClampXplusControllerPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.onlineClampYminusControllerPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.plutoGatewayPanel.initializeGui(this.configInfo);
        }
    }
}

