/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerBottomPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerGatherPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralPanel;

public class AutochangerGUI
extends GeneralGUI {
    private static final long serialVersionUID = 1528028505886594591L;
    private static final String trucksModuleName = "autochangerTrucks";
    private static final String clampsName = "onlineClamps";
    private static final String latchesName = "latches";
    private final long updateTrucksPositionTimeout;
    private long timeoutForTrucksMotion;
    private final long timeoutForClosingClamps;
    private final long timeoutForOpeningClamps;
    private final long timeoutForClosingLatches;
    private final long timeoutForOpeningLatches;

    public AutochangerGUI(String name, String destination, AgentMessagingLayer aml) {
        super(name, destination, aml);
        AutochangerGatherPanel autochangerGatherPanel = new AutochangerGatherPanel(this, "tcpProxy");
        AutochangerBottomPanel autochangerBottomPanel = new AutochangerBottomPanel(autochangerGatherPanel, "AUTOCHANGER");
        this.generalPanel = new GeneralPanel(this, autochangerBottomPanel);
        this.pane = new JScrollPane(this.generalPanel);
        this.updateTrucksPositionTimeout = 1000L;
        this.timeoutForTrucksMotion = 60000L;
        this.timeoutForClosingClamps = 10000L;
        this.timeoutForOpeningClamps = 10000L;
        this.timeoutForClosingLatches = 10000L;
        this.timeoutForOpeningLatches = 10000L;
    }

    public void setTimeoutForTrucksMotion(long timeoutForTrucksMotion) {
        this.timeoutForTrucksMotion = timeoutForTrucksMotion;
    }

    public void updateTrucksPosition() {
        FCSCst.FCSLOG.info((Object)"Autochanger updating Trucks position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.updateTrucksPositionTimeout));
        new GeneralGUI.CommandSwingWorker("updatePosition", this.updateTrucksPositionTimeout, trucksModuleName).execute();
    }

    public void goToHandOff() {
        FCSCst.FCSLOG.info((Object)"Autochanger Trucks going to Handoff Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForTrucksMotion));
        new GeneralGUI.CommandSwingWorker("goToHandOff", this.timeoutForTrucksMotion, trucksModuleName).execute();
    }

    public void goToStandby() {
        FCSCst.FCSLOG.info((Object)"Autochanger Trucks going to Standby Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForTrucksMotion));
        new GeneralGUI.CommandSwingWorker("goToStandby", this.timeoutForTrucksMotion, trucksModuleName).execute();
    }

    public void goToOnline() {
        FCSCst.FCSLOG.info((Object)"Autochanger Trucks going to Online Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForTrucksMotion));
        new GeneralGUI.CommandSwingWorker("goToOnline", this.timeoutForTrucksMotion, trucksModuleName).execute();
    }

    public void unlockOnlineClamps() {
        FCSCst.FCSLOG.info((Object)"Autochanger unlocking online clamps");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForOpeningClamps));
        new GeneralGUI.CommandSwingWorker("unlockClamps", this.timeoutForOpeningClamps, clampsName).execute();
    }

    public void lockOnlineClamps() {
        FCSCst.FCSLOG.info((Object)"Autochanger locking online clamps");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForClosingClamps));
        new GeneralGUI.CommandSwingWorker("lockClamps", this.timeoutForClosingClamps, clampsName).execute();
    }

    public void closeLatch(String latchName) {
        FCSCst.FCSLOG.info((Object)("Autochanger locking latch: " + latchName));
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForClosingLatches));
        new GeneralGUI.CommandSwingWorker("close", this.timeoutForClosingLatches, latchName).execute();
    }

    public void openLatch(String latchName) {
        FCSCst.FCSLOG.info((Object)("Autochanger unlocking latch: " + latchName));
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForOpeningLatches));
        new GeneralGUI.CommandSwingWorker("open", this.timeoutForOpeningLatches, latchName).execute();
    }

    public void closeLatches() {
        FCSCst.FCSLOG.info((Object)"Autochanger locking latches.");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForClosingLatches));
        new GeneralGUI.CommandSwingWorker("open", this.timeoutForClosingLatches, latchesName).execute();
    }

    public void openLatches() {
        FCSCst.FCSLOG.info((Object)"Autochanger unlocking latches.");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForOpeningLatches));
        new GeneralGUI.CommandSwingWorker("open", this.timeoutForOpeningLatches, latchesName).execute();
    }

    public static void main(String[] args) {
        Agent agent = new Agent("AutochangerGUI", AgentInfo.AgentType.CONSOLE);
        AutochangerGUI t = new AutochangerGUI(agent.getName(), "testbenchCPPM", agent.getMessagingAccess());
        agent.start();
        JFrame frame = new JFrame("Autochanger View GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(3);
    }
}

