/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.util.Map;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterPresenceStatus;

/**
 *
 * @author virieux
 */
public class Tools {

    public static final Color greenColor = new Color(0, 165, 0);
    public static final Color nicePink = new Color(255, 0, 255);

    public static final String fcsFontInString = "Lucida Grande";
    public static final Font BIG_FONT = new Font(fcsFontInString, 1, 14);
    public static final Font HUGE_FONT = new Font(fcsFontInString, 1, 20);
    public static final Font VERY_BIG_FONT = new Font("Tahoma", 1, 18);
    public static final Insets insets_std = new Insets(4, 4, 4, 4);
    public static final Insets insets_big = new Insets(14, 4, 6, 4);

    public static final Dimension preferedPanelSize = new Dimension(1200, 600);

    /**
     *
     * @param lockSensorStatus
     * @return
     * @deprecated
     */
    @Deprecated //instead use getLockStatus().getColor() see in FcsEnumerations
    public static Color getLockSensorColor(String lockSensorStatus) {
        if (lockSensorStatus.equals(FcsEnumerations.LockStatus.ERROR.toString())) {
            return Color.red;
        } else if (lockSensorStatus.equals(FcsEnumerations.LockStatus.LOCKED.toString())) {
            return greenColor;
        } else if (lockSensorStatus.equals(FcsEnumerations.LockStatus.UNKNOWN.toString())) {
            return Color.orange;
        } else if (lockSensorStatus.equals(FcsEnumerations.LockStatus.UNLOCKED.toString())) {
            return Color.blue;
        } else if (lockSensorStatus.equals(FcsEnumerations.LockStatus.CLAMPED.toString())) {
            return Color.GREEN;
        } else if (lockSensorStatus.equals(FcsEnumerations.LockStatus.INTRAVEL.toString())) {
            return Color.YELLOW;
        } else {
            FCSCst.FCSLOG.error("Tools: Unknown Lock Sensor Status " + lockSensorStatus);
            return Color.GRAY;
        }
    }

    public static Color getFilterPresenceColor(String filterPresenceStatus) {
        if (filterPresenceStatus.equals(FilterPresenceStatus.ERROR.toString())) {
            return Color.red;
        } else if (filterPresenceStatus.equals(FilterPresenceStatus.LOCKABLE.toString())) {
            return greenColor;
        } else if (filterPresenceStatus.equals(FilterPresenceStatus.NOT_LOCKABLE.toString())) {
            return Color.orange;
        } else if (filterPresenceStatus.equals(FilterPresenceStatus.NOFILTER.toString())) {
            return Color.gray;
        } else {
            FCSCst.FCSLOG.error("Unknown Filter Presence Status " + filterPresenceStatus);
            return Color.gray;
        }
    }

    /**
     * This tool is used to retrieve a text to display the value of a parameter.
     * When the parameter we want to display is not found in the Configuration
     * Info data, an ERROR is logged and the String UNKNOWN is returned.
     *
     * @param config
     * @param componentName
     * @param parameterName
     * @return
     */
    public static String getText(Map<String, String> config, String componentName, String parameterName) {
        String value = config.get(componentName + "//" + parameterName);
        if (value == null) {
            FCSCst.FCSLOG.error("no such parameter in ConfigurationInfo:" + parameterName
                    + " for component: " + componentName);
            return FCSCst.UNKNOWN;
        } else {
            FCSCst.FCSLOG.debug("value for parameter " + parameterName + "=" + value);
            return value;
        }
    }

    /**
     * This tool is used to retrieve the int value of a parameter.
     *
     * @param config
     * @param componentName
     * @param parameterName
     * @return
     */
    public static int getInt(Map<String, String> config, String componentName, String parameterName) {
        String value = config.get(componentName + "//" + parameterName);
        if (value == null) {
            FCSCst.FCSLOG.error("no such parameter in ConfigurationInfo:" + parameterName
                    + " for component: " + componentName);
            return 0;
        } else {
            return Integer.parseInt(value);
        }
    }

}
