/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.CommandState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.bus.states.StateBundle;

import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.BIG_FONT;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.greenColor;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 * This panel displays the subsystem state and some information specific to the
 * subsystem.
 *
 * @author virieux
 */
public class SubsystemPanel extends JPanel {
    private static final long serialVersionUID = -5966882812912397723L;

    private String title;

    private GeneralGUI subs;

    //state panel
    private final JPanel subsStatePanel = new JPanel();
    private final JPanel controlPanel = new JPanel();
    private final JLabel controlRealHardwareLabel = new JLabel("unknown hardware type");
    private final JLabel phLabel = new JLabel("PhaseState");
    private final JLabel opLabel = new JLabel("OperationalState");
    private final JLabel coLabel = new JLabel("CommandState");
    private final JLabel alLabel = new JLabel("AlarmState");
    private final JLabel phaseStateLabel = new JLabel(PhaseState.OFF_LINE.toString());
    private final JLabel operationalStateLabel = new JLabel("UNKNOWN");
    private final JLabel commandStateLabel = new JLabel("UNKNOWN");
    private final JLabel alarmStateLabel = new JLabel("UNKNOWN");

    //control panel    
    private final JButton updateStateWithSensorsButton = new JButton("updateStateWithSensors");
    private final JButton completeInitializationButton = new JButton("completeInitialization");
    private final JButton abortButton = new JButton("Abort");
    private final JButton shutdownButton = new JButton("Shutdown FCS");


    
    
    /**
     * A Runnable class to initialize the CarouselMainPanel from the configuration
     * data.
     */
    private class GuiInitialization implements Runnable {

        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
            setcontrolRealHardwareLabelText(this.configInfo.getDescriptionName());
        }

        @Override
        public void run() {
            /** Initialize the timeouts from data stored in configInfo*/
            
        }
    }
    
    /** 
     * A Runnable to update this panel from data published on the status bus.
     */
    private class UpdateSubsystemPanel implements Runnable {

        StateBundle bState;

        public UpdateSubsystemPanel(StateBundle state) {
            this.bState = state;
        }

        @Override
        public void run() {
            //state panel
            phaseStateLabel.setText(bState.getState(PhaseState.class).name());
            operationalStateLabel.setText(bState.getState(OperationalState.class).name());
            commandStateLabel.setText(bState.getState(CommandState.class).name());
            alarmStateLabel.setText(bState.getState(AlertState.class).name());
            Color bgColor = Color.gray;

//            if (state.contains("INITIALIZING")) bgColor=Color.orange;
//            else if (state.contains("OFF_LINE")) bgColor=Color.GRAY;
//            else if (state.contains("ENGINEERING_FAULT")) bgColor=Color.RED;
//            else if (state.contains("ENGINEERING_OK")) bgColor=Color.YELLOW;
//            else if (state.contains("ACTIVE")) bgColor=Color.BLUE;
//            else if (state.contains("OPERATIONAL:READY:NORMAL:NOMINAL")) bgColor=greenColor;
            if (bState.isInState(PhaseState.INITIALIZING)) {
                bgColor = Color.orange;
            } else if (bState.isInState(PhaseState.OFF_LINE)) {
                bgColor = Color.GRAY;
            } else if (bState.isInState(OperationalState.ENGINEERING_FAULT)) {
                bgColor = Color.RED;
            } else if (bState.isInState(OperationalState.ENGINEERING_OK)) {
                bgColor = Color.YELLOW;
            } else if (bState.isInState(CommandState.ACTIVE)) {
                bgColor = Color.BLUE;
            } else if (bState.isInState(PhaseState.OPERATIONAL)
                    && bState.isInState(CommandState.READY)
                    && bState.isInState(OperationalState.NORMAL)
                    && bState.isInState(AlertState.NOMINAL)) {
                bgColor = greenColor;
            }
            subsStatePanel.setBackground(bgColor);
        }
    }

    /**
     * Creates a new SystemPanel with a title.
     * @param title 
     */
    public SubsystemPanel(String title) {
        this.title = title;
        this.initComponents();
    }

    /**
     * To initialize the subsytem for this SubsystemPanel.
     * @param newSubs 
     */
    public void setSubsystem(GeneralGUI newSubs) {
        this.subs = newSubs;
        
        /** To display the name of the subsystem on the border of the SubsystemPanel.*/
        this.title = newSubs.destination;
    }
    
    

    public void setcontrolRealHardwareLabelText(String atext) {
        this.controlRealHardwareLabel.setText(atext);
    }
    
    public void initializeGui(ConfigurationInfo configInfo) {
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    public void updateState(StateBundle state) {
        SwingUtilities.invokeLater(new UpdateSubsystemPanel(state));
    }

    // <editor-fold defaultstate="collapsed" desc="Form Description">                          
    private void initComponents() {

        //Subsystem State Panel
        controlRealHardwareLabel.setFont(BIG_FONT); // NOI18N
        phaseStateLabel.setFont(BIG_FONT);
        operationalStateLabel.setFont(BIG_FONT);
        commandStateLabel.setFont(BIG_FONT);
        alarmStateLabel.setFont(BIG_FONT);

        //subsStatePanel.setBorder(BorderFactory.createTitledBorder("SubsystemState"));
        subsStatePanel.setBackground(Color.GRAY);
        subsStatePanel.setPreferredSize(new Dimension(600, 50));
        subsStatePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.insets = insets_std;
        gbc0.anchor = GridBagConstraints.LINE_START;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.anchor = GridBagConstraints.CENTER;
        subsStatePanel.add(phLabel, gbc0);
        gbc0.gridx++;
        subsStatePanel.add(opLabel, gbc0);
        gbc0.gridx++;
        subsStatePanel.add(coLabel, gbc0);
        gbc0.gridx++;
        subsStatePanel.add(alLabel, gbc0);
        gbc0.gridx = 0;
        gbc0.gridy = 1;
        subsStatePanel.add(phaseStateLabel, gbc0);
        gbc0.gridx++;
        subsStatePanel.add(operationalStateLabel, gbc0);
        gbc0.gridx++;
        subsStatePanel.add(commandStateLabel, gbc0);
        gbc0.gridx++;
        subsStatePanel.add(alarmStateLabel, gbc0);

        //end Subsystem State Panel
        /**
         ******************************************************************************
         ** Control Panel
         * *****************************************************************************
         */
        updateStateWithSensorsButton.addActionListener((ActionEvent evt) -> {
            updateStateWithSensorsActionPerformed(evt);
        });

        completeInitializationButton.addActionListener((ActionEvent evt) -> {
            completeInitializationActionPerformed(evt);
        });

        abortButton.addActionListener((ActionEvent evt) -> {
            abortActionPerformed(evt);
        });

        shutdownButton.addActionListener((ActionEvent evt) -> {
            shutdownActionPerformed(evt);
        });

        controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.anchor = GridBagConstraints.FIRST_LINE_START;
        gbc1.fill = GridBagConstraints.HORIZONTAL;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        controlPanel.add(updateStateWithSensorsButton, gbc1);
        gbc1.gridy++;
        controlPanel.add(completeInitializationButton, gbc1);
        gbc1.gridy++;
        controlPanel.add(abortButton, gbc1);
        gbc1.gridy++;
        controlPanel.add(shutdownButton, gbc1);
        /**
         ******************************************************************************
         ** Control Panel
         * *****************************************************************************
         */

        //Whole Panel
        setLayout(new GridBagLayout());
        setBorder(BorderFactory.createTitledBorder(title));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.NORTHWEST;
        gbc.insets = insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        add(subsStatePanel, gbc);
        gbc.gridx++;
        gbc.gridheight = 2;
        add(controlPanel, gbc);
        gbc.gridx = 0;
        gbc.gridheight = 1;
        gbc.gridy++;
        add(controlRealHardwareLabel, gbc);
        //end Whole Panel

    }

    private void updateStateWithSensorsActionPerformed(ActionEvent evt) {
        subs.updateStateWithSensors();
    }

    private void completeInitializationActionPerformed(ActionEvent evt) {
        subs.completeInitialization();
    }

    private void abortActionPerformed(ActionEvent evt) {
        subs.abortAction();
    }

    private void shutdownActionPerformed(ActionEvent evt) {
        System.out.println("About to shutdown subs.....");
        subs.shutdownMyDestinationSubsystem();
    }
    
    void resetPanel() {
        //TODO reset Panel to default values.
    }

    public static void main(String[] argv) {

        SubsystemPanel d = new SubsystemPanel("FCS");
        JFrame frame = new JFrame("Subsystem Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }

}
