/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.utilities.logging.Logger;

/**
 * This class is implemented by all the FCS GUIs. 
 * It's goal is to manage the common stuff for all the subsystems :
 * initialization and update of the panels for the hardware panels  
 * the panels where the CANopen devices are displayed.
 * The subsystemPanel is handled by the GeneralPanel.
 * 
 * @author virieux
 */
public abstract class GatherPanel extends JPanel implements StatusMessageListener {

    protected static final Logger FCSLOG = FCSCst.FCSLOG;
    private static final long serialVersionUID = 3948843130488926276L;
    protected CanOpenHardwareListPanel hardwarePanel;

    /**
     * Creates a TopPanel with a tcpProxy name.
     * @param tcpProxyName
     */
    public GatherPanel(String tcpProxyName) {
        //CANopen devices panel
        hardwarePanel = new CanOpenHardwareListPanel(tcpProxyName);
    }

    public CanOpenHardwareListPanel getHardwarePanel() {
        return hardwarePanel;
    }
    
    

    /**
     * Update the hardwarePanel from the data published by a piece of hardware on the STATUS bus.
     * @param statusDataPublishedByHardware 
     */
    public void updateCanOpenHardwarePanel(StatusDataPublishedByHardware statusDataPublishedByHardware) {
        this.hardwarePanel.updateCanOpenHardwarePanel(statusDataPublishedByHardware);
    }
    
    
    
    /**
     * 
     * @param configInfo
     * @param hardwareList
     * @throws java.lang.InterruptedException
     * @throws java.lang.reflect.InvocationTargetException
     */
    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, List<String> hardwareList)
            throws InterruptedException, InvocationTargetException {
        this.hardwarePanel.initializeGui(configInfo, hardwareList);
    }




    
    
    /**
     * This method is to retrieve the configuration information for the filters from the ConfigurationInfo
     * and the list of filter names. 
     * It's empty 
     * @param configInfo 
     * @param filterNamesList 
     * @throws java.lang.InterruptedException 
     * @throws java.lang.reflect.InvocationTargetException 
     */
    public void initializeGUIWithFiltersInfo(ConfigurationInfo configInfo, List<String> filterNamesList)
            throws InterruptedException, InvocationTargetException {  
        /* When the TopPanel contains Panels which display filters, the body of this method should exists.*/
    }
    
    /**
     * This methods is to put grey color on all panels 
     * when the subsystem is shutdown.
     */
    public void resetPanel() {
    }
}
