/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeSelectionModel;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.StatusMessageListener;

/**
 *
 * @author virieux
 */
public class BottomPanel extends JPanel implements TreeSelectionListener,
        StatusMessageListener {
    private static final long serialVersionUID = -447188631236670592L;

    public GatherPanel gatherPanel;
    protected final String title;
    protected JTree tree;
    protected JPanel rightPanel;
    protected final JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
    protected JPanel helpPanel;
    
    

    public BottomPanel(String title) {
        this.title = title;
        initComponents();
    }

    public BottomPanel(GatherPanel gatherPanel, String title) {
        this.gatherPanel = gatherPanel;
        this.title = title;
        initComponents();
    }
    
    
    
    
    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, List<String> hardwareList) 
            throws InterruptedException, InvocationTargetException {
        this.gatherPanel.initializeGUIWithConfigInfo(configInfo, hardwareList);
    }
    
    public void initializeGUIWithFiltersInfo(ConfigurationInfo configInfo, List<String> filterNamesList) 
            throws InterruptedException, InvocationTargetException {
        this.gatherPanel.initializeGUIWithFiltersInfo(configInfo, filterNamesList);
    }

    /**
     * Creates the nodes of the TreePanel.
     * @param top
     */
    public void createNodes(DefaultMutableTreeNode top) {
        /** CANopen devices panels*/
        DefaultMutableTreeNode devicesNode = new DefaultMutableTreeNode("CANopen devices");
        devicesNode.add(new DefaultMutableTreeNode(gatherPanel.getHardwarePanel()));
        top.add(devicesNode);
        /** CANopen devices panels*/

    }

    @SuppressWarnings(value = "unchecked")
    private void initComponents() {
        setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)), title));
        setForeground(new Color(204, 204, 255));
        setLayout(new GridBagLayout());
        //Create the nodes.
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(title);
        createNodes(top);
        
        //Create a tree that allows one selection at a time.
        tree = new JTree(top);
        tree.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
        
        //Listen for when the selection changes.
        tree.addTreeSelectionListener((TreeSelectionListener) this);
        tree.setMinimumSize(new Dimension(110, 100));
        splitPane.setLeftComponent(tree);
        
        //Create the viewing rightPanel.
        rightPanel = new JPanel();
        splitPane.setRightComponent(rightPanel);
        splitPane.setDividerLocation(200);
        splitPane.setPreferredSize(Tools.preferedPanelSize);
        
        //Add the split rightPanel to this Panel.
        add(splitPane);
        
        //TODO fill helpPanel
        helpPanel = new JPanel();
        JLabel helpLabel = new JLabel("Nothing to display");
        helpPanel.add(helpLabel);
    }
    
    
    @Override
    public void onStatusMessage(StatusMessage msg) {
        this.gatherPanel.onStatusMessage(msg);
    }
    
    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode) tree.getLastSelectedPathComponent();

        if (node == null) {
            return;
        }

        Object nodeInfo = node.getUserObject();

        if (nodeInfo == null) {
            return;
        }

        if (node.isLeaf()) {
            JPanel panel = (JPanel) nodeInfo;
            displayPanel(panel);
        } else {
            //TODO find something cleaver to be done here
        }

    }

    protected void displayPanel(JPanel panel) {
        if (panel != null) {
            JScrollPane scrollPane = new JScrollPane(panel);
            splitPane.setRightComponent(scrollPane);
        } else {
            JScrollPane scrollPane = new JScrollPane(helpPanel);
            splitPane.setRightComponent(scrollPane);
        }
    }




    
}
