package org.lsst.ccs.subsystems.fcs.ui;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

/**
 * An object which might be sent on the status bus show the status of the
 * carousel
 *
 * @author Tony Johnson
 */
public class CarouselModel {

    private final String[] filterNames = {"filterU", "filterG", "filterR", "filterI", "filterZ"};
    private float rotationInDegrees = 0;
    private boolean isLocked;
    private String filterInCamera;
    private final EventListenerList listeners = new EventListenerList();

    public String[] getFilterNames() {
        return filterNames.clone();
    }

    public boolean isLocked() {
        return isLocked;
    }

    public float getRotationInDegrees() {
        return rotationInDegrees;
    }

    public String getFilterInCamera() {
        return filterInCamera;
    }

    public void setFilterInCamera(String filterInCamera) {
        if (filterInCamera == null ? this.filterInCamera != null : !filterInCamera.equals(this.filterInCamera)) {
            this.filterInCamera = filterInCamera;
            fireModelChanged();
        }
    }

    public void setRotationInDegrees(float rotationInDegrees) {
        if ((Float.floatToRawIntBits(rotationInDegrees)) != (Float.floatToRawIntBits(this.rotationInDegrees))) {
            this.rotationInDegrees = rotationInDegrees;
            fireModelChanged();

        }
    }

    public void setLocked(boolean isLocked) {
        if (this.isLocked != isLocked) {
            this.isLocked = isLocked;
            fireModelChanged();
        }
    }

    public void addChangeListener(ChangeListener l) {
        listeners.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        listeners.remove(ChangeListener.class, l);
    }

    private void fireModelChanged() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : listeners.getListeners(ChangeListener.class)) {
            listener.stateChanged(event);
        }
    }
}
