package org.lsst.ccs.subsystems.fcs.testbench.ui;

import java.util.List;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import static org.lsst.ccs.subsystems.fcs.FCSCst.CHANGER_TCPPROXY_NAME;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenHardwareListPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GatherPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.SubsystemPanel;

/**
 *
 * @author virieux
 */
public class TestbenchLPCGatherPanel extends GatherPanel{
    private static final long serialVersionUID = 1240493208100142856L;
    
    protected TestbenchLPCGUI subs;


    //CANopen devices panels
    protected EPOSControllerPanel axisXControllerPanel;
    protected EPOSControllerPanel axisZControllerPanel;
    
    protected LPCAxisXPanel lpcAxisXPanel;
    protected LPCAxisZPanel lpcAxisZPanel;

    public TestbenchLPCGatherPanel(String tcpProxyName) {
        super(tcpProxyName);
        initPanels();
    }

    public TestbenchLPCGatherPanel(TestbenchLPCGUI subs, String tcpProxyName) {
        super(tcpProxyName);
        this.subs = subs;
        initPanels();
    }

    public EPOSControllerPanel getAxisXControllerPanel() {
        return axisXControllerPanel;
    }

    public EPOSControllerPanel getAxisZControllerPanel() {
        return axisZControllerPanel;
    }

    public LPCAxisXPanel getLpcAxisXPanel() {
        return lpcAxisXPanel;
    }

    public LPCAxisZPanel getLpcAxisZPanel() {
        return lpcAxisZPanel;
    }
    
    
    @Override
    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, List<String> hardwareNames) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
    
   
    
    private void initPanels() {
        //controllers Panels
        axisXControllerPanel = new EPOSControllerPanel("Axis X Controller");
        axisZControllerPanel = new EPOSControllerPanel("Axis Y Controller");
        lpcAxisXPanel = new LPCAxisXPanel();
        lpcAxisZPanel = new LPCAxisZPanel();
    }


    void updateAxisXControllerPanel(StatusDataPublishedByEPOSController s) {
        axisXControllerPanel.updateController(s);
    }

    void updateAxisZControllerPanel(StatusDataPublishedByEPOSController s) {
        axisZControllerPanel.updateController(s);
    }

    @Override
    public void onStatusMessage(StatusMessage msg) {
          // Safe cast : filtering ensures we only receive StatusSubsystemData messages
        StatusSubsystemData d = (StatusSubsystemData)msg;
        KeyValueData data = (KeyValueData)d.getObject();
        FCSLOG.debug(getName() + " read data dataType:" + data.getKey());
        switch (data.getKey()) {
            case "tcpProxy":
                updateCanOpenHardwarePanel((StatusDataPublishedByHardware) data.getValue());
                break;

            case "axisXController":
                updateAxisXControllerPanel((StatusDataPublishedByEPOSController) data.getValue());
                break;

            case "axisZController":
               updateAxisZControllerPanel((StatusDataPublishedByEPOSController) data.getValue());
               break;

            default:
                FCSLOG.warning(getName() + " An unexpected dataType was read on the status bus:" + data.getKey());
                break;
        }
    }

    
}
