/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.testbench.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.*;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import static org.lsst.ccs.subsystems.fcs.FCSCst.CHANGER_TCPPROXY_NAME;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenHardwareListPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GatherPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.PlutoGatewayPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.SubsystemPanel;

/**
 * This panel gathers all the panels needed for the CPPM testbench. It takes
 * care of the initialization of the panels and the update of the panels.
 *
 * @author virieux
 */
public class TestbenchCPPMGatherPanel extends GatherPanel {
    private static final long serialVersionUID = -4965366600304567533L;

    //protected AutochangerGeneralGUI subs;
    protected TestbenchCPPMGUI subs;

    //Subsystem PAnel
    private final SubsystemPanel subsystemPanel = new SubsystemPanel("TestbenchCPPM Subsystem State");

    protected EPOSControllerPanel linearRailMasterControllerPanel;
    protected EPOSControllerPanel linearRailSlaveControllerPanel;
    protected EPOSControllerPanel latchXminusControllerPanel;
    protected EPOSControllerPanel onlineClampXminusControllerPanel;
    protected PlutoGatewayPanel plutoGatewayPanel;

    //Exchanger hardware panels
    AutochangerOnlineClampPanel onlineClampPanel;
    AutochangerTrucksPanel acTrucksPanel;
    AutochangerLatchPanel latchPanel;

    public TestbenchCPPMGatherPanel() {
        super(CHANGER_TCPPROXY_NAME);
        initPanels();
    }

    public TestbenchCPPMGatherPanel(TestbenchCPPMGUI subs, String tcpProxyName) {
        super(tcpProxyName);
        initPanels();
        this.subs = subs;
        this.latchPanel.setSubsystem(subs);
        this.acTrucksPanel.setSubsystem(subs);
        this.linearRailMasterControllerPanel.setSubsystem(subs);
        this.linearRailSlaveControllerPanel.setSubsystem(subs);
        this.latchXminusControllerPanel.setSubsystem(subs);
        this.onlineClampXminusControllerPanel.setSubsystem(subs);
    }


    public AutochangerTrucksPanel getAcTrucksPanel() {
        return acTrucksPanel;
    }

    public AutochangerOnlineClampPanel getOnlineClampPanel() {
        return onlineClampPanel;
    }

    public AutochangerLatchPanel getLatchPanel() {
        return latchPanel;
    }


    public EPOSControllerPanel getLinearRailMasterControllerPanel() {
        return linearRailMasterControllerPanel;
    }

    public EPOSControllerPanel getLinearRailSlaveControllerPanel() {
        return linearRailSlaveControllerPanel;
    }

    public EPOSControllerPanel getLatchXminusControllerPanel() {
        return latchXminusControllerPanel;
    }

    public EPOSControllerPanel getOnlineClampXminusControllerPanel() {
        return onlineClampXminusControllerPanel;
    }

    public PlutoGatewayPanel getPlutoGatewayPanel() {
        return plutoGatewayPanel;
    }

    @Override
    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, List<String> hardwareNames) 
            throws InterruptedException, InvocationTargetException {
        super.initializeGUIWithConfigInfo(configInfo,hardwareNames);
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    @Override
    public void onStatusMessage(StatusMessage msg) {
        // Safe cast : filtering ensures we only receive StatusSubsystemData messages
        StatusSubsystemData d = (StatusSubsystemData)msg;
        KeyValueData data = (KeyValueData)d.getObject();
        switch (data.getKey()) {

                case CHANGER_TCPPROXY_NAME:
                    FCSLOG.debug(getName() + " read data dataType:tcpProxy");
                 updateCanOpenHardwarePanel((StatusDataPublishedByHardware) data.getValue());
                    break;

                case "linearRailMasterController":
                    FCSLOG.debug(getName() + " read data dataType:linearRailMasterController");
                    updateLinearRailMasterController((StatusDataPublishedByEPOSController) data.getValue());
                    break;

                case "linearRailSlaveController":
                    FCSLOG.debug(getName() + " read data dataType:linearRailSlaveController");
                 updateLinearRailSlaveController((StatusDataPublishedByEPOSController) data.getValue());
                    break;

                case "latchController":
                    FCSLOG.debug(getName() + " read data dataType:latchXminusController");
                   updateLatchXminusController((StatusDataPublishedByEPOSController) data.getValue());
                    break;

                case "onlineClampController":
                    FCSLOG.debug(getName() + " read data dataType:onlineClampController");
                   updateOnlineClampXminusController((StatusDataPublishedByEPOSController) data.getValue());
                    break;

                case "autochangerTrucks":
                    FCSLOG.debug(getName() + " read data dataType:trucks");
                    FCSLOG.finest(getName() + " Data published by Trucks= " + ((StatusDataPublishedByAutoChangerTrucks) data.getValue()).toString());
                  updateTrucks((StatusDataPublishedByAutoChangerTrucks) data.getValue());
                    break;

                case "latchXminus":
                    FCSLOG.debug(getName() + " read data dataType:latchXminus");
                    FCSLOG.finest(getName() + " Data published by Latch= " + ((StatusDataPublishedByAutochangerLatch) data.getValue()).toString());
                updateLatch((StatusDataPublishedByAutochangerLatch) data.getValue());
                    break;

                case "onlineClampXminus":
                    FCSLOG.debug(getName() + " read data dataType:onlineClampXminus");
                    FCSLOG.debug(getName() + " Data published by ClampXminus= "
                            + ((StatusDataPublishedByAutochangerOnlineClamp) data.getValue()).toString());
                updateClampXminus(
                            (StatusDataPublishedByAutochangerOnlineClamp) data.getValue());
                    break;

                default:
                    FCSLOG.warning(getName() + " An unexpected dataType was read on the status bus:" 
                            + data.getKey());
                    break;
            }
    }

    

    /**
     * Initialization of the GUI for data stored in Configuration. *
     */
    private class GuiInitialization implements Runnable {

        ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;

        }

        @Override
        public void run() {
            /**
             * Autochanger Latch Panel *
             */
            latchPanel.initializeGui(configInfo);
          

            /**
             * Linear Rail Master Controller Panel *
             */
            linearRailMasterControllerPanel.initializeGui(configInfo);

            /**
             * Linear Rail Slave Controller Panel*
             */
            linearRailSlaveControllerPanel.initializeGui(configInfo);

            /**
             * Latch Xminus Controller Panel*
             */
            latchXminusControllerPanel.initializeGui(configInfo);

            /**
             * Online Clamp Xminus Controller Panel*
             */
            onlineClampXminusControllerPanel.initializeGui(configInfo);

            /**
             * PlutoGateway Panel*
             */
            plutoGatewayPanel.initializeGui(configInfo);

        }
    }


    void updateLinearRailMasterController(StatusDataPublishedByEPOSController s) {
        linearRailMasterControllerPanel.updateController(s);
    }

    void updateLinearRailSlaveController(StatusDataPublishedByEPOSController s) {
        linearRailSlaveControllerPanel.updateController(s);
    }

    void updateLatchXminusController(StatusDataPublishedByEPOSController s) {
        latchXminusControllerPanel.updateController(s);
    }

    void updateOnlineClampXminusController(StatusDataPublishedByEPOSController s) {
        onlineClampXminusControllerPanel.updateController(s);
    }

    void updateClampXminus(StatusDataPublishedByAutochangerOnlineClamp s) {
        this.onlineClampPanel.updateClamp(s);
    }

    void updateLatch(StatusDataPublishedByAutochangerLatch s) {
        this.latchPanel.updateLatch(s);
    }

    void updateTrucks(StatusDataPublishedByAutoChangerTrucks s) {
        FCSLOG.finest(" Data published by Trucks= " + s.toString());
        this.acTrucksPanel.updateTrucks(s);
    }

    private void initPanels() {
        //CANopen devices panel
        hardwarePanel = new CanOpenHardwareListPanel(CHANGER_TCPPROXY_NAME);
        //controllers Panels
        linearRailMasterControllerPanel = new EPOSControllerPanel("linearRailMasterController");
        linearRailSlaveControllerPanel = new EPOSControllerPanel("linearRailSlaveController");
        latchXminusControllerPanel = new EPOSControllerPanel("latchXminusController");
        onlineClampXminusControllerPanel = new EPOSControllerPanel("onlineClampXminusController");
        //plutoGatewayPanel
        plutoGatewayPanel = new PlutoGatewayPanel("plutoGateway");

        onlineClampPanel = new AutochangerOnlineClampPanel("onlineClampXminus");
        latchPanel = new AutochangerLatchPanel("latchXminus");
        acTrucksPanel = new AutochangerTrucksPanel("trucks");
    }

}
