package org.lsst.ccs.subsystems.fcs.singlefiltertest.ui;

import javax.swing.JScrollPane;

import javax.swing.*;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import static org.lsst.ccs.subsystems.fcs.FCSCst.CHANGER_TCPPROXY_NAME;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralPanel;

/**
 * A Graphical User Interface for the single-filter-test.
 * @author max
 */
public class SingleFilterTestGUI extends GeneralGUI {

    private static final String name = "SingleFilterTestModelGUIModule";
    private static final long serialVersionUID = 1L;

    public SingleFilterTestGUI(String name, String destination, AgentMessagingLayer aml) {
        super(name, destination, aml);
        SingleFilterTestGatherPanel sftGatherPanel = new SingleFilterTestGatherPanel(this, CHANGER_TCPPROXY_NAME);
        SingleFilterTestBottomPanel sftBottomPanel = new SingleFilterTestBottomPanel(sftGatherPanel, "SINGLE_FILTER_TEST");
        this.generalPanel = new GeneralPanel(this, sftBottomPanel);
        pane = new JScrollPane(generalPanel);
    }

    
    
    

    @Override
    public String getName() {
        return name;
    }

    @Override
    public JComponent getGuiLayout() {
        return pane;
    }

    @Override
    public void resetGui() {
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        Agent agent = new Agent(name, AgentInfo.AgentType.CONSOLE);
        SingleFilterTestGUI t = new SingleFilterTestGUI(agent.getName(),
                "single-filter-test", agent.getMessagingAccess());

        t.initGui();
        agent.start();

        JFrame frame = new JFrame("Single Filter Test Subsystem");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }

}
