/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest.ui;

import javax.swing.tree.DefaultMutableTreeNode;
import static org.lsst.ccs.subsystems.fcs.FCSCst.CHANGER_TCPPROXY_NAME;
import org.lsst.ccs.subsystems.fcs.ui.commons.BottomPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GatherPanel;

/**
 *
 * @author virieux
 */
public class SingleFilterTestBottomPanel extends BottomPanel {
    private static final long serialVersionUID = -4843093674943209166L;

    public SingleFilterTestBottomPanel(GatherPanel gatherPanel, String title) {
        super(gatherPanel, title);
    }
    
    @Override
    public void createNodes(DefaultMutableTreeNode top) {

        if (gatherPanel == null) {
            gatherPanel = new SingleFilterTestGatherPanel(CHANGER_TCPPROXY_NAME);
        }
        

        
        /** CANopen devices panels*/
        DefaultMutableTreeNode devicesNode = new DefaultMutableTreeNode("CANopen devices");
        devicesNode.add(new DefaultMutableTreeNode(gatherPanel.getHardwarePanel()));
        devicesNode.add(new DefaultMutableTreeNode(((SingleFilterTestGatherPanel) gatherPanel).getAi814Panel()));
        devicesNode.add(new DefaultMutableTreeNode(((SingleFilterTestGatherPanel) gatherPanel).getAo412Panel()));
        devicesNode.add(new DefaultMutableTreeNode(((SingleFilterTestGatherPanel) gatherPanel).getDio8n1Panel()));
        devicesNode.add(new DefaultMutableTreeNode(((SingleFilterTestGatherPanel) gatherPanel).getDio8n2Panel()));
        devicesNode.add(new DefaultMutableTreeNode(((SingleFilterTestGatherPanel) gatherPanel).getClampXminusControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((SingleFilterTestGatherPanel) gatherPanel).getClampXplusControllerPanel()));
        
        
        top.add(devicesNode);
        
        /** General view */
        top.add(new DefaultMutableTreeNode(((SingleFilterTestGatherPanel) gatherPanel).getSftExchangePanel()));
    }
    
}
