/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * DigitalSwitch.java
 *
 * Created on Oct 4, 2012, 2:11:07 AM
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import javax.swing.JFrame;

/**
 *
 * @author turri
 */
public class MovementPanel extends javax.swing.JPanel {
    private static final long serialVersionUID = 1L;

    private Color standingColor = new Color(204, 205, 255);
    private int step = 15;
    private Color upArrowColor = standingColor;
    private Color downArrowColor = standingColor;

    /**
     * Creates new form DigitalSwitch
     */
    public MovementPanel() {
        initComponents();
        setPreferredSize(new Dimension(8 * step, 6 * step));
    }

    @Override
    public void setBackground(Color bg) {
        setColor(bg);
    }

    public void setStatus(boolean isMovingUp, boolean isMovingDown) {
        upArrowColor = isMovingUp ? Color.blue : standingColor;
        downArrowColor = isMovingDown ? Color.blue : standingColor;
        repaint();
    }

    public void setColor(Color c) {
        this.standingColor = c;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.addRenderingHints(hints);

        int step = 15;
        int[] x = new int[]{2 * step, 4 * step, 3 * step, 3 * step, 1 * step, 1 * step, 0};
        int[] y = new int[]{0, 2 * step, 2 * step, 6 * step, 6 * step, 2 * step, 2 * step};

        Polygon upArrow = new Polygon(x, y, 7);

        g2.setColor(upArrowColor);
        g2.fillPolygon(upArrow);

        int[] x1 = new int[]{6 * step, 4 * step, 5 * step, 5 * step, 7 * step, 7 * step, 8 * step};
        int[] y1 = new int[]{6 * step, 4 * step, 4 * step, 0, 0, 4 * step, 4 * step};

        Polygon downArrow = new Polygon(x1, y1, 7);

        g2.setColor(downArrowColor);
        g2.fillPolygon(downArrow);

//        float width = getWidth();
//        float height = getHeight();
//        float width = size;
//        float height = size;
//        float actualWidth = Math.min(width, height);
//
//        float border = 1;
//
//        // Draw the outline
//        Shape outerCircle = new Arc2D.Double(border, border, actualWidth - 2 * border, actualWidth - 2 * border, 0, 360, Arc2D.CHORD);
//        g2.setStroke(new BasicStroke(1));
//        g2.setColor(Color.gray);
//        g2.fill(outerCircle);
//        g2.draw(outerCircle);
//        
//        actualWidth = actualWidth - 20;
//        Arc2D filterCircle = new Arc2D.Double(border+10, border+10, actualWidth - 2 * border, actualWidth - 2 * border, 0, 360, Arc2D.CHORD);
//        g2.setStroke(new BasicStroke(1));
//        g2.setColor(color);
//        g2.fill(filterCircle);
//        g2.setColor(Color.black);
//        g2.draw(filterCircle);
//        
////        g2.drawString("Filter in", actualWidth * 0.35f, actualWidth / 2);
//        
//        
    }

    public static void main(String[] argv) {

        MovementPanel d = new MovementPanel();
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        setForeground(new java.awt.Color(204, 204, 255));

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 400, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 300, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
}
