/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderHook;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.greenColor;

/**
 *
 * @author virieux
 */
public class LoaderHookPanel extends JPanel {

    protected static final int LEFT = 0, RIGHT = 1;
    private static final long serialVersionUID = 6930078848107595811L;
    
    private final String hookName;

    // Variables declaration                     
    private DigitalSwitch hookError;
    private JLabel hookErrorLabel;
    private DigitalSwitch hookLockSensor;
    private JLabel hookLockStatus;
    private JLabel hookNameLabel;
    private DigitalSwitch hookUnlockSensor;
    private JLabel jLabel1;
    private JLabel jLabel2;
    // End of variables declaration 

    /**
     * Creates new form LoaderMainPanel
     * @param hookName
     */
    public LoaderHookPanel(String hookName) {
        this.hookName = hookName;
        
        initComponents();
        hookUnlockSensor.setColor(Color.gray);
        hookLockSensor.setColor(Color.gray);
        hookError.setColor(Color.gray);
        hookLockStatus.setText("UNKNOWN STATE");
    }


    // if we want to inverse the display of the hook for the hooks displayed on the right,
    // we have to do : setHookLocation(RIGHT)
    protected void setHookLocation(int pos) {
        switch (pos) {
            case 1:
                GridBagLayout layout = (GridBagLayout) getLayout();

                // Move the label to the right by two places
                GridBagConstraints hookNameConst = layout.getConstraints(hookNameLabel);
                hookNameConst.gridx = hookNameConst.gridx + 2;
                layout.setConstraints(hookNameLabel, hookNameConst);

                // Move the locked sensor to the left by two spaces
                GridBagConstraints lockedSensorConst = layout.getConstraints(hookLockSensor);
                lockedSensorConst.gridx = lockedSensorConst.gridx - 2;
                layout.setConstraints(hookLockSensor, lockedSensorConst);
                break;
                
            default:
                assert false;
        }
    }

    public void updateHook(StatusDataPublishedByLoaderHook statusDataPublishedByLoaderHook) {
        SwingUtilities.invokeLater(new UpdateHook(statusDataPublishedByLoaderHook));
    }

    /**
     * A Runnable to update this panel from data published on the STATUS bus by a Loader Hook.
     */
    private class UpdateHook implements Runnable {

        private final StatusDataPublishedByLoaderHook s;

        public UpdateHook(StatusDataPublishedByLoaderHook statusDataPublishedByLoaderHook) {
            this.s = statusDataPublishedByLoaderHook;
        }

        @Override
        public void run() {
            hookNameLabel.setText(hookName);
            hookUnlockSensor.setColor(s.getUnlockSensorValue() == 1 ? greenColor : Color.gray);
            hookLockSensor.setColor(s.getLockSensorValue() == 1 ? greenColor : Color.gray);
            boolean inTravel = (s.getUnlockSensorValue() == 0) && (s.getLockSensorValue() == 0);
            if (s.isInError()) {
                hookError.setColor(Color.RED);
                hookErrorLabel.setText("IN ERROR");
            } else if (inTravel) {
                hookError.setColor(Color.YELLOW);
                hookErrorLabel.setText("IN TRAVEL");
            } else if (s.getLockStatus().equals(LockStatus.UNKNOWN)) {
                hookError.setColor(Color.DARK_GRAY);
                hookErrorLabel.setText("UNKNOWN");
            } else {
                hookError.setColor(Color.GREEN);
                hookErrorLabel.setText("NO ERROR");
            }
            hookLockStatus.setText(s.getLockStatus().toString());
            Color hookLockStatusColor = s.getLockStatus().getColor();
            hookLockStatus.setBackground(hookLockStatusColor);
        }
    }

    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form description"> 
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        hookNameLabel = new javax.swing.JLabel();
        hookUnlockSensor = new org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch();
        hookLockSensor = new org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        hookError = new org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch();
        hookErrorLabel = new javax.swing.JLabel();
        hookLockStatus = new javax.swing.JLabel();

        setBorder(javax.swing.BorderFactory.createEtchedBorder());
        setForeground(new java.awt.Color(204, 204, 255));
        setLayout(new java.awt.GridBagLayout());

        hookNameLabel.setText("hook1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 14;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 6);
        add(hookNameLabel, gridBagConstraints);

        javax.swing.GroupLayout hookUnlockSensorLayout = new javax.swing.GroupLayout(hookUnlockSensor);
        hookUnlockSensor.setLayout(hookUnlockSensorLayout);
        hookUnlockSensorLayout.setHorizontalGroup(
                hookUnlockSensorLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGap(0, 23, Short.MAX_VALUE)
        );
        hookUnlockSensorLayout.setVerticalGroup(
                hookUnlockSensorLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGap(0, 23, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        add(hookUnlockSensor, gridBagConstraints);

        javax.swing.GroupLayout hookLockSensorLayout = new javax.swing.GroupLayout(hookLockSensor);
        hookLockSensor.setLayout(hookLockSensorLayout);
        hookLockSensorLayout.setHorizontalGroup(
                hookLockSensorLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGap(0, 23, Short.MAX_VALUE)
        );
        hookLockSensorLayout.setVerticalGroup(
                hookLockSensorLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGap(0, 23, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        add(hookLockSensor, gridBagConstraints);

        jLabel1.setText("<html><P align=\"center\">UNLOCK<br>SENSOR</p></html>");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 6;
        gridBagConstraints.insets = new java.awt.Insets(0, 7, 0, 7);
        add(jLabel1, gridBagConstraints);

        jLabel2.setText("<html><P align=\"center\">LOCK<br>SENSOR</p></html>");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.insets = new java.awt.Insets(0, 7, 0, 7);
        add(jLabel2, gridBagConstraints);

        javax.swing.GroupLayout hookErrorLayout = new javax.swing.GroupLayout(hookError);
        hookError.setLayout(hookErrorLayout);
        hookErrorLayout.setHorizontalGroup(
                hookErrorLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGap(0, 20, Short.MAX_VALUE)
        );
        hookErrorLayout.setVerticalGroup(
                hookErrorLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGap(0, 20, Short.MAX_VALUE)
        );

        add(hookError, new java.awt.GridBagConstraints());

        hookErrorLabel.setText("ERROR");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 35, 0, 35);
        add(hookErrorLabel, gridBagConstraints);

        hookLockStatus.setFont(new java.awt.Font("Lucida Grande", 1, 14)); // NOI18N
        hookLockStatus.setText("hookState");
        hookLockStatus.setBorder(javax.swing.BorderFactory.createEtchedBorder(new java.awt.Color(0, 255, 255), null));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 18, 0, 18);
        add(hookLockStatus, gridBagConstraints);
    }

    public static void main(String[] argv) {

        JFrame frame = new JFrame("New Loader Hook Panel");
        LoaderHookPanel d = new LoaderHookPanel("my_hook");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }

}
