/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.greenColor;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 * A view to display a global view of the loader.
 * To be continued....
 * @author virieux
 */
public class LoaderGeneralViewPanel extends JPanel {
    private static final long serialVersionUID = 8834267363875256916L;
    private LoaderGUI subs;

    private final JLabel onCameraLabel = new JLabel("ON CAMERA SENSOR");
    private final JLabel autochangerHoldingFilterLabel = new JLabel("AUTOCHANGER HOLDING FILTER SENSOR");
    private final JPanel fakeSensorsPanel = new JPanel();
    private final JPanel controlPanel = new JPanel();
    private final DigitalSwitch onCameraDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch autochangerHoldingFilterDigitalSwitch = new DigitalSwitch();
    //control panel    
    private final JButton loadFilterButton = new JButton("loadFilterInCamera");
    private final JButton unloadFilterButton = new JButton("unloadFilterFromCamera");
    // End of variables declaration 
    
    
    /**
     * A Runnable To updateState the general items for loader.
     */
    class UpdateLoaderGeneral implements Runnable {

        private final StatusDataPublishedByLoader s;

        UpdateLoaderGeneral(StatusDataPublishedByLoader s) {
            this.s = s;
        }

        @Override
        public void run() {

            if (s.isLoaderOnCameraSensorsInError()) {
                onCameraDigitalSwitch.setColor(Color.RED);
            } else {
                onCameraDigitalSwitch.setColor(s.getLoaderOnCameraSensorValue0() == 1 ? greenColor : Color.gray);
            }
            autochangerHoldingFilterDigitalSwitch.setColor(s.getAutochangerHoldingFilterSensorValue() == 1 ? greenColor : Color.gray);
        }
    }

    /**
     * A constructor without any argument for tests.
     */
    public LoaderGeneralViewPanel() {
        initComponents();
    }
    
    

    /**
     * A constructor with a LoaderGUI.
     * @param subs 
     */
    public LoaderGeneralViewPanel(LoaderGUI subs) {
        this.subs = subs;
        initComponents();
    }

    public void setSubsystem(LoaderGUI subs) {
        this.subs = subs;
    }
    
    /**
     * Initialize this Panel from Configuration Info data.
     * TODO : initialize timeouts for commands unloadFilter and loadFilter ?
     * @param configInfo 
     */
    public void initializeGui(ConfigurationInfo configInfo) {
        //TODO if needed : SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }
    
    
    /**
     * To update the Panel when the loader publishes on the bus its global status.
     * @param status 
     */
    public void updateLoaderGeneral(StatusDataPublishedByLoader status) {
        SwingUtilities.invokeLater(new UpdateLoaderGeneral(status));
    }
    
    /**
     * To initialize all the components of this Panel.
     */
    // <editor-fold defaultstate="collapsed" desc="Form Description">
    private void initComponents() {
        setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new java.awt.Color(255, 255, 0)), "LOADER"));
        setForeground(new Color(204, 204, 255));
        setLayout(new GridBagLayout());

        /**
         ******************************************************************************
         ** Control Panel
         * *****************************************************************************
         */
        loadFilterButton.addActionListener((ActionEvent evt) -> {
            loadFilterActionPerformed(evt);
        });

        unloadFilterButton.addActionListener((ActionEvent evt) -> {
            unloadFilterActionPerformed(evt);
        });
        controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.insets = insets_std;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.fill = GridBagConstraints.HORIZONTAL;
        controlPanel.add(loadFilterButton, gbc0);
        gbc0.gridy++;
        controlPanel.add(unloadFilterButton, gbc0);
         //end of Control Panel

        //Fake Sensors Panel 
        onCameraDigitalSwitch.setColor(Color.gray);
        autochangerHoldingFilterDigitalSwitch.setColor(Color.gray);
        fakeSensorsPanel.setBorder(BorderFactory.createTitledBorder("FAKE SENSORS"));
        fakeSensorsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.fill = GridBagConstraints.HORIZONTAL;
        fakeSensorsPanel.add(onCameraLabel, gbc1);

        gbc1.gridx++;
        fakeSensorsPanel.add(onCameraDigitalSwitch, gbc1);

        gbc1.insets = new Insets(0, 60, 0, 4);
        gbc1.gridx++;
        fakeSensorsPanel.add(autochangerHoldingFilterLabel, gbc1);
        gbc1.insets = insets_std;
        gbc1.gridx++;
        fakeSensorsPanel.add(autochangerHoldingFilterDigitalSwitch, gbc1);
        //end Fake Sensors Panel 

        //Whole Panel
        GridBagConstraints gbc = new GridBagConstraints();

        gbc.anchor = java.awt.GridBagConstraints.BASELINE_LEADING;
        gbc.insets = insets_std;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        add(controlPanel, gbc);

        //gbc.anchor = java.awt.GridBagConstraints.CENTER;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy++;
        add(fakeSensorsPanel, gbc);
    }
    
    private void loadFilterActionPerformed(ActionEvent evt) {
        subs.loadFilter();
    }

    private void unloadFilterActionPerformed(ActionEvent evt) {
        subs.unloadFilter();
    }
    
    /**
     * To be displayed on the GUI. 
     * @return 
     */
    @Override
    public String toString() {
        return "Loader General View Panel";
    }
    
    /**
     * Just for tests.
     * @param args 
     */
    public static void main(String[] args) {
        LoaderGeneralViewPanel d = new LoaderGeneralViewPanel();
        JFrame frame = new JFrame("Loader Main Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }
}
