/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import org.lsst.ccs.subsystems.fcs.ui.commons.VerticalProgressBarPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.ui.commons.FilterPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.BIG_FONT;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_big;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 *
 * @author virieux
 */
public class LoaderClampPanel extends JPanel {

    private static final long serialVersionUID = -6313746913674371727L;
    private final String clampName;
    private LoaderGUI subs;

    private final JLabel clampState = new JLabel("UNKNOWN STATE");
    private final JLabel clampStateLabel = new JLabel("Clamp State :");
    private final JLabel xMinusLabel = new JLabel("X-");
    private final JLabel xMinuxLabel2 = new JLabel("X-");
    private final JLabel xPlusLabel = new JLabel("X+");
    private final JLabel xPlusLabel2 = new JLabel("X+");

    private LoaderHookPanel hookPanel1;
    private LoaderHookPanel hookPanel2;
    private LoaderHookPanel hookPanel3;
    private LoaderHookPanel hookPanel4;
    private final FilterPanel filterPanel = new FilterPanel();
    private VerticalProgressBarPanel positionProgressBarPanel;
    private VerticalProgressBarPanel currentProgressBarPanel;
    private JButton closeHooksButton;
    private JButton openHooksButton;
    private JButton goToClampedPositionButton;
    private JButton goToHomePositionButton;
    private JButton clampHooksButton;
    private JButton updateStateWithSensorsButton;
    private JButton abortButton;
    // End of variables declaration                



    /**
     * A Runnable to initialize this panel from configuration data.
     */
    private class GuiInitialization implements Runnable {

        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            /** Retrieve the configuration data for my name.*/
            Map<String, String> configForClamp = configInfo.getCurrentValuesForComponent(clampName);
            
            positionProgressBarPanel.setMinValue(Tools.getInt(configForClamp, clampName, "minPosition"));
            positionProgressBarPanel.setMaxValue(Tools.getInt(configForClamp, clampName, "maxPosition")); 
            positionProgressBarPanel.setValue(0);
            currentProgressBarPanel.setMinValue(Tools.getInt(configForClamp, clampName, "minCurrent")); 
            currentProgressBarPanel.setMaxValue(Tools.getInt(configForClamp, clampName, "maxCurrent"));
            currentProgressBarPanel.setValue(0);
            
            /** Initialization of the timeouts for the buttons commands.*/
            subs.openHooksTimeout = Tools.getInt(configForClamp, clampName, "timeoutForOpeningHooks");
            subs.closeHooksTimeout = Tools.getInt(configForClamp, clampName, "timeoutForClosingHooks");
            subs.clampHooksTimeout = Tools.getInt(configForClamp, clampName, "timeoutForClampingHooks");
            subs.homingHooksTimeout = Tools.getInt(configForClamp, clampName, "timeoutForGoingToHomePosition");
        }
    }

    /**
     * A Runnable to update this panel from data published on the status bus from the Loader Clamp.
     */
    private class UpdateClamp implements Runnable {

        private final StatusDataPublishedByLoaderClamp s;

        public UpdateClamp(StatusDataPublishedByLoaderClamp status) {
            this.s = status;
        }

        @Override
        public void run() {

            Color clampStateColor = s.getClampState().getColor();
            int clampPosition = s.getPosition();
            clampState.setText(s.getClampState().getText());
            clampState.setForeground(clampStateColor);
            positionProgressBarPanel.setValue(clampPosition);
            positionProgressBarPanel.setColor(clampStateColor);
            currentProgressBarPanel.setValue(s.getCurrent());
            hookPanel1.updateHook(s.getStatusPublishedByHook1());
            hookPanel2.updateHook(s.getStatusPublishedByHook2());
            hookPanel3.updateHook(s.getStatusPublishedByHook3());
            hookPanel4.updateHook(s.getStatusPublishedByHook4());

        }
    }
    
    /**
     * A Runnable to update this panel from data published on the status bus from the Loader Carrier.
     */
    private class UpdateFilterPanel implements Runnable {

        private final StatusDataPublishedByLoader s;

        public UpdateFilterPanel(StatusDataPublishedByLoader s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (s.isFilterPresenceSensorsInError()) {
                filterPanel.setColor(Color.red);
            } else {
                filterPanel.setIsFilterInHouse(s.getFilterPresenceSensorValue0() == 1, "dummyFilter");
            }
        }

    }
    
    /**
     * Creates new form LoaderClampPanel
     * @param clampName
     */
    public LoaderClampPanel(String clampName) {
        this.clampName = clampName;
        initComponents();
    }

    public void setSubsystem(LoaderGUI subs) {
        this.subs = subs;
    }

    public void initializeGui(ConfigurationInfo config) {
        SwingUtilities.invokeLater(new GuiInitialization(config));
    }

    public void updateClamp(StatusDataPublishedByLoaderClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }

    public void updateClamp(StatusDataPublishedByLoader status) {
        SwingUtilities.invokeLater(new UpdateFilterPanel(status));
    }

    /**
     * This method is called from within the constructor to initialize the form.
     */
    // <editor-fold defaultstate="collapsed" desc="Form Description">                          
    private void initComponents() {

        //X- and X+ label
        Font xFont = new Font("Tahoma", 1, 18);
        xMinusLabel.setFont(xFont); // NOI18N      
        xMinuxLabel2.setFont(xFont); // NOI18N
        xPlusLabel2.setFont(xFont); // NOI18N       
        xPlusLabel.setFont(xFont); // NOI18N
        JPanel hooksPanel = new JPanel();
        JPanel clampStatePanel = new JPanel();
        JPanel controlPanel = new JPanel();
        hookPanel1 = new LoaderHookPanel("hook1");
        hookPanel2 = new LoaderHookPanel("hook2");
        hookPanel3 = new LoaderHookPanel("hook3");
        hookPanel4 = new LoaderHookPanel("hook4");
        
        currentProgressBarPanel = new VerticalProgressBarPanel("Current", -300, 500, 0, 1);
        currentProgressBarPanel.setStringPainted(false);
        positionProgressBarPanel = new VerticalProgressBarPanel("Position", 5000, 480000, 0, 1);

        filterPanel.setColor(Color.gray);

        updateStateWithSensorsButton = new JButton("Read sensors and update state");
        openHooksButton = new JButton("Open");
        goToClampedPositionButton = new JButton("Go To Clamped Position");
        clampHooksButton = new JButton("Clamp");
        closeHooksButton = new JButton("Close");
        goToHomePositionButton = new JButton("Go To Home Position");
        abortButton = new JButton("Abort");

        updateStateWithSensorsButton.addActionListener((ActionEvent evt) -> 
            updateStateWithSensorsButtonActionPerformed(evt)
        );

        openHooksButton.addActionListener((ActionEvent evt) -> 
            openHooksButtonActionPerformed(evt)
        );

        goToClampedPositionButton.addActionListener((ActionEvent evt) -> 
            goToClampedPositionButtonActionPerformed(evt)
        );

        clampHooksButton.addActionListener((ActionEvent evt) -> 
            clampHooksButtonActionPerformed(evt)
        );

        closeHooksButton.addActionListener((ActionEvent evt) -> 
            closeHooksButtonActionPerformed(evt)
        );

        goToHomePositionButton.addActionListener((ActionEvent evt) -> 
            goToHomePositionButtonActionPerformed(evt)
        );

        abortButton.addActionListener((ActionEvent evt) -> 
            abortActionPerformed(evt)
        );

        /**
         ******************************************************************************
         ** Clamp State Panel
         * *****************************************************************************
         */
        clampState.setFont(BIG_FONT); // NOI18N
        clampState.setBorder(javax.swing.BorderFactory.createEtchedBorder(new java.awt.Color(255, 255, 255), new java.awt.Color(255, 255, 255)));
        clampStatePanel.setLayout(new java.awt.GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = insets_std;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        clampStatePanel.add(clampStateLabel, gbc2);
        gbc2.gridx++;
        clampStatePanel.add(clampState, gbc2);
        /**
         ******************************************************************************
         ** end of Clamp State Panel
         * *****************************************************************************
         */

        /**
         ******************************************************************************
         ** Hooks Panel
         * *****************************************************************************
         */
        hooksPanel.setLayout(new java.awt.GridBagLayout());
        hooksPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.ORANGE), "Hooks State"));
        GridBagConstraints gbc1 = new java.awt.GridBagConstraints();
        gbc1.insets = insets_std;

        hookPanel1.setHookLocation(LoaderHookPanel.LEFT);
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        hooksPanel.add(hookPanel1, gbc1);

        hookPanel2.setHookLocation(LoaderHookPanel.LEFT);
        gbc1.gridx++;
        hooksPanel.add(hookPanel2, gbc1);

        hookPanel3.setHookLocation(LoaderHookPanel.LEFT);
        gbc1.gridx = 0;
        gbc1.gridy = 1;
        hooksPanel.add(hookPanel3, gbc1);

        hookPanel4.setHookLocation(LoaderHookPanel.LEFT);
        gbc1.gridx++;
        hooksPanel.add(hookPanel4, gbc1);
        /**
         ******************************************************************************
         ** End of Hooks Panel
         * *****************************************************************************
         */

        /**
         ******************************************************************************
         ** Control Panel
         * *****************************************************************************
         */
        controlPanel.setLayout(new java.awt.GridBagLayout());
        GridBagConstraints gbc3 = new java.awt.GridBagConstraints();
        gbc3.anchor = GridBagConstraints.FIRST_LINE_START;
        gbc3.fill = GridBagConstraints.HORIZONTAL;
        gbc3.insets = insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        controlPanel.add(updateStateWithSensorsButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(goToHomePositionButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(goToClampedPositionButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(openHooksButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(closeHooksButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(clampHooksButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(abortButton, gbc3);
        /**
         ******************************************************************************
         ** End of Control Panel
         * *****************************************************************************
         */

        /**
         ******************************************************************************
         ** Whole Panel
         * *****************************************************************************
         */
        setBorder(javax.swing.BorderFactory.createTitledBorder("LOADER CLAMP"));
        //setBorder(javax.swing.BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.PINK),"LOADER CLAMP"));
        //setForeground(new java.awt.Color(204, 204, 255));
        setLayout(new java.awt.GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_std;
        gbc.anchor = GridBagConstraints.WEST;

        gbc.gridx = 0;
        gbc.gridy = 0;
        add(xMinusLabel, gbc);
        gbc.anchor = GridBagConstraints.EAST;
        gbc.gridx = 3;
        add(xPlusLabel, gbc);

        gbc.gridx = 0;
        gbc.gridwidth = 4;
        gbc.anchor = GridBagConstraints.CENTER;
        add(clampStatePanel, gbc);
        gbc.gridy++;
        add(hooksPanel, gbc);

        gbc.insets = insets_big;
        gbc.insets = new Insets(14, 30, 6, 30);
        gbc.gridx = 0;
        gbc.gridy++;
        gbc.gridwidth = 1;
        //add(hooksPositionVerticalProgressBarPanel, gbc);
        add(positionProgressBarPanel, gbc);
        gbc.gridx++;
        //add(actualCurrentVerticalProgressBarPanel, gbc);
        add(currentProgressBarPanel, gbc);
        gbc.gridx++;
        add(filterPanel, gbc);
        gbc.gridx++;
        gbc.anchor = GridBagConstraints.EAST;
        add(controlPanel, gbc);

    }// </editor-fold>                        

    private void updateStateWithSensorsButtonActionPerformed(java.awt.event.ActionEvent evt) {
        subs.updateStateWithSensors();
    }

    private void openHooksButtonActionPerformed(ActionEvent evt) {
        subs.openHooks();
    }

    private void closeHooksButtonActionPerformed(ActionEvent evt) {
        subs.closeHooks();
    }

    private void clampHooksButtonActionPerformed(ActionEvent evt) {
        subs.clampHooks();
    }

    private void goToHomePositionButtonActionPerformed(ActionEvent evt) {
        subs.goToHomePosition();
    }

    private void goToClampedPositionButtonActionPerformed(ActionEvent evt) {
        subs.goToClosePosition();
    }

    private void abortActionPerformed(ActionEvent evt) {
        subs.abortAction();
    }
    
    @Override
    public String toString() {
        return "Clamp Panel";
    }

    public static void main(String[] argv) {

        LoaderClampPanel d = new LoaderClampPanel("myClamp");
        JFrame frame = new JFrame("New Loader Clamp Panel");
        d.currentProgressBarPanel.setValueName("Current");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }

}
