/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByFilter;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 * This Panel's goal is to display the list of filters the subsystem manages.
 * For each filter it's name, ID, weight and location is displayed.
 * 
 * 
 * @author virieux
 */
public class FilterListPanel extends JPanel {
    private static final long serialVersionUID = 2654131875576434801L;
   
    private JTable filterTable;
    private JScrollPane jScrollPane;

    /**
     * Creates a new FilterListPanel and initialize all its components.
     */
    public FilterListPanel() {
        initComponents();
    }
    
     /**
     * Initialization of the GUI from data stored in Configuration. *
     * Definition of a Runnable.
     */
    private class GuiInitialization implements Runnable {

        private final ConfigurationInfo configInfo;
        private final List<String> filterNamesList;


        public GuiInitialization(ConfigurationInfo configInfo,List<String> filterNamesList ) {
            this.configInfo = configInfo;
            /*initialize this.filterNamesList from a copy of the List<String> argument.*/
            this.filterNamesList = new ArrayList<>();
            this.filterNamesList.addAll(filterNamesList);
        }

        @Override
        public void run() {
            /**
             * Filter list panel *
             */
            //configure Filter Table           
            DefaultTableModel filterTableModel = (DefaultTableModel) filterTable.getModel();
            for (String filterName: filterNamesList) {
                Map<String, String> config = configInfo.getCurrentValuesForComponent(filterName);
                Object[] tab = {filterName, 
                    Integer.parseInt(Tools.getText(config, filterName,"filterID")),
                    Double.parseDouble(Tools.getText(config, filterName,"weight")),
                    "UNKNOWN",
                    "UNKNOWN"
                };
                filterTableModel.addRow(tab);
            }
            
            filterTableModel.fireTableDataChanged();

        }
    }
    
    /**
     * A Runnable class to update the Filter List when a Filter publishes on the 
     * Status bus its new location.
     */
    private class UpdateFilterListPanel implements Runnable {

        private final String filterName;
        private final StatusDataPublishedByFilter s;
        

        public UpdateFilterListPanel(String filterName, StatusDataPublishedByFilter status) {
            this.filterName = filterName;
            this.s = status;
        }

        @Override
        public void run() {
            DefaultTableModel filterTableModel = (DefaultTableModel) filterTable.getModel();
            int rowNB = filterTableModel.getRowCount();
            for (int i = 0; i < rowNB; i++) {
                if ((filterTableModel.getValueAt(i, 0)).equals(filterName)) {
                    filterTableModel.setValueAt(s.getLocation(), i, 3);
                    filterTableModel.setValueAt(s.getSocketName(), i, 4);
                }
            }
            filterTableModel.fireTableDataChanged();
        }
    }
    
    
    public void initializeGui(ConfigurationInfo configInfo,List<String> filterNameList) {       
        SwingUtilities.invokeLater(new GuiInitialization(configInfo,filterNameList));
    }

    public void updateFilterListPanel(String filterName, StatusDataPublishedByFilter status) {
        SwingUtilities.invokeLater(new UpdateFilterListPanel(filterName, status));
    }
    
    // <editor-fold defaultstate="collapsed" desc="Form description">                          
    private void initComponents() {
        
        /**
         ******************************************************************************
         ** Initialization of the table of filters
         * *****************************************************************************
         */
        jScrollPane = new JScrollPane();
        filterTable = new JTable();
        filterTable.setModel(new DefaultTableModel(
                new Object[][]{},
                new String[]{
                    "Name", "Filter ID", "Weight", "Location", "Socket number"
                }
        ) {
            private static final long serialVersionUID = 1L;
            private Class[] types = new Class[]{
                String.class, Integer.class, Double.class, String.class, String.class
            };
            private boolean[] canEdit = new boolean[]{
                false, false, false, false, false
            };

            @Override
            public Class getColumnClass(int columnIndex) {
                return types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit[columnIndex];
            }
        });
        TableColumn column;
        for (int i = 0; i < 5; i++) {
            column = filterTable.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setPreferredWidth(100); //first column is bigger
            }
        }
        jScrollPane.setViewportView(filterTable);
        /**
         ******************************************************************************
         ** end of Filter Table Panel
         * *****************************************************************************
         */
        //Whole Panel
        setBorder(BorderFactory.createLineBorder(Color.YELLOW));
        GridBagConstraints gbc = new GridBagConstraints();

        gbc.anchor = java.awt.GridBagConstraints.BASELINE_LEADING;
        gbc.insets = insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        add(jScrollPane, gbc);
        
    }
    
    @Override
    public String toString() {
        return "Filters list";
    }
    
    /**
     * to test 
     * @param argv 
     */
    public static void main(String[] argv) {
        
        FilterListPanel p = new FilterListPanel();
                //p.initializeGui(tcpConfig);

        JFrame frame = new JFrame("FILTERS");
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        
    }
    
}
