/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import static org.lsst.ccs.subsystems.fcs.FCSCst.CHANGER_TCPPROXY_NAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;

/**
 * A GUI for the carousel in standalone mode.
 * 
 * @author virieux
 */
public class CarouselGUI extends GeneralGUI {
    private static final long serialVersionUID = 3716082311687590505L;
    
    private final long timeoutForOpeningClamps;
    private final long timeoutForRotation;

    /**
     * A constructor with a name, a destination (subsystem name) and an AgentMessagingLayer.
     * @param name
     * @param destination
     * @param aml 
     */
    public CarouselGUI(String name, String destination, AgentMessagingLayer aml) {
        super(name, destination, aml);
        CarouselGatherPanel carouselGatherPanel;
        carouselGatherPanel = new CarouselGatherPanel(this, CHANGER_TCPPROXY_NAME);
        CarouselBottomPanel carouselBottomPanel = new CarouselBottomPanel(carouselGatherPanel, "CAROUSEL");
        this.generalPanel = new GeneralPanel(this, carouselBottomPanel);
        pane = new JScrollPane(generalPanel);
        
        //TODO to be initialized from the configuration system
        this.timeoutForOpeningClamps = 10000;
        this.timeoutForRotation = 10000;
    }
    
    /**
     ******************************************************************************
     ** Carousel Rotation
     * *****************************************************************************
     */
    public void rotate() {
        FCSLOG.info("Carousel rotating");
        FCSLOG.info("/timeout=" + this.timeoutForRotation);
        new GeneralGUI.CommandSwingWorker("rotate", this.timeoutForRotation).execute();
    }


    /**
     ******************************************************************************
     ** end of Trucks Actions
     * *****************************************************************************
     */
    /**
     ******************************************************************************
     ** Clamps Actions
     * *****************************************************************************
     */
    public void unlockClamps() {
        FCSLOG.info("Carousel unlocking clamps");
        FCSLOG.info("/timeout=" + timeoutForOpeningClamps);
        new GeneralGUI.CommandSwingWorker("unlockClamps", this.timeoutForOpeningClamps).execute();
    }

    /**
     ******************************************************************************
     ** end of Clamps Actions
     * *****************************************************************************
     */


    
     /**
     * This main launches an carousel GUI for the subsystem "carousel".
     * It's used only for tests.
     * 
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        Agent agent = new Agent("CarouselGUI", AgentInfo.AgentType.CONSOLE);
        CarouselGUI t = new CarouselGUI(agent.getName(), "carousel", 
                agent.getMessagingAccess());
        agent.start();

        JFrame frame = new JFrame("Carousel View GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }
    
}
