/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import static org.lsst.ccs.subsystems.fcs.FCSCst.NO_FILTER;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;

/**
 * A disk to represent the Carousel and its rotation.
 * @author virieux
 */
public class CarouselDisk extends JComponent {
    private static final long serialVersionUID = -2896017577739118272L;
    
    private double rotationInDegrees = 0;
    private boolean locked = false;
    private String filterOnAutochanger;
    /*List of filterNames by socketName*/
    private transient Map<String,String> socketFilterMap;

    public CarouselDisk() {
        setPreferredSize(new Dimension(400, 400));
        socketFilterMap = new TreeMap<>();
        socketFilterMap.put("socket1", NO_FILTER);
        socketFilterMap.put("socket2", NO_FILTER);
        socketFilterMap.put("socket3", NO_FILTER);
        socketFilterMap.put("socket4", NO_FILTER);
        socketFilterMap.put("socket5", NO_FILTER);
    }

    public void setRotationInDegrees(float rotationInDegrees) {
        this.rotationInDegrees = rotationInDegrees;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setFilterInCamera(String filterInCamera) {
        this.filterOnAutochanger = filterInCamera;
    }
    
    /**
     * Update the disk from an object StatusDataPublishedByCarousel
     * @param status 
     */
    public void update(StatusDataPublishedByCarousel status) {
        FCSLOG.info("CarouselDisk update from STATUS data.");
        this.rotationInDegrees = status.getRotationInDegrees();
        this.filterOnAutochanger = status.getFilterOnAutochangerName();

        /*List of filterNames*/
        socketFilterMap = status.getFiltersOnCamera();
//        for (Map.Entry<String,String> entry: socketFilterMap.entrySet()) {           
//            FCSLOG.info(" socket name=" + entry.getKey() + " filter name=" + entry.getValue());
//        }
        if (socketFilterMap == null) FCSLOG.info("socketFilterMap is null in method update");
        repaint();
    }
    
    @Override
    protected void paintComponent(Graphics g) {
        FCSLOG.info("CarouselDisk paintComponent");
        Graphics2D g2 = (Graphics2D) g;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, 
                RenderingHints.VALUE_ANTIALIAS_ON);
        g2.addRenderingHints(hints);

        float width = getWidth();
        float height = getHeight();
        float actualWidth = Math.min(width, height);

        float border = 10;

        // Draw the outline
        
        Shape circle = new Arc2D.Double(border, border, actualWidth - 2 * border, 
                actualWidth - 2 * border, 0, 360, Arc2D.CHORD);
        g2.draw(circle);

        double filterDegrees = 360. / 5;

        // Draw the "loading window"
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(new BasicStroke(5));
        Shape loader = new Arc2D.Double(border, border, actualWidth - 2 * border, 
                actualWidth - 2 * border, 0, -filterDegrees, Arc2D.OPEN);
        g2.draw(loader);
        g2.setStroke(oldStroke);

        g2.rotate(rotationInDegrees * Math.PI / 180, actualWidth / 2, actualWidth / 2);
        border *= 2;
        
        if (socketFilterMap == null) {
            FCSLOG.error ("socketFilterMap is null");
        } else {
            for (Map.Entry<String,String> entry: socketFilterMap.entrySet()) {

                String socketName = entry.getKey();
                String filterName = entry.getValue();
                Shape arc = new Arc2D.Double(border, border, actualWidth - 2 * border, 
                        actualWidth - 2 * border, 0, -filterDegrees, Arc2D.PIE);
                boolean filterPresent = !filterName.equals(filterOnAutochanger);
                if (filterPresent) {
                    g2.draw(arc);
                }
                g2.rotate(filterDegrees * Math.PI / 360, actualWidth / 2, actualWidth / 2);
                g2.drawString(socketName, actualWidth * 3 / 5, actualWidth / 2);
                if (filterPresent) {
                    g2.drawString(filterName, actualWidth * 3 / 4, actualWidth / 2);
                }
                g2.rotate(filterDegrees * Math.PI / 360, actualWidth / 2, actualWidth / 2);
            }
        }
    }
}
    

