/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.greenColor;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_big;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 *
 * @author virieux
 */
public class AutochangerOnlineClampPanel extends JPanel {

    private static final long serialVersionUID = 7563287373167394297L;
    private final String clampName;

    // Variables declaration  
    private DigitalSwitch lockSensorDS;
    private DigitalSwitch lockSensorCDS;
    private DigitalSwitch unlockSensorDS;
    private DigitalSwitch unlockSensorCDS;
    private DigitalSwitch errorDS;

    private JLabel clampNameLabel;
    private JLabel lockLabel;
    private JLabel unlockLabel;
    private JLabel errorLabel;

    private JLabel lockStatus; //is it useful to display the lockStatus ?

    //Config Parameters Panel
    private JPanel paramPanel;
    private final JLabel ctlLabel = new JLabel("current to lock:");
    private final JLabel ctuLabel = new JLabel("current to unlock:");
    private final JLabel ctcLabel = new JLabel("current to clamp:");
    private final JLabel ttLabel = new JLabel("time to travel:");
    private final JLabel htLabel = new JLabel("hold time:");
    private final JLabel currentToLockLabel = new JLabel("2000");
    private final JLabel currentToUnlockLabel = new JLabel("0");
    private final JLabel currentToClampLabel = new JLabel("0");
    private final JLabel holdTimeLabel = new JLabel("12000");
    private final JLabel travelTimeLabel = new JLabel("0");

    //Controller Fault Panel
    private JPanel faultPanel;
    private DigitalSwitch faultSwitch;
    // End of variables declaration



    /**
     * 
     * A Runnable to initialize this Panel from configuration data.
     */
    private class GuiInitialization implements Runnable {

        private ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            //Retrieve the configuration data for my name.
            Map<String, String> configForName = configInfo.getCurrentValuesForComponent(clampName);
            
            //Config Panel
            currentToLockLabel.setText(Tools.getText(configForName, clampName, "currentToLock"));
            currentToUnlockLabel.setText(Tools.getText(configForName, clampName, "currentToUnock"));
            currentToClampLabel.setText(Tools.getText(configForName, clampName, "currentToClamp"));
            holdTimeLabel.setText(Tools.getText(configForName, clampName, "holdTime"));
            travelTimeLabel.setText(Tools.getText(configForName, clampName, "travelTime"));

            //controller panel
            faultSwitch.setColor(Color.GRAY);
        }
    }


    /**
     * 
     * A Runnable to Update this Panel from status data published on STATUS bus.
     */
    class UpdateClamp implements Runnable {

        private StatusDataPublishedByAutochangerOnlineClamp s;

        public UpdateClamp(StatusDataPublishedByAutochangerOnlineClamp status) {
            this.s = status;
        }

        @Override
        public void run() {

            clampNameLabel.setText(s.getName());
            lockStatus.setText(s.getLockStatus().getText());
            lockStatus.setBackground(s.getLockStatus().getColor());
            if (s.isLockSensorInError()) {
                lockSensorDS.setColor(Color.red);
            } else {
                lockSensorDS.setColor(s.getLockSensorValue() == 1 ? greenColor : Color.gray);
            }
            if (s.isUnlockSensorInError()) {
                unlockSensorDS.setColor(Color.red);
            } else {
                unlockSensorDS.setColor(s.getUnlockSensorValue() == 1 ? greenColor : Color.gray);
            }
            boolean inTravel = (s.getLockStatus().equals(LockStatus.INTRAVEL));
            boolean unknown = (s.getLockStatus().equals(LockStatus.UNKNOWN));
            if (s.isInError() || inTravel || unknown) {
                errorDS.setColor(s.getLockStatus().getColor());
                errorLabel.setText(s.getLockStatus().getText());
            } else {
                errorDS.setColor(LockStatus.NOERROR.getColor());
                errorLabel.setText(LockStatus.NOERROR.getText());
            }

            //controller
            faultSwitch.setColor(s.isControllerInFault() ? Color.RED : greenColor);
        }
    }
    
    /**
     * Create a new Panel with a clamp name.
     * @param clampName 
     */
    public AutochangerOnlineClampPanel(String clampName) {
        this.clampName = clampName;
        initComponents();
    }


    public void initializeGui(ConfigurationInfo configInfo) {
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }
    
    
    public void updateClamp(StatusDataPublishedByAutochangerOnlineClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }

    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form description"> 
    private void initComponents() {

        lockSensorDS = new DigitalSwitch();
        lockSensorDS.setColor(Color.gray);
        lockSensorCDS = new DigitalSwitch();
        lockSensorCDS.setColor(Color.gray);
        unlockSensorDS = new DigitalSwitch();
        unlockSensorDS.setColor(Color.gray);
        unlockSensorCDS = new DigitalSwitch();
        unlockSensorCDS.setColor(Color.gray);

        errorDS = new DigitalSwitch();
        errorDS.setColor(Color.gray);

        clampNameLabel = new JLabel("myClamp");
        unlockLabel = new JLabel("<html><P align=\"center\">UNLOCK<br>SENSOR</p></html>");
        lockLabel = new JLabel("<html><P align=\"center\">LOCK<br>SENSOR</p></html>");
        errorLabel = new JLabel("ERROR");
        lockStatus = new JLabel("UNKNOWN STATE");

        /**
         * *****************************************************************************
         ** Config Parameters Panel
         * *****************************************************************************
         */
        paramPanel = new JPanel();
        paramPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        paramPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.insets = insets_std;
        //1st column
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.anchor = GridBagConstraints.LINE_START;
        paramPanel.add(ctlLabel, gbcp);
        gbcp.gridy++;
        paramPanel.add(ctuLabel, gbcp);
        gbcp.gridy++;
        paramPanel.add(ctcLabel, gbcp);

        //2nd column
        gbcp.anchor = GridBagConstraints.LINE_END;
        gbcp.gridx = 1;
        gbcp.gridy = 0;
        paramPanel.add(currentToLockLabel, gbcp);
        gbcp.gridy++;
        paramPanel.add(currentToUnlockLabel, gbcp);
        gbcp.gridy++;
        paramPanel.add(currentToClampLabel, gbcp);

        //3rd column
        gbcp.anchor = GridBagConstraints.LINE_START;
        gbcp.gridx = 2;
        gbcp.gridy = 0;
        paramPanel.add(ttLabel, gbcp);
        gbcp.gridy++;
        paramPanel.add(htLabel, gbcp);

        //4th column
        gbcp.anchor = GridBagConstraints.LINE_END;
        gbcp.gridx = 3;
        gbcp.gridy = 0;
        paramPanel.add(travelTimeLabel, gbcp);
        gbcp.gridy++;
        paramPanel.add(holdTimeLabel, gbcp);

        /**
         * *****************************************************************************
         ** end of Config Parameters Panel
         * *****************************************************************************
         */
        /**
         * *****************************************************************************
         ** Controller Fault Panel
         * *****************************************************************************
         */
        faultPanel = new JPanel();
        faultSwitch = new DigitalSwitch();
        faultSwitch.setColor(Color.GRAY);
        faultPanel.setBorder(BorderFactory.createTitledBorder("Controller"));
        faultPanel.setLayout(new GridBagLayout());
        faultPanel.setPreferredSize(new Dimension(100, 100));

        faultSwitch.setColor(Color.GRAY);
        faultSwitch.setSize(50);

        GridBagConstraints gbcf = new GridBagConstraints();
        gbcf.insets = insets_std;
        gbcf.gridx = 0;
        gbcf.gridy = 0;
        gbcf.anchor = GridBagConstraints.CENTER;
        faultPanel.add(faultSwitch, gbcf);

        /**
         * *****************************************************************************
         ** end of Controller Fault Panel
         * *****************************************************************************
         */
        /**
         * *****************************************************************************
         ** Whole Panel
         * *****************************************************************************
         */
        setBorder(BorderFactory.createEtchedBorder());
        setForeground(new Color(204, 204, 255));
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_big;

        gbc.gridx = 0;
        gbc.gridy = 0;
        add(clampNameLabel, gbc);
        gbc.gridy++;
        add(lockStatus, gbc);

        gbc.gridx = 1;
        gbc.gridy = 0;
        add(unlockSensorDS, gbc);
        gbc.gridy++;
        add(unlockLabel, gbc);

        gbc.gridx = 2;
        gbc.gridy = 0;
        add(lockSensorDS, gbc);
        gbc.gridy++;
        add(lockLabel, gbc);

        gbc.gridx = 3;
        gbc.gridy = 0;
        add(errorDS, gbc);
        gbc.gridy++;
        add(errorLabel, gbc);

        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        add(faultPanel, gbc);

        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 5;
        add(paramPanel, gbc);
    }

    @Override
    public String toString() {
        return "ONLINE Clamp";
    }

    public static void main(String[] argv) {

        AutochangerOnlineClampPanel d = new AutochangerOnlineClampPanel("clampName");
        JFrame frame = new JFrame("Autochanger OnlineClamp Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }

}
