/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.greenColor;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_big;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 *
 * @author virieux
 */
public class AutochangerLatchPanel extends JPanel {

    private static final long serialVersionUID = -3564360054429278810L;

    // Variables declaration  
    private AutochangerGUI subs;

    private DigitalSwitch unlockSensorDS;
    private DigitalSwitch lockSensorDS;
    private DigitalSwitch filterEngagedSensorDS;
    private DigitalSwitch errorDS;

    private String latchName;
    private JLabel latchNameLabel;
    private JLabel unlockLabel;
    private JLabel lockLabel;
    private JLabel errorLabel;
    private JLabel filterEngagedLabel;
    private JLabel lockStatus; //is it useful to display the lockStatus ?

    //Config Parameters Panel
    private JPanel paramPanel;
    private final JLabel mincLabel = new JLabel("min current:");
    private final JLabel maxcLabel = new JLabel("max current:");
    private final JLabel ctoLabel = new JLabel("current to open:");
    private final JLabel minCurrentLabel = new JLabel("0");
    private final JLabel maxCurrentLabel = new JLabel("0");
    private final JLabel currentToOpenLabel = new JLabel("0");

    //Controller Fault Panel
    private JPanel faultPanel;
    private DigitalSwitch faultSwitch;

    //Control panel
    private JPanel controlPanel;
    private JButton abortButton;
    private JButton closeButton;
    private JButton openButton;
    
    /**
     * A Runnable to initialize this Panel.
     */
    private class GuiInitialization implements Runnable {

        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            
            //Retrieve the configuration data for my latchName.
            Map<String, String> configForName = configInfo.getCurrentValuesForComponent(latchName);

            //Config Panel
            minCurrentLabel.setText(Tools.getText(configForName, latchName, "minCurrent"));
            maxCurrentLabel.setText(Tools.getText(configForName, latchName, "maxCurrent"));
            currentToOpenLabel.setText(Tools.getText(configForName, latchName, "currentToOpen"));

            //controller panel
            faultSwitch.setColor(Color.GRAY);
        }
    }
    
        /**
     * A Runnable to update this Panle from data published on the STATUS bus from
     * a latch.
     * @param status 
     */
    class UpdateLatch implements Runnable {

        private final StatusDataPublishedByAutochangerLatch s;

        public UpdateLatch(StatusDataPublishedByAutochangerLatch status) {
            this.s = status;
        }

        @Override
        public void run() {

            latchName = s.getName();
            latchNameLabel.setText(s.getName());
            unlockSensorDS.setColor(s.getUnlockSensorValue() == 1 ? greenColor : Color.gray);
            lockSensorDS.setColor(s.getLockSensorValue() == 1 ? greenColor : Color.gray);
            filterEngagedSensorDS.setColor(s.getFilterPresenceSensorValue() == 1 ? greenColor : Color.gray);
            boolean inTravel = (s.getUnlockSensorValue() == 0) && (s.getLockSensorValue() == 0);
            boolean unknown = (s.getLockStatus().equals(FcsEnumerations.LockStatus.UNKNOWN));
            if (s.isInError() || inTravel || unknown) {
                errorDS.setColor(s.getLockStatus().getColor());
                errorLabel.setText(s.getLockStatus().getText());
            } else {
                errorDS.setColor(LockStatus.NOERROR.getColor());
                errorLabel.setText(LockStatus.NOERROR.getText());
            }
            lockStatus.setText(s.getLockStatus().getText());
            lockStatus.setForeground(s.getLockStatus().getColor());

            //controller
            faultSwitch.setColor(s.isControllerInFault() ? Color.RED : greenColor);
        }
    }

    // End of variables declaration 
    public AutochangerLatchPanel(String latchName) {
        this.latchName = latchName;
        initComponents();
    }

    public void setSubsystem(AutochangerGUI subs) {
        this.subs = subs;
    }

    void setLatchName(String name) {
        latchNameLabel.setText(name);
    }

    /**
     * Initialize this Panel from configuration data.
     * @param configInfo 
     */
    public void initializeGui(ConfigurationInfo configInfo) {
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }




    public void updateLatch(StatusDataPublishedByAutochangerLatch status) {
        SwingUtilities.invokeLater(new UpdateLatch(status));
    }



    private void lockButtonActionPerformed(ActionEvent evt) {
        subs.closeLatch(latchName);
    }

    private void unlockButtonActionPerformed(ActionEvent evt) {
        subs.openLatch(latchName);
    }

    private void abortButtonActionPerformed(ActionEvent evt) {
        subs.abortAction();
    }

    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form description"> 
    private void initComponents() {
        closeButton = new JButton("Close Latch");
        openButton = new JButton("Open Latch");
        abortButton = new JButton("Abort");

        closeButton.addActionListener((ActionEvent evt) -> {
            lockButtonActionPerformed(evt);
        });

        openButton.addActionListener((ActionEvent evt) -> {
            unlockButtonActionPerformed(evt);
        });

        abortButton.addActionListener((ActionEvent evt) -> {
            abortButtonActionPerformed(evt);
        });

        unlockSensorDS = new DigitalSwitch();
        unlockSensorDS.setColor(Color.gray);
        lockSensorDS = new DigitalSwitch();
        lockSensorDS.setColor(Color.gray);
        filterEngagedSensorDS = new DigitalSwitch();
        filterEngagedSensorDS.setColor(Color.gray);
        errorDS = new DigitalSwitch();
        errorDS.setColor(Color.gray);

        latchNameLabel = new JLabel("myLatch");
        unlockLabel = new JLabel("<html><P align=\"center\">UNLOCK<br>SENSOR</p></html>");
        lockLabel = new JLabel("<html><P align=\"center\">LOCK<br>SENSOR</p></html>");
        errorLabel = new JLabel("ERROR");
        filterEngagedLabel = new JLabel("<html><P align=\"center\">FILTER<br>ENGAGED</p></html>");
        lockStatus = new JLabel("UNKNOWN STATE");

        /**
         * *****************************************************************************
         ** Controller Fault Panel
         * *****************************************************************************
         */
        faultPanel = new JPanel();
        faultSwitch = new DigitalSwitch();
        faultSwitch.setColor(Color.GRAY);
        faultPanel.setBorder(BorderFactory.createTitledBorder("Controller"));
        faultPanel.setLayout(new GridBagLayout());
        faultPanel.setPreferredSize(new Dimension(100, 100));

        faultSwitch.setColor(Color.GRAY);
        faultSwitch.setSize(50);

        GridBagConstraints gbcf = new GridBagConstraints();
        gbcf.insets = insets_std;
        gbcf.gridx = 0;
        gbcf.gridy = 0;
        gbcf.anchor = GridBagConstraints.CENTER;
        faultPanel.add(faultSwitch, gbcf);

        /**
         * *****************************************************************************
         ** end of Controller Fault Panel
         * *****************************************************************************
         */
        /**
         * *****************************************************************************
         ** Config Parameters Panel
         * *****************************************************************************
         */
        paramPanel = new JPanel();
        paramPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        paramPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.insets = insets_std;
        //1st column
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.anchor = GridBagConstraints.LINE_START;
        paramPanel.add(mincLabel, gbcp);
        gbcp.gridy++;
        paramPanel.add(maxcLabel, gbcp);
        gbcp.gridy++;
        paramPanel.add(ctoLabel, gbcp);
        //2nd column
        gbcp.anchor = GridBagConstraints.LINE_END;
        gbcp.gridx = 1;
        gbcp.gridy = 0;
        paramPanel.add(minCurrentLabel, gbcp);
        gbcp.gridy++;
        paramPanel.add(maxCurrentLabel, gbcp);
        gbcp.gridy++;
        paramPanel.add(currentToOpenLabel, gbcp);
        /**
         * *****************************************************************************
         ** end of Config Parameters Panel
         * *****************************************************************************
         */

        /**
         ******************************************************************************
         ** Control Panel
         * *****************************************************************************
         */
        controlPanel = new JPanel();
        controlPanel.setLayout(new java.awt.GridBagLayout());
        GridBagConstraints gbc3 = new java.awt.GridBagConstraints();
        gbc3.anchor = GridBagConstraints.FIRST_LINE_START;
        gbc3.fill = GridBagConstraints.HORIZONTAL;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        controlPanel.add(closeButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(openButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(abortButton, gbc3);
        /**
         ******************************************************************************
         ** End of Control Panel
         * *****************************************************************************
         */

        /**
         * *****************************************************************************
         ** Whole Panel
         * *****************************************************************************
         */
        setBorder(BorderFactory.createEtchedBorder());
        setForeground(new Color(204, 204, 255));
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_big;

        gbc.gridx = 0;
        gbc.gridy = 0;
        add(latchNameLabel, gbc);
        gbc.gridy++;
        add(lockStatus, gbc);

        gbc.gridx = 1;
        gbc.gridy = 0;
        add(unlockSensorDS, gbc);
        gbc.gridy++;
        add(unlockLabel, gbc);

        gbc.gridx = 2;
        gbc.gridy = 0;
        add(lockSensorDS, gbc);
        gbc.gridy++;
        add(lockLabel, gbc);

        gbc.gridx = 3;
        gbc.gridy = 0;
        add(filterEngagedSensorDS, gbc);
        gbc.gridy++;
        add(filterEngagedLabel, gbc);

        gbc.gridx = 4;
        gbc.gridy = 0;
        add(errorDS, gbc);
        gbc.gridy++;
        add(errorLabel, gbc);

        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        add(faultPanel, gbc);

        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        add(paramPanel, gbc);

        gbc.gridx = 5;
        gbc.gridy = 2;
        gbc.insets = insets_std;
        gbc.anchor = GridBagConstraints.EAST;
        gbc.gridwidth = 1;
        add(controlPanel, gbc);

    }

    @Override
    public String toString() {
        if (latchName == null) {
            return "Latch"; 
        } else {
            return latchName;
        }
    }

    public static void main(String[] argv) {

        AutochangerLatchPanel d = new AutochangerLatchPanel("myLatch");
        JFrame frame = new JFrame("Autochanger Latch Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }

}
