/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GatherPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.PlutoGatewayPanel;

/**
 * This panel gathers all the panels needed for the autochanger GUI.
 * Except the subsystemPanel which is handled by the GeneralPanel.
 * It takes care of the initialization of the panels and the update of the panels.
 *
 * @author virieux
 */
public class AutochangerGatherPanel extends GatherPanel {
    private static final long serialVersionUID = -975949078768889254L;

    protected AutochangerGUI subs;

    //CANopen devices panels
    protected EPOSControllerPanel linearRailMasterControllerPanel;
    protected EPOSControllerPanel linearRailSlaveControllerPanel;
    protected EPOSControllerPanel latchXminusControllerPanel;
    protected EPOSControllerPanel latchXplusControllerPanel;
    protected EPOSControllerPanel onlineClampXminusControllerPanel;
    protected EPOSControllerPanel onlineClampXplusControllerPanel;
    protected EPOSControllerPanel onlineClampYminusControllerPanel;
    protected PlutoGatewayPanel plutoGatewayPanel;

    //Exchanger hardware panels
    protected AutochangerThreeOnlineClampsPanel onlineClampsPanel;
    
    
    private AutochangerTrucksPanel acTrucksPanel;
    private AutochangerTwoLatchesPanel acLatchesPanel = new AutochangerTwoLatchesPanel();
    private AutochangerThreeOnlineClampsPanel acClampsPanel = new AutochangerThreeOnlineClampsPanel();
    private final AutochangerGeneralViewPanel acGeneralViewPanel = new AutochangerGeneralViewPanel();

    public AutochangerGatherPanel(String tcpProxyName) {
        super(tcpProxyName);
        initPanels();
    }

    public AutochangerGatherPanel(AutochangerGUI subs, String tcpProxyName) {
        super(tcpProxyName);
        initPanels();
        this.subs = subs;
        this.acClampsPanel.setSubsystem(subs);
        this.acLatchesPanel.setSubsystem(subs);
        this.acTrucksPanel.setSubsystem(subs);
        this.linearRailMasterControllerPanel.setSubsystem(subs);
        this.linearRailSlaveControllerPanel.setSubsystem(subs);
        this.latchXminusControllerPanel.setSubsystem(subs);
        this.latchXplusControllerPanel.setSubsystem(subs);
        this.onlineClampXminusControllerPanel.setSubsystem(subs);
        this.onlineClampXplusControllerPanel.setSubsystem(subs);
        this.onlineClampYminusControllerPanel.setSubsystem(subs);
    }



    public AutochangerTrucksPanel getAcTrucksPanel() {
        return acTrucksPanel;
    }

    public AutochangerTwoLatchesPanel getAcLatchesPanel() {
        return acLatchesPanel;
    }

    public AutochangerThreeOnlineClampsPanel getAcClampsPanel() {
        return acClampsPanel;
    }

    public AutochangerGeneralViewPanel getAcGeneralViewPanel() {
        return acGeneralViewPanel;
    }

    public EPOSControllerPanel getLinearRailMasterControllerPanel() {
        return linearRailMasterControllerPanel;
    }

    public EPOSControllerPanel getLinearRailSlaveControllerPanel() {
        return linearRailSlaveControllerPanel;
    }

    public EPOSControllerPanel getLatchXminusControllerPanel() {
        return latchXminusControllerPanel;
    }

    public EPOSControllerPanel getLatchXplusControllerPanel() {
        return latchXplusControllerPanel;
    }

    public EPOSControllerPanel getOnlineClampXminusControllerPanel() {
        return onlineClampXminusControllerPanel;
    }

    public EPOSControllerPanel getOnlineClampXplusControllerPanel() {
        return onlineClampXplusControllerPanel;
    }

    public EPOSControllerPanel getOnlineClampZControllerPanel() {
        return onlineClampYminusControllerPanel;
    }

    public PlutoGatewayPanel getPlutoGatewayPanel() {
        return plutoGatewayPanel;
    }

    @Override
    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, List<String> hardwareNames) 
            throws InterruptedException, InvocationTargetException {
        super.initializeGUIWithConfigInfo(configInfo, hardwareNames);
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }


    /**
     * What to do when we receive data coming from our destination.
     * @param msg
     */
    @Override
    public void onStatusMessage(StatusMessage msg) {
         // Safe cast : filtering ensures we only receive StatusSubsystemData messages
        StatusSubsystemData d = (StatusSubsystemData)msg;
        KeyValueData data = (KeyValueData)d.getObject();
        FCSLOG.debug(subs.getName() + " read data dataType:" + data.getKey());
        switch (data.getKey()) {

            case "tcpProxy":
                updateCanOpenHardwarePanel(
                        (StatusDataPublishedByHardware)data.getValue());
                break;

            case "autochangerGeneral":
                updateAutochanger(
                        (StatusDataPublishedByAutoChanger) data.getValue());
                break;

            case "linearRailMasterController":
                updateLinearRailMasterController(
                        (StatusDataPublishedByEPOSController) data.getValue());
                break;

            case "linearRailSlaveController":
                updateLinearRailSlaveController(
                        (StatusDataPublishedByEPOSController) data.getValue());
                break;

            case "latchXminusController":
                updateLatchXminusController(
                        (StatusDataPublishedByEPOSController) data.getValue());
                break;

            case "latchXplusController":
                updateLatchXplusController(
                        (StatusDataPublishedByEPOSController) data.getValue());
                break;

            case "onlineClampXminusController":
                updateOnlineClampXminusController(
                        (StatusDataPublishedByEPOSController) data.getValue());
                break;

            case "onlineClampXplusController":
                updateOnlineClampXplusController(
                        (StatusDataPublishedByEPOSController) data.getValue());
                break;

            case "onlineClampYminusController":
                updateOnlineClampYminusController(
                        (StatusDataPublishedByEPOSController) data.getValue());
                break;

            case "autochangerTrucks":
                FCSLOG.finest(getName() + " Data published by Trucks= " + ((StatusDataPublishedByAutoChangerTrucks) data.getValue()).toString());
                updateTrucks((StatusDataPublishedByAutoChangerTrucks) data.getValue());
                break;

            case "latchXminus":
                FCSLOG.finest(getName() + " Data published by Latch= " + (
                        (StatusDataPublishedByAutochangerLatch) data.getValue()).toString());
                updateLatch(
                        (StatusDataPublishedByAutochangerLatch) data.getValue());
                break;

            case "latchXplus":
                FCSLOG.finest(getName() + " Data published by Latch= " + ((StatusDataPublishedByAutochangerLatch) data.getValue()).toString());
                updateLatch((StatusDataPublishedByAutochangerLatch) data.getValue());
                break;

            case "autochangerLatches":
                FCSLOG.debug(getName() + " Data published by Latches= " + ((StatusDataPublishedByAutochangerTwoLatches) data.getValue()).toString());
                updateLatches((StatusDataPublishedByAutochangerTwoLatches) data.getValue());
                break;

            case "onlineClampXminus":
                FCSLOG.debug(getName() + " Data published by ClampXminus= " 
                        + ((StatusDataPublishedByAutochangerOnlineClamp) data.getValue()).toString());
                updateClampXminus((StatusDataPublishedByAutochangerOnlineClamp) data.getValue());
                break;

            case "onlineClampXplus":
                FCSLOG.debug(getName() + " Data published by ClampXplus= " 
                        + ((StatusDataPublishedByAutochangerOnlineClamp) data.getValue()).toString());
                updateClampXplus(
                        (StatusDataPublishedByAutochangerOnlineClamp) data.getValue());
                break;

            case "onlineClampZ":
                FCSLOG.debug(getName() + " Data published by ClampZ= " 
                        + ((StatusDataPublishedByAutochangerOnlineClamp) data.getValue()).toString());
                updateClampZ(
                        (StatusDataPublishedByAutochangerOnlineClamp) data.getValue());
                break;

            case "autochangerClamps":
                FCSLOG.debug(getName() + " Data published by Clamps= " 
                        + ((StatusDataPublishedByAutochangerThreeClamps) data.getValue()).toString());
                updateClamps(
                        (StatusDataPublishedByAutochangerThreeClamps) data.getValue());
                break;

            default:
                FCSLOG.warning(getName() + " An unexpected dataType was read on the status bus:" 
                        + data.getType());
                break;
        }
    }



    

    /**
     * Initialization of the GUI for data stored in tcpConfiguration. *
     */
    private class GuiInitialization implements Runnable {

        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {



            //** Autochanger General View Panel **/
            acGeneralViewPanel.initializeGui(configInfo);

            /**
             * Autochanger Clamps Panel *
             */
            acClampsPanel.initializeGui(configInfo);

            /**
             * Autochanger Latches Panel *
             */
            acLatchesPanel.initializeGui(configInfo);

            /**
             * Autochanger Trucks Panel *
             */
            
            acTrucksPanel.initializeGui(configInfo);

            /**
             * Linear Rail Master Controller Panel *
             */
            linearRailMasterControllerPanel.initializeGui(configInfo);

            /**
             * Linear Rail Slave Controller Panel*
             */
            linearRailSlaveControllerPanel.initializeGui(configInfo);

            /**
             * Latch Xminus Controller Panel*
             */
            latchXminusControllerPanel.initializeGui(configInfo);

            /**
             * Latch Xplus Controller Panel*
             */
            latchXplusControllerPanel.initializeGui(configInfo);

            /**
             * Online Clamp Xminus Controller Panel*
             */
            onlineClampXminusControllerPanel.initializeGui(configInfo);

            /**
             * Online Clamp Xplus Controller Panel*
             */
            onlineClampXplusControllerPanel.initializeGui(configInfo);

            /**
             * Online Clamp Z Controller Panel*
             */
            onlineClampYminusControllerPanel.initializeGui(configInfo);

            /**
             * PlutoGateway Panel*
             */
            plutoGatewayPanel.initializeGui(configInfo);

        }
    }


    protected void updateLinearRailMasterController(StatusDataPublishedByEPOSController s) {
        linearRailMasterControllerPanel.updateController(s);
    }

    protected void updateLinearRailSlaveController(StatusDataPublishedByEPOSController s) {
        linearRailSlaveControllerPanel.updateController(s);
    }

    protected void updateLatchXminusController(StatusDataPublishedByEPOSController s) {
        latchXminusControllerPanel.updateController(s);
    }

    protected void updateLatchXplusController(StatusDataPublishedByEPOSController s) {
        latchXplusControllerPanel.updateController(s);
    }

    protected void updateOnlineClampXminusController(StatusDataPublishedByEPOSController s) {
        onlineClampXminusControllerPanel.updateController(s);
    }

    protected void updateOnlineClampXplusController(StatusDataPublishedByEPOSController s) {
        onlineClampXplusControllerPanel.updateController(s);
    }

    protected void updateOnlineClampYminusController(StatusDataPublishedByEPOSController s) {
        onlineClampYminusControllerPanel.updateController(s);
    }

    protected void updateClampXminus(StatusDataPublishedByAutochangerOnlineClamp s) {
        this.acClampsPanel.updateClampXminus(s);
    }

    protected void updateClampXplus(StatusDataPublishedByAutochangerOnlineClamp s) {
        this.acClampsPanel.updateClampXplus(s);
    }

    protected void updateClampZ(StatusDataPublishedByAutochangerOnlineClamp s) {
        this.acClampsPanel.updateClampZ(s);
    }

    protected void updateClamps(StatusDataPublishedByAutochangerThreeClamps s) {
        this.acClampsPanel.updateClamps(s);
        this.acGeneralViewPanel.updateClamps(s);
    }

    protected void updateAutochanger(StatusDataPublishedByAutoChanger s) {
        this.acGeneralViewPanel.updateAutochanger(s);
    }

    protected void updateLatch(StatusDataPublishedByAutochangerLatch s) {
        this.acLatchesPanel.updateLatch(s);
    }

    protected void updateLatches(StatusDataPublishedByAutochangerTwoLatches s) {
        this.acLatchesPanel.updateLatches(s);
        this.acGeneralViewPanel.updateLatches(s);
    }

    protected void updateTrucks(StatusDataPublishedByAutoChangerTrucks s) {
        FCSLOG.finest(" Data published by Trucks= " + s.toString());
        this.acTrucksPanel.updateTrucks(s);
        this.acGeneralViewPanel.updateTrucks(s);
    }

    private void initPanels() {
        //controllers Panels
        linearRailMasterControllerPanel = new EPOSControllerPanel("linearRailMasterController");
        linearRailSlaveControllerPanel = new EPOSControllerPanel("linearRailSlaveController");
        latchXminusControllerPanel = new EPOSControllerPanel("latchXminusController");
        latchXplusControllerPanel = new EPOSControllerPanel("latchXplusController");
        onlineClampXminusControllerPanel = new EPOSControllerPanel("onlineClampXminusController");
        onlineClampXplusControllerPanel = new EPOSControllerPanel("onlineClampXplusController");
        onlineClampYminusControllerPanel = new EPOSControllerPanel("onlineClampZController");
        //plutoGatewayPanel
        plutoGatewayPanel = new PlutoGatewayPanel("plutoGateway");

        acClampsPanel = new AutochangerThreeOnlineClampsPanel();
        acLatchesPanel = new AutochangerTwoLatchesPanel();
        acTrucksPanel = new AutochangerTrucksPanel("trucks");
    }

}
