/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.config.CANopenHardwareConfig;
import org.lsst.ccs.subsystems.fcs.config.CanOpenProxyConfig;
import org.lsst.ccs.subsystems.fcs.config.EPOSControllerConfig;
import org.lsst.ccs.utilities.logging.Logger;

public class Tools {
    protected static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystems.fcs");
    public static Color greenColor = new Color(0, 165, 0);
    public static Color nicePink = new Color(255, 0, 255);
    public static String fcsFontInString = "Lucida Grande";
    public static Font bigFont = new Font(fcsFontInString, 1, 14);
    public static Font hugeFont = new Font(fcsFontInString, 1, 20);
    public static Insets insets_std = new Insets(4, 4, 4, 4);
    public static Insets insets_big = new Insets(14, 4, 6, 4);

    public static Color getLockSensorColor(String lockSensorStatus) {
        if (lockSensorStatus.equals(FcsEnumerations.LockStatus.ERROR.toString())) {
            return Color.red;
        }
        if (lockSensorStatus.equals(FcsEnumerations.LockStatus.LOCKED.toString())) {
            return greenColor;
        }
        if (lockSensorStatus.equals(FcsEnumerations.LockStatus.UNKNOWN.toString())) {
            return Color.orange;
        }
        if (lockSensorStatus.equals(FcsEnumerations.LockStatus.UNLOCKED.toString())) {
            return Color.blue;
        }
        if (lockSensorStatus.equals(FcsEnumerations.LockStatus.CLAMPED.toString())) {
            return Color.GREEN;
        }
        if (lockSensorStatus.equals(FcsEnumerations.LockStatus.INTRAVEL.toString())) {
            return Color.YELLOW;
        }
        log.error((Object)("Tools: Unknown Lock Sensor Status " + lockSensorStatus), new String[0]);
        return Color.GRAY;
    }

    public static Color getFilterPresenceColor(String filterPresenceStatus) {
        if (filterPresenceStatus.equals(FcsEnumerations.FilterPresenceStatus.ERROR.toString())) {
            return Color.red;
        }
        if (filterPresenceStatus.equals(FcsEnumerations.FilterPresenceStatus.LOCKABLE.toString())) {
            return greenColor;
        }
        if (filterPresenceStatus.equals(FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE.toString())) {
            return Color.orange;
        }
        if (filterPresenceStatus.equals(FcsEnumerations.FilterPresenceStatus.NOFILTER.toString())) {
            return Color.gray;
        }
        log.error((Object)("Unknown Filter Presence Status " + filterPresenceStatus), new String[0]);
        return Color.gray;
    }

    public static CANopenHardwareConfig retrieveControllerInfo(CanOpenProxyConfig canOpenProxyConfig, EPOSControllerConfig ctlConfig) {
        CANopenHardwareConfig hConfig = new CANopenHardwareConfig("Unknown", "Unknown", "Unknown", Boolean.valueOf(false), Boolean.valueOf(false));
        CANopenHardwareConfig[] list = canOpenProxyConfig.getHardwareConfigList();
        int rowNB = list.length;
        int i = 0;
        while (i < rowNB) {
            if (list[i].getName().equals(ctlConfig.getName())) {
                hConfig = list[i];
            }
            ++i;
        }
        return hConfig;
    }

    public static CANopenHardwareConfig retrieveDeviceInfo(CanOpenProxyConfig canOpenProxyConfig, String deviceName) {
        CANopenHardwareConfig hConfig = new CANopenHardwareConfig("Unknown", "Unknown", "Unknown", Boolean.valueOf(false), Boolean.valueOf(false));
        CANopenHardwareConfig[] list = canOpenProxyConfig.getHardwareConfigList();
        int rowNB = list.length;
        int i = 0;
        while (i < rowNB) {
            if (list[i].getName().equals(deviceName)) {
                hConfig = list[i];
            }
            ++i;
        }
        return hConfig;
    }
}

