/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.state.PublishedState;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUISubsystem;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class SubsystemPanel
extends JPanel {
    private final String title;
    private GeneralGUISubsystem subs;
    private final JPanel subsStatePanel = new JPanel();
    private final JPanel controlPanel = new JPanel();
    private final JLabel controlRealHardwareLabel = new JLabel("unknown hardware type");
    private final JLabel subsystemStateLabel = new JLabel("UNREACHABLE SUBSYSTEM");
    private final JButton updateStateWithSensorsButton = new JButton("updateStateWithSensors");
    private final JButton completeInitializationButton = new JButton("completeInitialization");
    private final JButton abortButton = new JButton("Abort");
    private final JButton shutdownButton = new JButton("Shutdown FCS");

    public SubsystemPanel(String title) {
        this.title = title;
        this.initComponents();
    }

    public void setSubsystem(GeneralGUISubsystem subs) {
        this.subs = subs;
    }

    public void setcontrolRealHardwareLabelText(String atext) {
        this.controlRealHardwareLabel.setText(atext);
    }

    public void update(PublishedState state) {
        SwingUtilities.invokeLater(new UpdateSubsystemPanel(state));
    }

    private void initComponents() {
        this.controlRealHardwareLabel.setFont(Tools.bigFont);
        this.subsystemStateLabel.setFont(Tools.bigFont);
        this.subsStatePanel.setBackground(Color.GRAY);
        this.subsStatePanel.setPreferredSize(new Dimension(400, 50));
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.anchor = 21;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        this.subsStatePanel.add((Component)this.subsystemStateLabel, gbc0);
        this.updateStateWithSensorsButton.addActionListener(evt -> this.updateStateWithSensorsActionPerformed(evt));
        this.completeInitializationButton.addActionListener(evt -> this.completeInitializationActionPerformed(evt));
        this.abortButton.addActionListener(evt -> this.abortActionPerformed(evt));
        this.shutdownButton.addActionListener(evt -> this.shutdownActionPerformed(evt));
        this.controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.anchor = 23;
        gbc1.fill = 2;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        this.controlPanel.add((Component)this.updateStateWithSensorsButton, gbc1);
        ++gbc1.gridy;
        this.controlPanel.add((Component)this.completeInitializationButton, gbc1);
        ++gbc1.gridy;
        this.controlPanel.add((Component)this.abortButton, gbc1);
        ++gbc1.gridy;
        this.controlPanel.add((Component)this.shutdownButton, gbc1);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(this.title));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.subsStatePanel, gbc);
        ++gbc.gridx;
        gbc.gridheight = 2;
        this.add((Component)this.controlPanel, gbc);
        gbc.gridx = 0;
        gbc.gridheight = 1;
        ++gbc.gridy;
        this.add((Component)this.controlRealHardwareLabel, gbc);
    }

    private void updateStateWithSensorsActionPerformed(ActionEvent evt) {
        this.subs.updateStateWithSensors();
    }

    private void completeInitializationActionPerformed(ActionEvent evt) {
        this.subs.completeInitialization();
    }

    private void abortActionPerformed(ActionEvent evt) {
        this.subs.abortMyDestinationSubsystem();
    }

    private void shutdownActionPerformed(ActionEvent evt) {
        this.subs.shutdownMyDestinationSubsystem();
    }

    public static void main(String[] argv) {
        SubsystemPanel d = new SubsystemPanel("FCS");
        JFrame frame = new JFrame("Subsystem Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class UpdateSubsystemPanel
    implements Runnable {
        PublishedState pState;

        public UpdateSubsystemPanel(PublishedState state) {
            this.pState = state;
        }

        @Override
        public void run() {
            String state = this.pState.toString();
            String[] words = state.split("<");
            SubsystemPanel.this.subsystemStateLabel.setText(words[0]);
            Color bgColor = Color.gray;
            if (state.contains("INITIALIZING")) {
                bgColor = Color.orange;
            } else if (state.contains("OFF_LINE")) {
                bgColor = Color.GRAY;
            } else if (state.contains("ENGINEERING_FAULT")) {
                bgColor = Color.RED;
            } else if (state.contains("ENGINEERING_OK")) {
                bgColor = Color.YELLOW;
            } else if (state.contains("ACTIVE")) {
                bgColor = Color.BLUE;
            } else if (state.contains("OPERATIONAL:READY:NORMAL:NOMINAL")) {
                bgColor = Tools.greenColor;
            }
            SubsystemPanel.this.subsStatePanel.setBackground(bgColor);
        }
    }
}

