/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByPlutoGateway;
import org.lsst.ccs.subsystems.fcs.config.CANopenHardwareConfig;
import org.lsst.ccs.subsystems.fcs.config.PlutoGatewayConfig;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class PlutoGatewayPanel
extends JPanel {
    String gwName;
    JPanel generalInfoPanel;
    private final JLabel nLabel = new JLabel("Name: ");
    private final JLabel snLabel = new JLabel("Serial number: ");
    private final JLabel nIDLabel = new JLabel("CANopen node: ");
    private final JLabel bLabel = new JLabel("booted: ");
    private final JLabel iLabel = new JLabel("initialized: ");
    private final JLabel nameLabel = new JLabel("Unknown");
    private final JLabel serialLabel = new JLabel("XXXXXXXXX");
    private final JLabel nodeIDLabel = new JLabel("999");
    private final JLabel bootedLabel = new JLabel("false");
    private final JLabel initLabel = new JLabel("false");

    public PlutoGatewayPanel() {
        this.initComponents();
    }

    public void initializeGui(CANopenHardwareConfig canOpenHardwareConfig, PlutoGatewayConfig gwConfig) {
        SwingUtilities.invokeLater(new GuiInitialization(canOpenHardwareConfig, gwConfig));
    }

    public void updatePlutoGateway(StatusDataPublishedByPlutoGateway status) {
        SwingUtilities.invokeLater(new UpdatePlutoGateway(status));
    }

    private void initComponents() {
        this.generalInfoPanel = new JPanel();
        this.generalInfoPanel.setBorder(BorderFactory.createTitledBorder("General Informations"));
        this.generalInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.insets = Tools.insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        gbc3.anchor = 21;
        this.generalInfoPanel.add((Component)this.nLabel, gbc3);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.snLabel, gbc3);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.nIDLabel, gbc3);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.bLabel, gbc3);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.iLabel, gbc3);
        ++gbc3.gridx;
        gbc3.gridy = 0;
        gbc3.anchor = 22;
        this.generalInfoPanel.add((Component)this.nameLabel, gbc3);
        this.nameLabel.setFont(Tools.bigFont);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.serialLabel, gbc3);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.nodeIDLabel, gbc3);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.bootedLabel, gbc3);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.initLabel, gbc3);
        this.setBorder(BorderFactory.createLineBorder(Color.GREEN));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.generalInfoPanel, gbc);
    }

    public static void main(String[] argv) {
        JFrame frame = new JFrame("Pluto Gateway Panel");
        PlutoGatewayPanel p = new PlutoGatewayPanel();
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class GuiInitialization
    implements Runnable {
        CANopenHardwareConfig canOpenHardwareConfig;
        PlutoGatewayConfig gwConfig;

        public GuiInitialization(CANopenHardwareConfig canOpenHardwareConfig, PlutoGatewayConfig gwConfig) {
            this.canOpenHardwareConfig = canOpenHardwareConfig;
            this.gwConfig = gwConfig;
        }

        @Override
        public void run() {
            PlutoGatewayPanel.this.gwName = this.canOpenHardwareConfig.getName();
            PlutoGatewayPanel.this.nameLabel.setText(this.canOpenHardwareConfig.getName());
            PlutoGatewayPanel.this.serialLabel.setText(this.canOpenHardwareConfig.getSerialNB());
            PlutoGatewayPanel.this.nodeIDLabel.setText(this.canOpenHardwareConfig.getNodeID());
            PlutoGatewayPanel.this.bootedLabel.setText(Boolean.toString(this.canOpenHardwareConfig.isBooted()));
            PlutoGatewayPanel.this.initLabel.setText(Boolean.toString(this.canOpenHardwareConfig.isInitialized()));
        }
    }

    class UpdatePlutoGateway
    implements Runnable {
        StatusDataPublishedByPlutoGateway s;

        public UpdatePlutoGateway(StatusDataPublishedByPlutoGateway status) {
            this.s = status;
        }

        @Override
        public void run() {
            PlutoGatewayPanel.this.bootedLabel.setText(Boolean.toString(this.s.isBooted()));
            PlutoGatewayPanel.this.initLabel.setText(Boolean.toString(this.s.isInitialized()));
        }
    }
}

