/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.HeadlessException;
import java.io.PrintWriter;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import org.freehep.graphicsbase.swing.ErrorDialog;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.Agent;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.DataStatusListener;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.bus.StateChangeNotification;
import org.lsst.ccs.bus.StatusListener;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.subsystems.fcs.ui.commons.TopPanel;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class GeneralGUISubsystem
extends Subsystem
implements DataStatusListener,
StatusListener {
    protected static final Logger fcslog = Logger.getLogger((String)"org.lsst.ccs.subsystems.fcs");
    protected final String destination;
    protected PrintWriter out = new PrintWriter(System.out, true);
    protected TopPanel topPanel;
    protected boolean initialized = false;
    public JScrollPane pane;
    public long abortTimeout;
    public long updateStateWithSensorsTimeout;
    public long initializationTimeout;

    public GeneralGUISubsystem(String name, Agent.AgentType type, String destination) {
        super(name, type);
        this.destination = destination;
        this.abortTimeout = 1000L;
        this.updateStateWithSensorsTimeout = 1000L;
        this.initializationTimeout = 2000L;
    }

    public void initGui() {
        this.setListenToStatus(true);
        this.start();
    }

    public JComponent getGuiLayout() {
        return this.pane;
    }

    public void resetGui() {
    }

    public void shutdownMyDestinationSubsystem() {
        System.out.println("Shutting down " + this.destination);
        this.sendAsynchronousCommand(new ModuleInvokerCommand("shutdown", new Object[0]));
    }

    public void abortMyDestinationSubsystem() {
        System.out.println("Aborting " + this.destination);
        this.sendAsynchronousCommand(new ModuleInvokerCommand("abort", new Object[0]));
    }

    public void stopMyDestinationSubsystem() {
        System.out.println("Stopping " + this.destination);
        this.sendAsynchronousCommand(new ModuleInvokerCommand(this.destination, "stop", new Object[]{1000L}));
    }

    public void updateStateWithSensors() {
        log.info((Object)"Reading sensors", new String[0]);
        log.info((Object)("/timeout=" + this.updateStateWithSensorsTimeout), new String[0]);
        new CommandSwingWorker("updateStateWithSensors", this.updateStateWithSensorsTimeout).execute();
    }

    public void completeInitialization() {
        log.info((Object)"Reading sensors", new String[0]);
        log.info((Object)("/timeout=" + this.initializationTimeout), new String[0]);
        new CommandSwingWorker("completeInitialisation", this.initializationTimeout).execute();
    }

    public void sendCommandSwingWorker(String commandName, long timeout, String moduleName) {
        log.info((Object)(String.valueOf(this.getName()) + ": sending command= " + commandName + " to Module=" + moduleName), new String[0]);
        new CommandSwingWorker(commandName, timeout, moduleName).execute();
    }

    public void sendCommandSwingWorker(String commandName, long timeout) {
        log.info((Object)(String.valueOf(this.getName()) + ": sending command= " + commandName), new String[0]);
        new CommandSwingWorker(commandName, timeout).execute();
    }

    public void setPrintWriter(PrintWriter out) {
        this.out = out;
    }

    public void sendAsynchronousCommand(ModuleInvokerCommand cmd) {
        cmd.setDestination(this.destination);
        this.fac.sendCommand((Command)cmd);
    }

    public Object newSendCommand(ModuleInvokerCommand cmd, String commandDestination, long timeout) {
        try {
            cmd.setDestination(commandDestination);
            log.debug((Object)("fac=" + String.valueOf(this.fac)), new String[0]);
            SynchronousCommandAgent agent = new SynchronousCommandAgent(this.fac);
            log.debug((Object)("agent=" + String.valueOf(agent)), new String[0]);
            log.debug((Object)("command=" + String.valueOf(cmd)), new String[0]);
            Object response = agent.invoke((Command)cmd, timeout);
            String strRes = String.valueOf(response);
            log.debug((Object)("strRes=" + strRes), new String[0]);
            if (response == null) {
                strRes = "ok : DONE";
                return "ok : DONE";
            }
            strRes = String.valueOf(response);
            return strRes;
        }
        catch (Exception ex) {
            return ex;
        }
    }

    public void onStatus(BusMessage s) {
        if (!(s instanceof StateChangeNotification)) {
            return;
        }
        if (((StateChangeNotification)s).getOrigin().equals(this.destination)) {
            this.topPanel.getSubsystemPanel().update(((StateChangeNotification)s).getState());
        }
    }

    public class CommandSwingWorker
    extends SwingWorker<Object, Object> {
        String cmdDestination;
        String cmdName;
        long cmdTimeout;

        public CommandSwingWorker(String cmdN, long timeout) {
            if (cmdN == null) {
                throw new IllegalArgumentException("Command should not be null in CommandSwingWorker");
            }
            if (timeout == 0L) {
                throw new IllegalArgumentException("timeout should not be equal to 0 in CommandSwingWorker");
            }
            this.cmdDestination = GeneralGUISubsystem.this.destination;
            this.cmdName = cmdN;
            this.cmdTimeout = timeout;
        }

        public CommandSwingWorker(String cmdN, long timeout, String moduleName) {
            if (cmdN == null) {
                throw new IllegalArgumentException("Command should not be null in CommandSwingWorker");
            }
            if (timeout == 0L) {
                throw new IllegalArgumentException("timeout should not be equal to 0 in CommandSwingWorker");
            }
            if (moduleName == null) {
                throw new IllegalArgumentException("moduleName should not be null in this constructor of CommandSwingWorker");
            }
            this.cmdDestination = String.valueOf(GeneralGUISubsystem.this.destination) + "/" + moduleName;
            this.cmdName = cmdN;
            this.cmdTimeout = timeout;
        }

        @Override
        public Object doInBackground() {
            log.info((Object)("Executing " + this.cmdName + " on " + this.cmdDestination), new String[0]);
            log.info((Object)("/timeout=" + this.cmdTimeout), new String[0]);
            return GeneralGUISubsystem.this.newSendCommand(new ModuleInvokerCommand(this.cmdName, new Object[0]), this.cmdDestination, this.cmdTimeout);
        }

        @Override
        protected void done() {
            try {
                Object response = this.get();
                if (response instanceof Throwable) {
                    log.error((Object)String.valueOf(response), new String[0]);
                    log.error((Object)" command returned error", (Throwable)response, new String[0]);
                    ErrorDialog.showErrorDialog(null, (Object)response.toString(), (Throwable)((Throwable)response));
                    if (!(response instanceof BadCommandException)) {
                        GeneralGUISubsystem.this.raiseAlarm(response.toString());
                    }
                } else if (response == null) {
                    String strRes = "ok : DONE";
                    JOptionPane.showMessageDialog(null, strRes, this.cmdName, 1);
                } else {
                    String strRes = String.valueOf(response);
                    JOptionPane.showMessageDialog(null, strRes, this.cmdName, 1);
                }
            }
            catch (HeadlessException | InterruptedException | ExecutionException ex) {
                log.error((Object)ex.toString(), new String[0]);
                ErrorDialog.showErrorDialog(null, (Object)ex.toString(), (Throwable)ex);
                GeneralGUISubsystem.this.raiseAlarm(ex.toString());
            }
        }
    }
}

