/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.config.CANopenHardwareConfig;
import org.lsst.ccs.subsystems.fcs.config.EPOSControllerConfig;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSParametersPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUISubsystem;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.utilities.logging.Logger;

public class EPOSControllerPanel
extends JPanel {
    protected static final Logger fcslog = Logger.getLogger((String)"org.lsst.ccs.subsystems.fcs");
    private GeneralGUISubsystem subs;
    private String controllerName;
    JPanel generalInfoPanel;
    private final JLabel nLabel = new JLabel("Name: ");
    private final JLabel snLabel = new JLabel("Serial number: ");
    private final JLabel nIDLabel = new JLabel("CANopen node: ");
    private final JLabel bLabel = new JLabel("booted: ");
    private final JLabel iLabel = new JLabel("initialized: ");
    private final JLabel nameLabel = new JLabel("Unknown");
    private final JLabel serialLabel = new JLabel("XXXXXXXXX");
    private final JLabel nodeIDLabel = new JLabel("999");
    private final JLabel bootedLabel = new JLabel("false");
    private final JLabel initLabel = new JLabel("false");
    JPanel faultPanel;
    DigitalSwitch faultSwitch = new DigitalSwitch();
    JLabel errorRegisterLabel = new JLabel("99=XXXXXXXX error");
    JLabel errorHistoryNameLabel = new JLabel("Error History:");
    JLabel errorHistoryLabel = new JLabel();
    JPanel modePanel;
    private final JLabel mLabel = new JLabel("EPOS mode: ");
    private final JLabel modeLabel = new JLabel("UNKNOWN");
    JPanel controlPanel;
    JButton checkFaultButton = new JButton("CheckFault");
    JButton faultResetButton = new JButton("FaultReset");
    JButton refreshButton = new JButton("Refresh");
    EPOSParametersPanel currentParamsPanel = new EPOSParametersPanel();
    EPOSParametersPanel profile_positionParamsPanel = new EPOSParametersPanel();
    EPOSParametersPanel homingParamsPanel = new EPOSParametersPanel();

    public EPOSControllerPanel() {
        this.initComponents();
    }

    public void setSubsystem(GeneralGUISubsystem subs) {
        this.subs = subs;
    }

    public void initializeGui(CANopenHardwareConfig canOpenHardwareConfig, EPOSControllerConfig eposConfig) {
        SwingUtilities.invokeLater(new GuiInitialization(canOpenHardwareConfig, eposConfig));
    }

    public void updateController(StatusDataPublishedByEPOSController status) {
        SwingUtilities.invokeLater(new UpdateController(status));
    }

    private void initComponents() {
        this.checkFaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EPOSControllerPanel.this.checkFaultActionPerformed(evt);
            }
        });
        this.faultResetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EPOSControllerPanel.this.faultResetActionPerformed(evt);
            }
        });
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EPOSControllerPanel.this.refreshActionPerformed(evt);
            }
        });
        this.generalInfoPanel = new JPanel();
        this.generalInfoPanel.setBorder(BorderFactory.createTitledBorder("General Informations"));
        this.generalInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.insets = Tools.insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        gbc3.anchor = 21;
        this.generalInfoPanel.add((Component)this.nLabel, gbc3);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.snLabel, gbc3);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.nIDLabel, gbc3);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.bLabel, gbc3);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.iLabel, gbc3);
        ++gbc3.gridx;
        gbc3.gridy = 0;
        gbc3.anchor = 22;
        this.generalInfoPanel.add((Component)this.nameLabel, gbc3);
        this.nameLabel.setFont(Tools.bigFont);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.serialLabel, gbc3);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.nodeIDLabel, gbc3);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.bootedLabel, gbc3);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.initLabel, gbc3);
        this.modePanel = new JPanel();
        this.modePanel.setBorder(BorderFactory.createTitledBorder("EPOS mode"));
        this.modePanel.setPreferredSize(new Dimension(160, 50));
        this.modePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = Tools.insets_std;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        gbc2.anchor = 21;
        this.modeLabel.setFont(Tools.bigFont);
        this.modePanel.add((Component)this.modeLabel, gbc2);
        this.faultPanel = new JPanel();
        this.faultPanel.setBorder(BorderFactory.createTitledBorder("Error"));
        this.faultPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.anchor = 10;
        this.faultPanel.add((Component)this.faultSwitch, gbc1);
        ++gbc1.gridy;
        this.errorRegisterLabel.setFont(Tools.bigFont);
        this.faultPanel.add((Component)this.errorRegisterLabel, gbc1);
        ++gbc1.gridy;
        this.faultPanel.add((Component)this.errorHistoryNameLabel, gbc1);
        ++gbc1.gridy;
        this.faultPanel.add((Component)this.errorHistoryLabel, gbc1);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc4 = new GridBagConstraints();
        gbc4.anchor = 23;
        gbc4.fill = 2;
        gbc4.insets = Tools.insets_std;
        gbc4.gridx = 0;
        gbc4.gridy = 0;
        this.controlPanel.add((Component)this.refreshButton, gbc4);
        ++gbc4.gridy;
        this.controlPanel.add((Component)this.checkFaultButton, gbc4);
        ++gbc4.gridx;
        this.controlPanel.add((Component)this.faultResetButton, gbc4);
        this.setBorder(BorderFactory.createLineBorder(Color.GREEN));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.generalInfoPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.faultPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.modePanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.controlPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 4;
        this.add((Component)this.currentParamsPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.profile_positionParamsPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.homingParamsPanel, gbc);
    }

    private void checkFaultActionPerformed(ActionEvent evt) {
        this.subs.sendCommandSwingWorker("checkFault", 1000L, this.controllerName);
    }

    private void faultResetActionPerformed(ActionEvent evt) {
        this.subs.sendCommandSwingWorker("faultReset", 1000L, this.controllerName);
    }

    private void refreshActionPerformed(ActionEvent evt) {
        this.subs.sendCommandSwingWorker("publishData", 1000L, this.controllerName);
    }

    public static void main(String[] argv) {
        EPOSControllerPanel p = new EPOSControllerPanel();
        CANopenHardwareConfig hConfig = new CANopenHardwareConfig("hooksController", "1b", "79007141", Boolean.valueOf(false), Boolean.valueOf(false));
        HashMap<String, Integer> paramsMapCurrent = new HashMap<String, Integer>();
        paramsMapCurrent.put("ContinuousCurrentLimit", 3440);
        paramsMapCurrent.put("OutputCurrentLimit", 6880);
        paramsMapCurrent.put("MaxSpeedInCurrentMode", 2000);
        HashMap<String, Integer> paramsMapProfile_Position = new HashMap<String, Integer>();
        paramsMapProfile_Position.put("MinPositionLimit", -300);
        paramsMapProfile_Position.put("MaxPositionLimit", 550000);
        HashMap<String, Integer> paramsMapHoming = new HashMap<String, Integer>();
        paramsMapHoming.put("HomeOffset", 0);
        EPOSControllerConfig config = new EPOSControllerConfig("hooksController");
        config.setParamsForCurrent(paramsMapCurrent);
        config.setParamsForProfilePosition(paramsMapProfile_Position);
        config.setParamsForHoming(paramsMapHoming);
        p.initializeGui(hConfig, config);
        JFrame frame = new JFrame("EPOS Controller");
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class GuiInitialization
    implements Runnable {
        CANopenHardwareConfig canOpenHardwareConfig;
        EPOSControllerConfig ctlConfig;

        public GuiInitialization(CANopenHardwareConfig canOpenHardwareConfig, EPOSControllerConfig anEPOSConfig) {
            this.canOpenHardwareConfig = canOpenHardwareConfig;
            this.ctlConfig = anEPOSConfig;
        }

        @Override
        public void run() {
            EPOSControllerPanel.this.controllerName = this.canOpenHardwareConfig.getName();
            EPOSControllerPanel.this.nameLabel.setText(this.canOpenHardwareConfig.getName());
            EPOSControllerPanel.this.serialLabel.setText(this.canOpenHardwareConfig.getSerialNB());
            EPOSControllerPanel.this.nodeIDLabel.setText(this.canOpenHardwareConfig.getNodeID());
            EPOSControllerPanel.this.bootedLabel.setText(Boolean.toString(this.canOpenHardwareConfig.isBooted()));
            EPOSControllerPanel.this.initLabel.setText(Boolean.toString(this.canOpenHardwareConfig.isInitialized()));
            EPOSControllerPanel.this.faultSwitch.setColor(Color.GRAY);
            EPOSControllerPanel.this.errorRegisterLabel.setText("Unkown ERROR");
            EPOSControllerPanel.this.currentParamsPanel.initializeGUI(EPOSEnumerations.EposMode.CURRENT.toString(), this.ctlConfig.getParamsForCurrent());
            EPOSControllerPanel.this.profile_positionParamsPanel.initializeGUI(EPOSEnumerations.EposMode.PROFILE_POSITION.toString(), this.ctlConfig.getParamsForProfilePosition());
            EPOSControllerPanel.this.homingParamsPanel.initializeGUI(EPOSEnumerations.EposMode.HOMING.toString(), this.ctlConfig.getParamsForHoming());
        }
    }

    class UpdateController
    implements Runnable {
        StatusDataPublishedByEPOSController s;

        public UpdateController(StatusDataPublishedByEPOSController status) {
            this.s = status;
        }

        @Override
        public void run() {
            EPOSControllerPanel.this.bootedLabel.setText(Boolean.toString(this.s.isBooted()));
            EPOSControllerPanel.this.initLabel.setText(Boolean.toString(this.s.isInitialized()));
            EPOSControllerPanel.this.modeLabel.setText(this.s.getMode());
            EPOSControllerPanel.this.modeLabel.setFont(Tools.bigFont);
            if (this.s.isInitialized()) {
                EPOSControllerPanel.this.faultSwitch.setColor(this.s.isInError() ? Color.RED : Tools.greenColor);
                EPOSControllerPanel.this.errorRegisterLabel.setText(this.s.getErrorRegister());
                String[] historyList = this.s.getErrorHistory();
                if (historyList == null) {
                    EPOSControllerPanel.this.errorHistoryLabel.setText("no error");
                }
                if (historyList.length > 0) {
                    StringBuilder sb = new StringBuilder("<html>");
                    int i = 0;
                    while (i < this.s.getErrorHistory().length) {
                        if (i > 0) {
                            sb.append("<br>");
                        }
                        sb.append(historyList[i]);
                        ++i;
                    }
                    sb.append("</html>");
                    EPOSControllerPanel.this.errorHistoryLabel.setText(sb.toString());
                }
            } else {
                EPOSControllerPanel.this.errorRegisterLabel.setText("Not initialized");
            }
        }
    }
}

