/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderCarrierConfig;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderClampConfig;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderConfig;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderCarrierPanel;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderClampPanel;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderGUISubsystem;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.SubsystemPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.utilities.logging.Logger;

public class LoaderMainPanel
extends JPanel {
    protected static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystems.fcs");
    private LoaderGUISubsystem subs;
    private final JLabel onCameraLabel = new JLabel("ON CAMERA SENSOR");
    private final JLabel autochangerHoldingFilterLabel = new JLabel("AUTOCHANGER HOLDING FILTER SENSOR");
    private final JPanel fakeSensorsPanel = new JPanel();
    private final JPanel controlPanel = new JPanel();
    private final LoaderClampPanel loaderClampPanel = new LoaderClampPanel();
    private final LoaderCarrierPanel loaderCarrierPanel = new LoaderCarrierPanel();
    private final SubsystemPanel subsystemPanel = new SubsystemPanel("Loader Subsystem State");
    private final DigitalSwitch onCameraDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch autochangerHoldingFilterDigitalSwitch = new DigitalSwitch();
    private final JButton loadFilterButton = new JButton("loadFilterInCamera");
    private final JButton unloadFilterButton = new JButton("unloadFilterFromCamera");

    public LoaderMainPanel() {
        this.initComponents();
    }

    public LoaderMainPanel(LoaderGUISubsystem subs) {
        this.subs = subs;
        this.loaderClampPanel.setLoaderSubsystem(subs);
        this.loaderCarrierPanel.setLoaderSubsystem(subs);
        this.subsystemPanel.setSubsystem(subs);
        this.initComponents();
    }

    public void setSubsystem(LoaderGUISubsystem newSubs) {
        this.subs = newSubs;
        this.subsystemPanel.setSubsystem(this.subs);
        this.loaderClampPanel.setLoaderSubsystem(newSubs);
        this.loaderCarrierPanel.setLoaderSubsystem(newSubs);
    }

    public LoaderClampPanel getLoaderClampPanel() {
        return this.loaderClampPanel;
    }

    public SubsystemPanel getSubsystemPanel() {
        return this.subsystemPanel;
    }

    public void initializeGui(LoaderConfig config) {
        SwingUtilities.invokeLater(new GuiInitialization(config));
    }

    public void updateLoaderGeneral(StatusDataPublishedByLoader status) {
        SwingUtilities.invokeLater(new UpdateLoaderGeneral(status));
    }

    public void updateClamp(StatusDataPublishedByLoaderClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }

    public void updateCarrier(StatusDataPublishedByLoaderCarrier statusDataPublishedByLoaderCarrier) {
        SwingUtilities.invokeLater(new UpdateCarrier(statusDataPublishedByLoaderCarrier));
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)), "LOADER"));
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        this.loadFilterButton.addActionListener(evt -> this.loadFilterActionPerformed(evt));
        this.unloadFilterButton.addActionListener(evt -> this.unloadFilterActionPerformed(evt));
        this.controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.insets = Tools.insets_std;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.fill = 2;
        this.controlPanel.add((Component)this.loadFilterButton, gbc0);
        ++gbc0.gridy;
        this.controlPanel.add((Component)this.unloadFilterButton, gbc0);
        this.onCameraDigitalSwitch.setColor(Color.gray);
        this.autochangerHoldingFilterDigitalSwitch.setColor(Color.gray);
        this.fakeSensorsPanel.setBorder(BorderFactory.createTitledBorder("FAKE SENSORS"));
        this.fakeSensorsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.fill = 2;
        this.fakeSensorsPanel.add((Component)this.onCameraLabel, gbc1);
        ++gbc1.gridx;
        this.fakeSensorsPanel.add((Component)this.onCameraDigitalSwitch, gbc1);
        gbc1.insets = new Insets(0, 60, 0, 4);
        ++gbc1.gridx;
        this.fakeSensorsPanel.add((Component)this.autochangerHoldingFilterLabel, gbc1);
        gbc1.insets = Tools.insets_std;
        ++gbc1.gridx;
        this.fakeSensorsPanel.add((Component)this.autochangerHoldingFilterDigitalSwitch, gbc1);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 512;
        gbc.insets = Tools.insets_std;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.subsystemPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.controlPanel, gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.fakeSensorsPanel, gbc);
        gbc.anchor = 18;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        this.add((Component)this.loaderClampPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.add((Component)this.loaderCarrierPanel, gbc);
    }

    private void loadFilterActionPerformed(ActionEvent evt) {
        this.subs.loadFilter();
    }

    private void unloadFilterActionPerformed(ActionEvent evt) {
        this.subs.unloadFilter();
    }

    public static void main(String[] argv) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        LoaderMainPanel d = new LoaderMainPanel();
        JFrame frame = new JFrame("Loader Main Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class GuiInitialization
    implements Runnable {
        LoaderConfig loaderConfig;

        public GuiInitialization(LoaderConfig aConfig) {
            this.loaderConfig = aConfig;
        }

        @Override
        public void run() {
            LoaderMainPanel.this.subsystemPanel.setcontrolRealHardwareLabelText(this.loaderConfig.isRealHardware() ? "Real Hardware" : "Simulation");
            LoaderClampConfig loaderClampConfig = this.loaderConfig.getLoaderClampConfig();
            ((LoaderMainPanel)LoaderMainPanel.this).subs.openHooksTimeout = loaderClampConfig.getTimeoutToOpen();
            ((LoaderMainPanel)LoaderMainPanel.this).subs.closeHooksTimeout = loaderClampConfig.getTimeoutToClose();
            ((LoaderMainPanel)LoaderMainPanel.this).subs.clampHooksTimeout = loaderClampConfig.getTimeoutToClamp();
            ((LoaderMainPanel)LoaderMainPanel.this).subs.homingHooksTimeout = loaderClampConfig.getTimeoutToGoHome();
            LoaderMainPanel.this.loaderClampPanel.initializeGui(loaderClampConfig);
            LoaderCarrierConfig loaderCarrierConfig = this.loaderConfig.getLoaderCarrierConfig();
            ((LoaderMainPanel)LoaderMainPanel.this).subs.goToHandoffTimeout = loaderCarrierConfig.getTimeoutToGoToHandoff();
            ((LoaderMainPanel)LoaderMainPanel.this).subs.goToStorageTimeout = loaderCarrierConfig.getTimeoutToGoToStorage();
            LoaderMainPanel.this.loaderCarrierPanel.initializeGui(loaderCarrierConfig);
        }
    }

    class UpdateCarrier
    implements Runnable {
        StatusDataPublishedByLoaderCarrier s;

        public UpdateCarrier(StatusDataPublishedByLoaderCarrier s) {
            this.s = s;
        }

        @Override
        public void run() {
            LoaderMainPanel.this.loaderCarrierPanel.updateCarrier(this.s);
        }
    }

    class UpdateClamp
    implements Runnable {
        StatusDataPublishedByLoaderClamp s;

        UpdateClamp(StatusDataPublishedByLoaderClamp s) {
            this.s = s;
        }

        @Override
        public void run() {
            LoaderMainPanel.this.loaderClampPanel.updateClamp(this.s);
        }
    }

    class UpdateLoaderGeneral
    implements Runnable {
        StatusDataPublishedByLoader s;

        UpdateLoaderGeneral(StatusDataPublishedByLoader s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isLoaderOnCameraSensorsInError()) {
                LoaderMainPanel.this.onCameraDigitalSwitch.setColor(Color.RED);
            } else {
                LoaderMainPanel.this.onCameraDigitalSwitch.setColor(this.s.getLoaderOnCameraSensorValue0() == 1 ? Tools.greenColor : Color.gray);
            }
            LoaderMainPanel.this.autochangerHoldingFilterDigitalSwitch.setColor(this.s.getAutochangerHoldingFilterSensorValue() == 1 ? Tools.greenColor : Color.gray);
            LoaderMainPanel.this.loaderClampPanel.updateClamp(this.s);
        }
    }
}

