/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.bus.Agent;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderConfig;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderTopPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUISubsystem;

public class LoaderGUISubsystem
extends GeneralGUISubsystem {
    private static final String clampModuleName = "clamp";
    private static final String carrierModuleName = "carrier";
    private long lastHeartBeat = 0L;
    private long lastStateRequest = 0L;
    String stateCorrelId;
    long updateCarrierPositionTimeout;
    long openHooksTimeout;
    long closeHooksTimeout;
    long clampHooksTimeout;
    long homingHooksTimeout;
    long goToHandoffTimeout;
    long goToStorageTimeout;
    long quickStopTimeout;

    public LoaderGUISubsystem(String name, Agent.AgentType type, String destination) {
        super(name, type, destination);
        this.topPanel = new LoaderTopPanel(this);
        this.pane = new JScrollPane(this.topPanel);
        this.openHooksTimeout = 0L;
        this.closeHooksTimeout = 0L;
        this.clampHooksTimeout = 0L;
        this.homingHooksTimeout = 0L;
        this.goToHandoffTimeout = 0L;
        this.goToStorageTimeout = 0L;
        this.abortTimeout = 1000L;
        this.quickStopTimeout = 1000L;
        this.updateStateWithSensorsTimeout = 1000L;
        this.updateCarrierPositionTimeout = 1000L;
    }

    public void onReply(CommandReply s) {
        if (s.getCorrelId().equals(this.stateCorrelId)) {
            LoaderConfig config = (LoaderConfig)s.getReply();
            log.debug((Object)"--- Got a reply from subs", new String[0]);
            ((LoaderTopPanel)this.topPanel).initializeGui(config);
            this.initialized = true;
        }
    }

    public void onDataArrival(String source, long timestamp, String dataType, Object s) {
        block26: {
            block24: {
                if (!source.equals(this.destination)) {
                    return;
                }
                if (!this.initialized) break block24;
                switch (dataType) {
                    case "loaderGeneral": {
                        log.debug((Object)(String.valueOf(this.getName()) + " read data dataType:loaderGeneral"), new String[0]);
                        ((LoaderTopPanel)this.topPanel).updateLoaderGeneral((StatusDataPublishedByLoader)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "loaderClamp": {
                        log.debug((Object)(String.valueOf(this.getName()) + " read data dataType:loaderClamp"), new String[0]);
                        ((LoaderTopPanel)this.topPanel).updateClamp((StatusDataPublishedByLoaderClamp)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "loaderCarrier": {
                        log.debug((Object)(String.valueOf(this.getName()) + " read data dataType:loaderCarrier"), new String[0]);
                        ((LoaderTopPanel)this.topPanel).updateCarrier((StatusDataPublishedByLoaderCarrier)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "tcpProxy": {
                        log.debug((Object)(String.valueOf(this.getName()) + " read data dataType:tcpProxy"), new String[0]);
                        ((LoaderTopPanel)this.topPanel).updateCanOpenHardwarePanel((StatusDataPublishedByHardware)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "carrierController": {
                        log.debug((Object)(String.valueOf(this.getName()) + " read data dataType:loaderCarrierController"), new String[0]);
                        ((LoaderTopPanel)this.topPanel).updateCarrierController((StatusDataPublishedByEPOSController)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "hooksController": {
                        log.debug((Object)(String.valueOf(this.getName()) + " read data dataType:loaderClampController"), new String[0]);
                        ((LoaderTopPanel)this.topPanel).updateClampController((StatusDataPublishedByEPOSController)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    default: {
                        log.warning((Object)(String.valueOf(this.getName()) + " An unexpected dataType was read on the status bus:" + dataType), new String[0]);
                        break;
                    }
                }
                break block26;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastStateRequest > 2000L) {
                this.lastStateRequest = currentTime;
                ModuleInvokerCommand cmd = new ModuleInvokerCommand("getFullState", new Object[0]);
                this.sendAsynchronousCommand(cmd);
                this.stateCorrelId = cmd.getCorrelId();
            }
        }
    }

    protected void loadFilter() {
        System.out.println(String.valueOf(this.destination) + "loadFilterInCamera with timeout=" + this.goToHandoffTimeout);
        log.info((Object)"Loading filter in camera", new String[0]);
        log.info((Object)("/timeout=" + this.goToHandoffTimeout), new String[0]);
        new GeneralGUISubsystem.CommandSwingWorker("loadFilterInCamera", this.goToHandoffTimeout).execute();
    }

    protected void unloadFilter() {
        System.out.println(String.valueOf(this.destination) + "unloadFilterFromCamera with timeout=" + this.goToStorageTimeout);
        log.info((Object)"Loading filter in camera", new String[0]);
        log.info((Object)("/timeout=" + this.goToStorageTimeout), new String[0]);
        new GeneralGUISubsystem.CommandSwingWorker("unloadFilterFromCamera", this.goToStorageTimeout).execute();
    }

    protected void updateCarrierPosition() {
        System.out.println(String.valueOf(this.destination) + "updateCarrierPosition with updateCarrierPositionTimeout=" + this.updateCarrierPositionTimeout);
        log.info((Object)"Updating carrier position", new String[0]);
        log.info((Object)("/timeout=" + this.updateCarrierPositionTimeout), new String[0]);
        new GeneralGUISubsystem.CommandSwingWorker("updatePosition", this.updateCarrierPositionTimeout, carrierModuleName).execute();
    }

    protected void openHooks() {
        log.info((Object)"Opening Hooks", new String[0]);
        log.info((Object)("/timeout=" + this.openHooksTimeout), new String[0]);
        new GeneralGUISubsystem.CommandSwingWorker("openHooks", this.openHooksTimeout).execute();
    }

    protected void closeHooks() {
        log.info((Object)"Closing Hooks", new String[0]);
        System.out.println("/timeout=" + this.closeHooksTimeout);
        new GeneralGUISubsystem.CommandSwingWorker("closeHooks", this.closeHooksTimeout).execute();
    }

    protected void clampHooks() {
        log.info((Object)"Clamping Hooks", new String[0]);
        log.info((Object)("/timeout=" + this.clampHooksTimeout), new String[0]);
        new GeneralGUISubsystem.CommandSwingWorker("clampHooks", this.clampHooksTimeout).execute();
    }

    protected void goToHomePosition() {
        log.info((Object)"Clamp going to Home Position", new String[0]);
        log.info((Object)("/timeout=" + this.homingHooksTimeout), new String[0]);
        new GeneralGUISubsystem.CommandSwingWorker("goToHomePosition", this.homingHooksTimeout, clampModuleName).execute();
    }

    protected void goToClosePosition() {
        log.info((Object)"Going to Close Position", new String[0]);
        log.info((Object)("/timeout=" + this.clampHooksTimeout), new String[0]);
        new GeneralGUISubsystem.CommandSwingWorker("goToClampedPosition", this.clampHooksTimeout, clampModuleName).execute();
    }

    protected void goToHandOff() {
        log.info((Object)"Carrier going to Handoff Position", new String[0]);
        log.info((Object)("/timeout=" + this.goToHandoffTimeout), new String[0]);
        new GeneralGUISubsystem.CommandSwingWorker("goToHandOff", this.goToHandoffTimeout, carrierModuleName).execute();
    }

    protected void goToStorage() {
        System.out.println(String.valueOf(this.destination) + "goToStorage with goToStorageTimeout=" + this.goToStorageTimeout);
        log.info((Object)"Carrier going to Storage Position", new String[0]);
        log.info((Object)("/timeout=" + this.goToStorageTimeout), new String[0]);
        new GeneralGUISubsystem.CommandSwingWorker("goToStorage", this.goToStorageTimeout, carrierModuleName).execute();
    }

    public static void main(String[] args) {
        LoaderGUISubsystem t = new LoaderGUISubsystem("LoaderGUIModule", Agent.AgentType.CONSOLE, "testbenchLPSC");
        JFrame frame = new JFrame("Loader View GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(3);
    }
}

