/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderClampConfig;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderGUISubsystem;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderHookPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.FilterPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.subsystems.fcs.ui.commons.VerticalProgressBarPanel;
import org.lsst.ccs.utilities.logging.Logger;

public class LoaderClampPanel
extends JPanel {
    protected static final Logger fcslog = Logger.getLogger((String)"org.lsst.ccs.subsystems.fcs");
    private LoaderGUISubsystem subs;
    private final JLabel clampState = new JLabel("UNKNOWN STATE");
    private final JLabel clampStateLabel = new JLabel("Clamp State :");
    private final JLabel xMinusLabel = new JLabel("X-");
    private final JLabel xMinuxLabel2 = new JLabel("X-");
    private final JLabel xPlusLabel = new JLabel("X+");
    private final JLabel xPlusLabel2 = new JLabel("X+");
    private LoaderHookPanel hookPanel1;
    private LoaderHookPanel hookPanel2;
    private LoaderHookPanel hookPanel3;
    private LoaderHookPanel hookPanel4;
    private final FilterPanel filterPanel = new FilterPanel();
    private VerticalProgressBarPanel positionProgressBarPanel;
    private VerticalProgressBarPanel currentProgressBarPanel;
    private JButton closeHooksButton;
    private JButton openHooksButton;
    private JButton goToClampedPositionButton;
    private JButton goToHomePositionButton;
    private JButton clampHooksButton;
    private JButton updateStateWithSensorsButton;
    private JButton abortButton;

    public LoaderClampPanel() {
        this.initComponents();
    }

    public void setLoaderSubsystem(LoaderGUISubsystem subs) {
        this.subs = subs;
    }

    public void initializeGui(LoaderClampConfig config) {
        SwingUtilities.invokeLater(new GuiInitialization(config));
    }

    public void updateClamp(StatusDataPublishedByLoaderClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }

    public void updateClamp(StatusDataPublishedByLoader status) {
        SwingUtilities.invokeLater(new UpdateFilterPanel(status));
    }

    private void initComponents() {
        Font xFont = new Font("Tahoma", 1, 18);
        this.xMinusLabel.setFont(xFont);
        this.xMinuxLabel2.setFont(xFont);
        this.xPlusLabel2.setFont(xFont);
        this.xPlusLabel.setFont(xFont);
        JPanel hooksPanel = new JPanel();
        JPanel clampStatePanel = new JPanel();
        JPanel controlPanel = new JPanel();
        this.hookPanel2 = new LoaderHookPanel();
        this.hookPanel4 = new LoaderHookPanel();
        this.hookPanel3 = new LoaderHookPanel();
        this.hookPanel1 = new LoaderHookPanel();
        this.currentProgressBarPanel = new VerticalProgressBarPanel("Current", -300, 500, 0);
        this.currentProgressBarPanel.setStringPainted(false);
        this.positionProgressBarPanel = new VerticalProgressBarPanel("Position", 5000, 480000, 0);
        this.filterPanel.setColor(Color.gray);
        this.updateStateWithSensorsButton = new JButton("Read sensors and update state");
        this.openHooksButton = new JButton("Open");
        this.goToClampedPositionButton = new JButton("Go To Clamped Position");
        this.clampHooksButton = new JButton("Clamp");
        this.closeHooksButton = new JButton("Close");
        this.goToHomePositionButton = new JButton("Go To Home Position");
        this.abortButton = new JButton("Abort");
        this.updateStateWithSensorsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoaderClampPanel.this.updateStateWithSensorsButtonActionPerformed(evt);
            }
        });
        this.openHooksButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoaderClampPanel.this.openHooksButtonActionPerformed(evt);
            }
        });
        this.goToClampedPositionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoaderClampPanel.this.goToClampedPositionButtonActionPerformed(evt);
            }
        });
        this.clampHooksButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoaderClampPanel.this.clampHooksButtonActionPerformed(evt);
            }
        });
        this.closeHooksButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoaderClampPanel.this.closeHooksButtonActionPerformed(evt);
            }
        });
        this.goToHomePositionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoaderClampPanel.this.goToHomePositionButtonActionPerformed(evt);
            }
        });
        this.abortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoaderClampPanel.this.abortActionPerformed(evt);
            }
        });
        this.clampState.setFont(Tools.bigFont);
        this.clampState.setBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 255), new Color(255, 255, 255)));
        clampStatePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = Tools.insets_std;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        clampStatePanel.add((Component)this.clampStateLabel, gbc2);
        ++gbc2.gridx;
        clampStatePanel.add((Component)this.clampState, gbc2);
        hooksPanel.setLayout(new GridBagLayout());
        hooksPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.ORANGE), "Hooks State"));
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        this.hookPanel1.setHookName("Hook 1");
        this.hookPanel1.setHookLocation(0);
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        hooksPanel.add((Component)this.hookPanel1, gbc1);
        this.hookPanel2.setHookName("Hook 2");
        this.hookPanel2.setHookLocation(0);
        ++gbc1.gridx;
        hooksPanel.add((Component)this.hookPanel2, gbc1);
        this.hookPanel3.setHookName("Hook 3");
        this.hookPanel3.setHookLocation(0);
        gbc1.gridx = 0;
        gbc1.gridy = 1;
        hooksPanel.add((Component)this.hookPanel3, gbc1);
        this.hookPanel4.setHookName("Hook 4");
        this.hookPanel4.setHookLocation(0);
        ++gbc1.gridx;
        hooksPanel.add((Component)this.hookPanel4, gbc1);
        controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.anchor = 23;
        gbc3.fill = 2;
        gbc3.insets = Tools.insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        controlPanel.add((Component)this.updateStateWithSensorsButton, gbc3);
        ++gbc3.gridy;
        controlPanel.add((Component)this.goToHomePositionButton, gbc3);
        ++gbc3.gridy;
        controlPanel.add((Component)this.goToClampedPositionButton, gbc3);
        ++gbc3.gridy;
        controlPanel.add((Component)this.openHooksButton, gbc3);
        ++gbc3.gridy;
        controlPanel.add((Component)this.closeHooksButton, gbc3);
        ++gbc3.gridy;
        controlPanel.add((Component)this.clampHooksButton, gbc3);
        ++gbc3.gridy;
        controlPanel.add((Component)this.abortButton, gbc3);
        this.setBorder(BorderFactory.createTitledBorder("LOADER CLAMP"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.xMinusLabel, gbc);
        gbc.anchor = 13;
        gbc.gridx = 3;
        this.add((Component)this.xPlusLabel, gbc);
        gbc.gridx = 0;
        gbc.gridwidth = 4;
        gbc.anchor = 10;
        this.add((Component)clampStatePanel, gbc);
        ++gbc.gridy;
        this.add((Component)hooksPanel, gbc);
        gbc.insets = Tools.insets_big;
        gbc.insets = new Insets(14, 30, 6, 30);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.add((Component)this.positionProgressBarPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.currentProgressBarPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.filterPanel, gbc);
        ++gbc.gridx;
        gbc.anchor = 13;
        this.add((Component)controlPanel, gbc);
    }

    private void updateStateWithSensorsButtonActionPerformed(ActionEvent evt) {
        this.subs.updateStateWithSensors();
    }

    private void openHooksButtonActionPerformed(ActionEvent evt) {
        this.subs.openHooks();
    }

    private void closeHooksButtonActionPerformed(ActionEvent evt) {
        this.subs.closeHooks();
    }

    private void clampHooksButtonActionPerformed(ActionEvent evt) {
        this.subs.clampHooks();
    }

    private void goToHomePositionButtonActionPerformed(ActionEvent evt) {
        this.subs.goToHomePosition();
    }

    private void goToClampedPositionButtonActionPerformed(ActionEvent evt) {
        this.subs.goToClosePosition();
    }

    private void abortActionPerformed(ActionEvent evt) {
        this.subs.abortMyDestinationSubsystem();
    }

    public static void main(String[] argv) {
        LoaderClampPanel d = new LoaderClampPanel();
        JFrame frame = new JFrame("New Loader Clamp Panel");
        d.currentProgressBarPanel.setValueName("Current");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class GuiInitialization
    implements Runnable {
        LoaderClampConfig loaderClampConfig;

        public GuiInitialization(LoaderClampConfig aConfig) {
            this.loaderClampConfig = aConfig;
        }

        @Override
        public void run() {
            LoaderClampPanel.this.positionProgressBarPanel.setMinValue(this.loaderClampConfig.getMinPosition());
            LoaderClampPanel.this.positionProgressBarPanel.setMaxValue(this.loaderClampConfig.getMaxPosition());
            LoaderClampPanel.this.positionProgressBarPanel.setValue(0);
            LoaderClampPanel.this.currentProgressBarPanel.setMinValue(this.loaderClampConfig.getMinCurrent());
            LoaderClampPanel.this.currentProgressBarPanel.setMaxValue(this.loaderClampConfig.getMaxCurrent());
            LoaderClampPanel.this.currentProgressBarPanel.setValue(0);
        }
    }

    class UpdateClamp
    implements Runnable {
        StatusDataPublishedByLoaderClamp s;

        public UpdateClamp(StatusDataPublishedByLoaderClamp status) {
            this.s = status;
        }

        @Override
        public void run() {
            String clampStateString = this.s.getClampState();
            Color clampStateColor = Tools.getLockSensorColor(clampStateString);
            int clampPosition = this.s.getPosition();
            LoaderClampPanel.this.clampState.setText(clampStateString);
            LoaderClampPanel.this.clampState.setForeground(clampStateColor);
            LoaderClampPanel.this.positionProgressBarPanel.setValue(clampPosition);
            LoaderClampPanel.this.positionProgressBarPanel.setColor(clampStateColor);
            LoaderClampPanel.this.currentProgressBarPanel.setValue(this.s.getCurrent());
            LoaderClampPanel.this.hookPanel1.updateHook(this.s.getStatusPublishedByHook1());
            LoaderClampPanel.this.hookPanel2.updateHook(this.s.getStatusPublishedByHook2());
            LoaderClampPanel.this.hookPanel3.updateHook(this.s.getStatusPublishedByHook3());
            LoaderClampPanel.this.hookPanel4.updateHook(this.s.getStatusPublishedByHook4());
        }
    }

    class UpdateFilterPanel
    implements Runnable {
        StatusDataPublishedByLoader s;

        public UpdateFilterPanel(StatusDataPublishedByLoader s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isFilterPresenceSensorsInError()) {
                LoaderClampPanel.this.filterPanel.setColor(Color.red);
            } else {
                LoaderClampPanel.this.filterPanel.setIsFilterInHouse(this.s.getFilterPresenceSensorValue0() == 1);
            }
        }
    }
}

