/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.carousel.config.CarouselConfig;
import org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselMainPanel;
import org.lsst.ccs.subsystems.fcs.config.CanOpenProxyConfig;
import org.lsst.ccs.subsystems.fcs.config.EPOSControllerConfig;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenHardwarePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUISubsystem;
import org.lsst.ccs.subsystems.fcs.ui.commons.SubsystemPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.subsystems.fcs.ui.commons.TopPanel;

public class CarouselTopPanel
extends TopPanel {
    private GeneralGUISubsystem subs;
    private JTabbedPane jTabbedPane;
    CarouselMainPanel carouselMainPanel;
    private CanOpenHardwarePanel hardwarePanel;
    private EPOSControllerPanel carouselControllerPanel;

    public CarouselTopPanel() {
        this.initComponents();
    }

    public CarouselTopPanel(GeneralGUISubsystem subs) {
        this.subs = subs;
        this.initComponents();
        this.carouselControllerPanel.setSubsystem(subs);
    }

    @Override
    public SubsystemPanel getSubsystemPanel() {
        return this.carouselMainPanel.getSubsystemPanel();
    }

    public void initializeGui(CarouselConfig carouselConfig) {
        SwingUtilities.invokeLater(new GuiInitialization(carouselConfig));
    }

    void updateCanOpenHardwarePanel(StatusDataPublishedByHardware s) {
        this.hardwarePanel.updateCanOpenHardwarePanel(s);
    }

    void updateCarouselController(StatusDataPublishedByEPOSController s) {
        this.carouselControllerPanel.updateController(s);
    }

    private void initComponents() {
        this.carouselMainPanel = new CarouselMainPanel();
        JScrollPane mainViewScrollPane = new JScrollPane(this.carouselMainPanel);
        mainViewScrollPane.createVerticalScrollBar();
        mainViewScrollPane.setPreferredSize(new Dimension(1200, 600));
        this.hardwarePanel = new CanOpenHardwarePanel();
        this.carouselControllerPanel = new EPOSControllerPanel();
        this.jTabbedPane = new JTabbedPane();
        this.jTabbedPane.setBorder(BorderFactory.createLineBorder(new Color(0, 150, 180)));
        this.jTabbedPane.addTab("Carousel Main View", mainViewScrollPane);
        this.jTabbedPane.addTab("Carousel CANopen Devices", this.hardwarePanel);
        this.jTabbedPane.addTab("Carousel Controller", this.carouselControllerPanel);
        this.setLayout(new GridBagLayout());
        this.setForeground(new Color(204, 204, 255));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 512;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.jTabbedPane, gbc);
    }

    public static void main(String[] argv) {
        CarouselTopPanel d = new CarouselTopPanel();
        JFrame frame = new JFrame("Carousel Top Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class GuiInitialization
    implements Runnable {
        CarouselConfig carouselConfig;
        CanOpenProxyConfig canOpenProxyConfig;
        EPOSControllerConfig controllerConfig;

        public GuiInitialization(CarouselConfig carouselConfig) {
            this.carouselConfig = carouselConfig;
            this.canOpenProxyConfig = carouselConfig.getTcpProxyConfig();
            this.controllerConfig = carouselConfig.getControllerConfig();
        }

        @Override
        public void run() {
            CarouselTopPanel.this.carouselMainPanel.initializeGui(this.carouselConfig);
            CarouselTopPanel.this.hardwarePanel.initializeGui(this.canOpenProxyConfig);
            CarouselTopPanel.this.carouselControllerPanel.initializeGui(Tools.retrieveControllerInfo(this.canOpenProxyConfig, this.controllerConfig), this.controllerConfig);
        }
    }
}

