/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.bus.Agent;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.carousel.config.CarouselConfig;
import org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselTopPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUISubsystem;

public class CarouselGUI
extends GeneralGUISubsystem {
    private long lastHeartBeat = 0L;
    private long lastStateRequest = 0L;
    String stateCorrelId;

    public CarouselGUI(String name, Agent.AgentType type, String destination) {
        super(name, type, destination);
        this.topPanel = new CarouselTopPanel(this);
        this.pane = new JScrollPane(this.topPanel);
    }

    public void onReply(CommandReply s) {
        if (s.getCorrelId().equals(this.stateCorrelId)) {
            CarouselConfig config = (CarouselConfig)s.getReply();
            log.debug((Object)(String.valueOf(this.getName()) + "--- Got a reply from subs"), new String[0]);
            ((CarouselTopPanel)this.topPanel).initializeGui(config);
            this.initialized = true;
        }
    }

    public void onDataArrival(String source, long timestamp, String dataType, Object s) {
        block14: {
            block12: {
                if (!source.equals(this.destination)) {
                    return;
                }
                if (!this.initialized) break block12;
                switch (dataType) {
                    case "tcpProxy": {
                        log.debug((Object)(String.valueOf(this.getName()) + " read data dataType:tcpProxy"), new String[0]);
                        ((CarouselTopPanel)this.topPanel).updateCanOpenHardwarePanel((StatusDataPublishedByHardware)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "carouselController": {
                        log.debug((Object)(String.valueOf(this.getName()) + " read data dataType:linearRailMasterController"), new String[0]);
                        ((CarouselTopPanel)this.topPanel).updateCarouselController((StatusDataPublishedByEPOSController)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    default: {
                        log.warning((Object)(String.valueOf(this.getName()) + " An unexpected dataType was read on the status bus:" + dataType), new String[0]);
                        break;
                    }
                }
                break block14;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastStateRequest > 2000L) {
                this.lastStateRequest = currentTime;
                ModuleInvokerCommand cmd = new ModuleInvokerCommand("getFullState", new Object[0]);
                this.sendAsynchronousCommand(cmd);
                this.stateCorrelId = cmd.getCorrelId();
            }
        }
    }

    public static void main(String[] args) {
        CarouselGUI t = new CarouselGUI("CarouselGUI", Agent.AgentType.CONSOLE, "carousel");
        JFrame frame = new JFrame("Carousel View GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(3);
    }
}

