/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerGUI;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerLatchPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.FilterPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.utilities.logging.Logger;

public class AutochangerTwoLatchesPanel
extends JPanel {
    static final Logger fcslog = Logger.getLogger((String)"org.lsst.ccs.subsystems.fcs");
    private AutochangerGUI subs;
    private final JLabel latchesState = new JLabel("UNKNOWN STATE");
    private final JLabel latchesStateLabel = new JLabel("LATCHES STATE :");
    private final JLabel xMinusLabel = new JLabel("X-");
    private final JLabel xMinuxLabel2 = new JLabel("X-");
    private final JLabel xPlusLabel = new JLabel("X+");
    private final JLabel xPlusLabel2 = new JLabel("X+");
    private AutochangerLatchPanel latchXminusPanel;
    private AutochangerLatchPanel latchXplusPanel;
    private final FilterPanel filterPanel = new FilterPanel();
    private JButton closeLatchesButton;
    private JButton openLatchesButton;
    private JButton updateStateWithSensorsButton;
    private JButton abortButton;

    public AutochangerTwoLatchesPanel() {
        this.initComponents();
    }

    public void setSubs(AutochangerGUI subs) {
        this.subs = subs;
    }

    public void updateLatch(StatusDataPublishedByAutochangerLatch s) {
        fcslog.finest((Object)(String.valueOf(this.getName()) + " Data published by Latch= " + s.toString()), new String[0]);
        String latchName = s.getName();
        if (latchName.contains("Xminus")) {
            this.latchXminusPanel.updateLatch(s);
        } else if (latchName.contains("Xplus")) {
            this.latchXplusPanel.updateLatch(s);
        } else {
            fcslog.error((Object)(String.valueOf(this.getName()) + " received autochanger Latch status with an unknown name. " + "Can't update the GUI."), new String[0]);
            assert (false) : "Latch name should contains Xminus or Xplus.";
        }
    }

    public void updateLatches(StatusDataPublishedByAutochangerTwoLatches s) {
        SwingUtilities.invokeLater(new UpdateLatches(s));
    }

    private void initComponents() {
        Font xFont = new Font("Tahoma", 1, 18);
        this.xMinusLabel.setFont(xFont);
        this.xMinuxLabel2.setFont(xFont);
        this.xPlusLabel2.setFont(xFont);
        this.xPlusLabel.setFont(xFont);
        JPanel latchesPanel = new JPanel();
        JPanel latchesStatePanel = new JPanel();
        JPanel controlPanel = new JPanel();
        this.latchXminusPanel = new AutochangerLatchPanel();
        this.latchXplusPanel = new AutochangerLatchPanel();
        this.filterPanel.setColor(Color.gray);
        this.updateStateWithSensorsButton = new JButton("Read sensors and update state");
        this.openLatchesButton = new JButton("Open");
        this.closeLatchesButton = new JButton("Close");
        this.abortButton = new JButton("Abort");
        this.latchesState.setFont(Tools.bigFont);
        this.latchesState.setBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 255), new Color(255, 255, 255)));
        latchesStatePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = Tools.insets_std;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        latchesStatePanel.add((Component)this.latchesStateLabel, gbc2);
        ++gbc2.gridx;
        latchesStatePanel.add((Component)this.latchesState, gbc2);
        latchesPanel.setLayout(new GridBagLayout());
        latchesPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.YELLOW), "Latches State"));
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        this.latchXminusPanel.setLatchName("Latch 1");
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        latchesPanel.add((Component)this.latchXminusPanel, gbc1);
        this.latchXplusPanel.setLatchName("Latch 2");
        ++gbc1.gridx;
        latchesPanel.add((Component)this.latchXplusPanel, gbc1);
        controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.anchor = 23;
        gbc3.fill = 2;
        gbc3.insets = Tools.insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        controlPanel.add((Component)this.updateStateWithSensorsButton, gbc3);
        ++gbc3.gridy;
        controlPanel.add((Component)this.openLatchesButton, gbc3);
        ++gbc3.gridy;
        controlPanel.add((Component)this.closeLatchesButton, gbc3);
        ++gbc3.gridy;
        controlPanel.add((Component)this.abortButton, gbc3);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.PINK), "AUTOCHANGER LATCHES"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.xMinusLabel, gbc);
        gbc.anchor = 13;
        gbc.gridx = 3;
        this.add((Component)this.xPlusLabel, gbc);
        gbc.gridx = 0;
        gbc.gridwidth = 4;
        gbc.anchor = 10;
        this.add((Component)latchesStatePanel, gbc);
        ++gbc.gridy;
        this.add((Component)latchesPanel, gbc);
        gbc.insets = Tools.insets_big;
        gbc.insets = new Insets(14, 30, 6, 30);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.filterPanel, gbc);
        ++gbc.gridx;
        gbc.anchor = 13;
        this.add((Component)controlPanel, gbc);
    }

    public static void main(String[] argv) {
        AutochangerTwoLatchesPanel d = new AutochangerTwoLatchesPanel();
        JFrame frame = new JFrame("Autochanger Latches Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    class UpdateLatches
    implements Runnable {
        StatusDataPublishedByAutochangerTwoLatches s;

        public UpdateLatches(StatusDataPublishedByAutochangerTwoLatches status) {
            this.s = status;
        }

        @Override
        public void run() {
            AutochangerTwoLatchesPanel.this.latchesState.setText(this.s.getLockStatus().toString());
            AutochangerTwoLatchesPanel.this.filterPanel.setIsFilterInHouse(this.s.getFilterPresenceStatus().equals((Object)FcsEnumerations.FilterPresenceStatus.ENGAGED));
            if (this.s.getFilterPresenceStatus().equals((Object)FcsEnumerations.FilterPresenceStatus.UNKNOWN)) {
                AutochangerTwoLatchesPanel.this.filterPanel.setColor(Color.YELLOW);
            }
        }
    }
}

