/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.autochanger.config.AutochangerConfig;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerGUI;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerMainPanel;
import org.lsst.ccs.subsystems.fcs.config.CanOpenProxyConfig;
import org.lsst.ccs.subsystems.fcs.config.EPOSControllerConfig;
import org.lsst.ccs.subsystems.fcs.config.PlutoGatewayConfig;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenHardwarePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUISubsystem;
import org.lsst.ccs.subsystems.fcs.ui.commons.PlutoGatewayPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.SubsystemPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.subsystems.fcs.ui.commons.TopPanel;

public class AutochangerTopPanel
extends TopPanel {
    private GeneralGUISubsystem subs;
    private JTabbedPane jTabbedPane;
    AutochangerMainPanel autochangerMainPanel;
    private CanOpenHardwarePanel hardwarePanel;
    private EPOSControllerPanel linearRailMasterControllerPanel;
    private EPOSControllerPanel linearRailSlaveControllerPanel;
    private EPOSControllerPanel latchXminusControllerPanel;
    private EPOSControllerPanel latchXplusControllerPanel;
    private EPOSControllerPanel onlineClampControllerPanel;
    private PlutoGatewayPanel plutoGatewayPanel;

    public AutochangerTopPanel() {
        this.initComponents();
    }

    public AutochangerTopPanel(AutochangerGUI subs) {
        this.subs = subs;
        this.initComponents();
        this.autochangerMainPanel.setSubsystem(subs);
        this.linearRailMasterControllerPanel.setSubsystem(subs);
        this.linearRailSlaveControllerPanel.setSubsystem(subs);
        this.latchXminusControllerPanel.setSubsystem(subs);
        this.latchXplusControllerPanel.setSubsystem(subs);
        this.onlineClampControllerPanel.setSubsystem(subs);
    }

    @Override
    public SubsystemPanel getSubsystemPanel() {
        return this.autochangerMainPanel.getSubsystemPanel();
    }

    public void initializeGui(AutochangerConfig autochangerConfig) {
        SwingUtilities.invokeLater(new GuiInitialization(autochangerConfig));
    }

    void updateCanOpenHardwarePanel(StatusDataPublishedByHardware s) {
        this.hardwarePanel.updateCanOpenHardwarePanel(s);
    }

    void updateLinearRailMasterController(StatusDataPublishedByEPOSController s) {
        this.linearRailMasterControllerPanel.updateController(s);
    }

    void updateLinearRailSlaveController(StatusDataPublishedByEPOSController s) {
        this.linearRailSlaveControllerPanel.updateController(s);
    }

    void updateLatchXminusController(StatusDataPublishedByEPOSController s) {
        this.latchXminusControllerPanel.updateController(s);
    }

    void updateLatchXplusController(StatusDataPublishedByEPOSController s) {
        this.latchXplusControllerPanel.updateController(s);
    }

    void updateOnlineClampController(StatusDataPublishedByEPOSController s) {
        this.onlineClampControllerPanel.updateController(s);
    }

    void updateTrucks(StatusDataPublishedByAutoChangerTrucks s) {
        fcslog.finest((Object)(" Data published by Trucks= " + s.toString()), new String[0]);
        this.autochangerMainPanel.updateTrucks(s);
    }

    void updateAutochanger(StatusDataPublishedByAutoChanger s) {
        this.autochangerMainPanel.update(s);
    }

    void updateLatch(StatusDataPublishedByAutochangerLatch s) {
        this.autochangerMainPanel.updateLatch(s);
    }

    void updateLatches(StatusDataPublishedByAutochangerTwoLatches s) {
        this.autochangerMainPanel.updateLatches(s);
    }

    private void initComponents() {
        this.autochangerMainPanel = new AutochangerMainPanel();
        JScrollPane mainViewScrollPane = new JScrollPane(this.autochangerMainPanel);
        mainViewScrollPane.createVerticalScrollBar();
        mainViewScrollPane.setPreferredSize(new Dimension(1200, 600));
        this.hardwarePanel = new CanOpenHardwarePanel();
        this.linearRailMasterControllerPanel = new EPOSControllerPanel();
        this.linearRailSlaveControllerPanel = new EPOSControllerPanel();
        this.latchXminusControllerPanel = new EPOSControllerPanel();
        this.latchXplusControllerPanel = new EPOSControllerPanel();
        this.onlineClampControllerPanel = new EPOSControllerPanel();
        this.plutoGatewayPanel = new PlutoGatewayPanel();
        this.jTabbedPane = new JTabbedPane();
        this.jTabbedPane.setBorder(BorderFactory.createLineBorder(new Color(0, 150, 180)));
        this.jTabbedPane.addTab("Autochanger Main View", mainViewScrollPane);
        this.jTabbedPane.addTab("Autochanger CANopen Devices", this.hardwarePanel);
        this.jTabbedPane.addTab("Linear Rail Master Controller", this.linearRailMasterControllerPanel);
        this.jTabbedPane.addTab("Linear Rail Slave Controller", this.linearRailSlaveControllerPanel);
        this.jTabbedPane.addTab("LatchXminus Controller", this.latchXminusControllerPanel);
        this.jTabbedPane.addTab("LatchXplus Controller", this.latchXplusControllerPanel);
        this.jTabbedPane.addTab("Online Clamp Controller", this.onlineClampControllerPanel);
        this.jTabbedPane.addTab("Pluto Gateway", this.plutoGatewayPanel);
        this.setLayout(new GridBagLayout());
        this.setForeground(new Color(204, 204, 255));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 512;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.jTabbedPane, gbc);
    }

    public static void main(String[] argv) {
        AutochangerTopPanel d = new AutochangerTopPanel();
        JFrame frame = new JFrame("Autochanger High Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class GuiInitialization
    implements Runnable {
        AutochangerConfig autochangerConfig;
        CanOpenProxyConfig canOpenProxyConfig;
        EPOSControllerConfig lrMasterCtlConfig;
        EPOSControllerConfig lrSlaveCtlConfig;
        EPOSControllerConfig latchXminusCtlConfig;
        EPOSControllerConfig latchXplusCtlConfig;
        EPOSControllerConfig onlineCtlConfig;
        PlutoGatewayConfig gwConfig;

        public GuiInitialization(AutochangerConfig autochangerConfig) {
            this.autochangerConfig = autochangerConfig;
            this.canOpenProxyConfig = autochangerConfig.getTcpProxyConfig();
            this.lrMasterCtlConfig = autochangerConfig.getLinearRailMasterControllerConfig();
            this.lrSlaveCtlConfig = autochangerConfig.getLinearRailSlaveControllerConfig();
            this.latchXminusCtlConfig = autochangerConfig.getLatchXminusControllerConfig();
            this.latchXplusCtlConfig = autochangerConfig.getLatchXplusControllerConfig();
            this.onlineCtlConfig = autochangerConfig.getOnlineClampControllerConfig();
            this.gwConfig = autochangerConfig.getGwConfig();
        }

        @Override
        public void run() {
            AutochangerTopPanel.this.autochangerMainPanel.initializeGui(this.autochangerConfig);
            AutochangerTopPanel.this.hardwarePanel.initializeGui(this.canOpenProxyConfig);
            AutochangerTopPanel.this.linearRailMasterControllerPanel.initializeGui(Tools.retrieveControllerInfo(this.canOpenProxyConfig, this.lrMasterCtlConfig), this.lrMasterCtlConfig);
            AutochangerTopPanel.this.linearRailSlaveControllerPanel.initializeGui(Tools.retrieveControllerInfo(this.canOpenProxyConfig, this.lrSlaveCtlConfig), this.lrSlaveCtlConfig);
            AutochangerTopPanel.this.latchXminusControllerPanel.initializeGui(Tools.retrieveControllerInfo(this.canOpenProxyConfig, this.latchXminusCtlConfig), this.latchXminusCtlConfig);
            AutochangerTopPanel.this.latchXplusControllerPanel.initializeGui(Tools.retrieveControllerInfo(this.canOpenProxyConfig, this.latchXplusCtlConfig), this.latchXplusCtlConfig);
            AutochangerTopPanel.this.onlineClampControllerPanel.initializeGui(Tools.retrieveControllerInfo(this.canOpenProxyConfig, this.onlineCtlConfig), this.onlineCtlConfig);
            AutochangerTopPanel.this.plutoGatewayPanel.initializeGui(Tools.retrieveDeviceInfo(this.canOpenProxyConfig, this.gwConfig.getName()), this.gwConfig);
        }
    }
}

