/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.state.PublishedState;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.autochanger.config.AutochangerConfig;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerGUI;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerTrucksPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerTwoLatchesPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.SubsystemPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.utilities.logging.Logger;

public class AutochangerMainPanel
extends JPanel {
    protected static final Logger fcslog = Logger.getLogger((String)"org.lsst.ccs.subsystems.fcs");
    private AutochangerGUI subs;
    private final SubsystemPanel subsystemPanel = new SubsystemPanel("Autochanger Subsystem State");
    private final JPanel loaderConnectedPanel = new JPanel();
    JLabel loaderConnectedLabel = new JLabel("<html><P align=\"center\">Loader<br>sensor</p></html>");
    DigitalSwitch loaderConnectedDigitalSwitch = new DigitalSwitch();
    String connectedS = "<html><P align=\"center\">Loader<br>connected</p></html>";
    String notConnectedS = "<html><P align=\"center\">Loader<br>not<br>connected</p></html>";
    private final AutochangerTrucksPanel acTrucksPanel = new AutochangerTrucksPanel();
    private final AutochangerTwoLatchesPanel acLatchesPanel = new AutochangerTwoLatchesPanel();

    public AutochangerMainPanel() {
        this.initComponents();
    }

    public AutochangerMainPanel(AutochangerGUI subs) {
        this.subs = subs;
        this.initComponents();
        this.subsystemPanel.setSubsystem(subs);
        this.acTrucksPanel.setSubsystem(subs);
    }

    public void setSubsystem(AutochangerGUI subs) {
        this.subs = subs;
        this.subsystemPanel.setSubsystem(subs);
        this.acTrucksPanel.setSubsystem(subs);
    }

    public SubsystemPanel getSubsystemPanel() {
        return this.subsystemPanel;
    }

    public void initializeGui(AutochangerConfig config) {
        SwingUtilities.invokeLater(new GuiInitialization(config));
    }

    void updateState(PublishedState state) {
        this.subsystemPanel.update(state);
    }

    public void updateTrucks(StatusDataPublishedByAutoChangerTrucks s) {
        fcslog.finest((Object)(String.valueOf(this.getName()) + " Data published by Trucks= " + s.toString()), new String[0]);
        this.acTrucksPanel.updateTrucks(s);
    }

    public void updateLatch(StatusDataPublishedByAutochangerLatch s) {
        fcslog.finest((Object)(String.valueOf(this.getName()) + " Data published by Latch= " + s.toString()), new String[0]);
        this.acLatchesPanel.updateLatch(s);
    }

    public void updateLatches(StatusDataPublishedByAutochangerTwoLatches s) {
        fcslog.finest((Object)(String.valueOf(this.getName()) + " Data published by Latches= " + s.toString()), new String[0]);
        this.acLatchesPanel.updateLatches(s);
    }

    public void update(StatusDataPublishedByAutoChanger s) {
        SwingUtilities.invokeLater(new Update(s));
    }

    private void initComponents() {
        this.loaderConnectedDigitalSwitch.setColor(Color.GRAY);
        GridBagConstraints gbc0 = new GridBagConstraints();
        this.loaderConnectedPanel.setBorder(BorderFactory.createLineBorder(Color.pink, 6));
        gbc0.anchor = 512;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        this.loaderConnectedPanel.add((Component)this.loaderConnectedLabel, gbc0);
        ++gbc0.gridy;
        this.loaderConnectedPanel.add((Component)this.loaderConnectedDigitalSwitch, gbc0);
        GridBagConstraints gbc = new GridBagConstraints();
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)), "AUTOCHANGER"));
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        gbc.anchor = 512;
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.subsystemPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.loaderConnectedPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        this.add((Component)this.acLatchesPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.acTrucksPanel, gbc);
    }

    public static void main(String[] argv) {
        AutochangerMainPanel d = new AutochangerMainPanel();
        JFrame frame = new JFrame("Autochanger Main Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class GuiInitialization
    implements Runnable {
        AutochangerConfig acConfig;

        public GuiInitialization(AutochangerConfig aConfig) {
            this.acConfig = aConfig;
        }

        @Override
        public void run() {
            AutochangerMainPanel.this.subsystemPanel.setcontrolRealHardwareLabelText(this.acConfig.isRealHardware() ? "Real Hardware" : "Simulation");
            AutochangerMainPanel.this.acTrucksPanel.initializeGui(this.acConfig.getTrucksConfig());
            AutochangerMainPanel.this.subs.setTimeoutForTrucksMotion(this.acConfig.getTrucksConfig().getTimeoutForTrucksMotion());
        }
    }

    private class Update
    implements Runnable {
        StatusDataPublishedByAutoChanger s;

        public Update(StatusDataPublishedByAutoChanger status) {
            this.s = status;
        }

        @Override
        public void run() {
            if (this.s.isLoaderConnectedSensorsInError()) {
                AutochangerMainPanel.this.loaderConnectedDigitalSwitch.setColor(Color.RED);
            } else if (this.s.getLoaderConnectedSensorValue0() == 1 && this.s.getLoaderConnectedSensorValue1() == 1) {
                AutochangerMainPanel.this.loaderConnectedDigitalSwitch.setColor(Tools.greenColor);
                AutochangerMainPanel.this.loaderConnectedLabel.setText(AutochangerMainPanel.this.connectedS);
            } else {
                AutochangerMainPanel.this.loaderConnectedDigitalSwitch.setColor(Color.gray);
                AutochangerMainPanel.this.loaderConnectedLabel.setText(AutochangerMainPanel.this.notConnectedS);
            }
        }
    }
}

