/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.utilities.logging.Logger;

public class AutochangerLatchPanel
extends JPanel {
    static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystems.fcs");
    private DigitalSwitch unlockSensorDS;
    private DigitalSwitch lockSensorDS;
    private DigitalSwitch filterEngagedSensorDS;
    private DigitalSwitch errorDS;
    private JLabel latchName;
    private JLabel unlockLabel;
    private JLabel lockLabel;
    private JLabel errorLabel;
    private JLabel filterEngagedLabel;
    private JLabel lockStatus;
    JPanel faultPanel;
    DigitalSwitch faultSwitch;

    public AutochangerLatchPanel() {
        this.initComponents();
    }

    void setLatchName(String name) {
        this.latchName.setText(name);
    }

    public void updateLatch(StatusDataPublishedByAutochangerLatch status) {
        SwingUtilities.invokeLater(new UpdateLatch(status));
    }

    private void initComponents() {
        this.unlockSensorDS = new DigitalSwitch();
        this.unlockSensorDS.setColor(Color.gray);
        this.lockSensorDS = new DigitalSwitch();
        this.lockSensorDS.setColor(Color.gray);
        this.filterEngagedSensorDS = new DigitalSwitch();
        this.filterEngagedSensorDS.setColor(Color.gray);
        this.errorDS = new DigitalSwitch();
        this.errorDS.setColor(Color.gray);
        this.latchName = new JLabel("myLatch");
        this.unlockLabel = new JLabel("<html><P align=\"center\">UNLOCK<br>SENSOR</p></html>");
        this.lockLabel = new JLabel("<html><P align=\"center\">LOCK<br>SENSOR</p></html>");
        this.errorLabel = new JLabel("ERROR");
        this.filterEngagedLabel = new JLabel("<html><P align=\"center\">FILTER<br>ENGAGED</p></html>");
        this.lockStatus = new JLabel("UNKNOWN STATE");
        this.faultPanel = new JPanel();
        this.faultSwitch = new DigitalSwitch();
        this.faultSwitch.setColor(Color.GRAY);
        this.faultPanel.setBorder(BorderFactory.createTitledBorder("Controller"));
        this.faultPanel.setLayout(new GridBagLayout());
        this.faultPanel.setPreferredSize(new Dimension(100, 100));
        this.faultSwitch.setColor(Color.GRAY);
        this.faultSwitch.setSize(50);
        GridBagConstraints gbcf = new GridBagConstraints();
        gbcf.insets = Tools.insets_std;
        gbcf.gridx = 0;
        gbcf.gridy = 0;
        gbcf.anchor = 10;
        this.faultPanel.add((Component)this.faultSwitch, gbcf);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_big;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.latchName, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.add((Component)this.unlockSensorDS, gbc);
        ++gbc.gridy;
        this.add((Component)this.unlockLabel, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        this.add((Component)this.lockSensorDS, gbc);
        ++gbc.gridy;
        this.add((Component)this.lockLabel, gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        this.add((Component)this.filterEngagedSensorDS, gbc);
        ++gbc.gridy;
        this.add((Component)this.filterEngagedLabel, gbc);
        gbc.gridx = 4;
        gbc.gridy = 0;
        this.add((Component)this.errorDS, gbc);
        ++gbc.gridy;
        this.add((Component)this.errorLabel, gbc);
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        this.add((Component)this.faultPanel, gbc);
    }

    public static void main(String[] argv) {
        AutochangerLatchPanel d = new AutochangerLatchPanel();
        JFrame frame = new JFrame("Autochanger Latch Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    class UpdateLatch
    implements Runnable {
        StatusDataPublishedByAutochangerLatch s;

        public UpdateLatch(StatusDataPublishedByAutochangerLatch status) {
            this.s = status;
        }

        @Override
        public void run() {
            boolean inTravel;
            AutochangerLatchPanel.this.latchName.setText(this.s.getName());
            AutochangerLatchPanel.this.unlockSensorDS.setColor(this.s.getUnlockSensorValue() == 1 ? Tools.greenColor : Color.gray);
            AutochangerLatchPanel.this.lockSensorDS.setColor(this.s.getLockSensorValue() == 1 ? Tools.greenColor : Color.gray);
            AutochangerLatchPanel.this.filterEngagedSensorDS.setColor(this.s.getFilterPresenceSensorValue() == 1 ? Tools.greenColor : Color.gray);
            boolean bl = inTravel = this.s.getUnlockSensorValue() == 0 && this.s.getLockSensorValue() == 0;
            if (this.s.isInError()) {
                AutochangerLatchPanel.this.errorDS.setColor(Color.RED);
                AutochangerLatchPanel.this.errorLabel.setText("IN ERROR");
            } else if (inTravel) {
                AutochangerLatchPanel.this.errorDS.setColor(Color.YELLOW);
                AutochangerLatchPanel.this.errorLabel.setText("IN TRAVEL");
            } else if (this.s.getLockStatus().equals(FcsEnumerations.LockStatus.UNKNOWN)) {
                AutochangerLatchPanel.this.errorDS.setColor(Color.DARK_GRAY);
                AutochangerLatchPanel.this.errorLabel.setText("UNKNOWN");
            } else {
                AutochangerLatchPanel.this.errorDS.setColor(Color.GREEN);
                AutochangerLatchPanel.this.errorLabel.setText("NO ERROR");
            }
            AutochangerLatchPanel.this.lockStatus.setText(this.s.getLockStatus());
            Color latchLockStatusColor = Tools.getLockSensorColor(this.s.getLockStatus());
            AutochangerLatchPanel.this.lockStatus.setBackground(latchLockStatusColor);
        }
    }
}

