/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.bus.Agent;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.autochanger.config.AutochangerConfig;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerTopPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUISubsystem;

public class AutochangerGUI
extends GeneralGUISubsystem {
    private long lastHeartBeat = 0L;
    private long lastStateRequest = 0L;
    String stateCorrelId;
    private static final String trucksModuleName = "autochangerTrucks";
    private static final String onlineModuleName = "onlineClamp";
    final long updateTrucksPositionTimeout;
    long timeoutForTrucksMotion;

    public AutochangerGUI(String name, Agent.AgentType type, String destination) {
        super(name, type, destination);
        this.topPanel = new AutochangerTopPanel(this);
        this.pane = new JScrollPane(this.topPanel);
        this.updateTrucksPositionTimeout = 1000L;
        this.timeoutForTrucksMotion = 0L;
    }

    public void setTimeoutForTrucksMotion(long timeoutForTrucksMotion) {
        this.timeoutForTrucksMotion = timeoutForTrucksMotion;
    }

    public void onReply(CommandReply s) {
        if (s.getCorrelId().equals(this.stateCorrelId)) {
            AutochangerConfig config = (AutochangerConfig)s.getReply();
            fcslog.debug((Object)(String.valueOf(this.getName()) + "--- Got a reply from subs"), new String[0]);
            ((AutochangerTopPanel)this.topPanel).initializeGui(config);
            this.initialized = true;
        }
    }

    public void onDataArrival(String source, long timestamp, String dataType, Object s) {
        block38: {
            block36: {
                if (!source.equals(this.destination)) {
                    return;
                }
                if (!this.initialized) break block36;
                switch (dataType) {
                    case "tcpProxy": {
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " read data dataType:tcpProxy"), new String[0]);
                        ((AutochangerTopPanel)this.topPanel).updateCanOpenHardwarePanel((StatusDataPublishedByHardware)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "autochangerGeneral": {
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " read data dataType:autochangerGeneral"), new String[0]);
                        ((AutochangerTopPanel)this.topPanel).updateAutochanger((StatusDataPublishedByAutoChanger)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "linearRailMasterController": {
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " read data dataType:linearRailMasterController"), new String[0]);
                        ((AutochangerTopPanel)this.topPanel).updateLinearRailMasterController((StatusDataPublishedByEPOSController)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "linearRailSlaveController": {
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " read data dataType:linearRailSlaveController"), new String[0]);
                        ((AutochangerTopPanel)this.topPanel).updateLinearRailSlaveController((StatusDataPublishedByEPOSController)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "latchXminusController": {
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " read data dataType:latchXminusController"), new String[0]);
                        ((AutochangerTopPanel)this.topPanel).updateLatchXminusController((StatusDataPublishedByEPOSController)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "latchXplusController": {
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " read data dataType:latchXplusController"), new String[0]);
                        ((AutochangerTopPanel)this.topPanel).updateLatchXplusController((StatusDataPublishedByEPOSController)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "onlineClampController": {
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " read data dataType:onlineClampController"), new String[0]);
                        ((AutochangerTopPanel)this.topPanel).updateOnlineClampController((StatusDataPublishedByEPOSController)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "autochangerTrucks": {
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " read data dataType:autochangerTrucks"), new String[0]);
                        fcslog.finest((Object)(String.valueOf(this.getName()) + " Data published by Trucks= " + ((StatusDataPublishedByAutoChangerTrucks)s).toString()), new String[0]);
                        ((AutochangerTopPanel)this.topPanel).updateTrucks((StatusDataPublishedByAutoChangerTrucks)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "autochangerLatch": {
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " read data dataType:autochangerLatch"), new String[0]);
                        fcslog.finest((Object)(String.valueOf(this.getName()) + " Data published by Latch= " + ((StatusDataPublishedByAutochangerLatch)s).toString()), new String[0]);
                        ((AutochangerTopPanel)this.topPanel).updateLatch((StatusDataPublishedByAutochangerLatch)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "autochangerLatches": {
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " read data dataType:autochangerLatches"), new String[0]);
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " Data published by Latches= " + ((StatusDataPublishedByAutochangerTwoLatches)s).toString()), new String[0]);
                        ((AutochangerTopPanel)this.topPanel).updateLatches((StatusDataPublishedByAutochangerTwoLatches)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    default: {
                        fcslog.warning((Object)(String.valueOf(this.getName()) + " An unexpected dataType was read on the status bus:" + dataType), new String[0]);
                        break;
                    }
                }
                break block38;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastStateRequest > 2000L) {
                this.lastStateRequest = currentTime;
                ModuleInvokerCommand cmd = new ModuleInvokerCommand("getFullState", new Object[0]);
                this.sendAsynchronousCommand(cmd);
                this.stateCorrelId = cmd.getCorrelId();
            }
        }
    }

    public static void main(String[] args) {
        AutochangerGUI t = new AutochangerGUI("AutochangerGUI", Agent.AgentType.CONSOLE, "testbenchCPPM");
        JFrame frame = new JFrame("Autochanger View GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(3);
    }

    void updateTrucksPosition() {
        System.out.println("Autochanger updating Trucks position");
        fcslog.info((Object)"Autochanger updating Trucks position", new String[0]);
        fcslog.info((Object)("/timeout=" + this.updateTrucksPositionTimeout), new String[0]);
        new GeneralGUISubsystem.CommandSwingWorker("updatePosition", this.updateTrucksPositionTimeout, trucksModuleName).execute();
    }

    void goToHandOff() {
        System.out.println("Autochanger Trucks going to Handoff position");
        fcslog.info((Object)"Autochanger Trucks going to Handoff Position", new String[0]);
        fcslog.info((Object)("/timeout=" + this.timeoutForTrucksMotion), new String[0]);
        new GeneralGUISubsystem.CommandSwingWorker("goToHandOff", this.timeoutForTrucksMotion, trucksModuleName).execute();
    }

    void goToStandby() {
        System.out.println("Autochanger Trucks going to Standby position");
        fcslog.info((Object)"Autochanger Trucks going to Standby Position", new String[0]);
        fcslog.info((Object)("/timeout=" + this.timeoutForTrucksMotion), new String[0]);
        new GeneralGUISubsystem.CommandSwingWorker("goToStandby", this.timeoutForTrucksMotion, trucksModuleName).execute();
    }

    void goToOnline() {
        System.out.println("Autochanger Trucks going to Online position");
        fcslog.info((Object)"Autochanger Trucks going to Online Position", new String[0]);
        fcslog.info((Object)("/timeout=" + this.timeoutForTrucksMotion), new String[0]);
        new GeneralGUISubsystem.CommandSwingWorker("goToOnline", this.timeoutForTrucksMotion, trucksModuleName).execute();
    }
}

