/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.state.PublishedState;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.bigFont;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.greenColor;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 * This panel displays the subsystem state and some information
 * specific to the subsystem.
 * @author virieux
 */
public class SubsystemPanel extends JPanel {
    
    private final String title;
    private GeneralGUISubsystem subs;
    
    //state panel
    private final JPanel subsStatePanel= new JPanel();
    private final JPanel controlPanel = new JPanel();
    private final JLabel controlRealHardwareLabel = new JLabel("unknown hardware type");
    private final JLabel subsystemStateLabel = new JLabel("UNREACHABLE SUBSYSTEM");
    
    //control panel    
    private final JButton updateStateWithSensorsButton = new JButton("updateStateWithSensors");
    private final JButton completeInitializationButton = new JButton("completeInitialization");
    private final JButton abortButton = new JButton("Abort");
    private final JButton shutdownButton = new JButton("Shutdown FCS");
    
    
    private class UpdateSubsystemPanel implements Runnable {

        PublishedState pState;
        
        public UpdateSubsystemPanel(PublishedState state) {
            this.pState = state;
        }

        @Override
        public void run() {
            //state panel
            String state = pState.toString();
            String[] words = state.split("<");
            subsystemStateLabel.setText(words[0]);
            Color bgColor = Color.gray; 
            if (state.contains("INITIALIZING")) bgColor=Color.orange;
            else if (state.contains("OFF_LINE")) bgColor=Color.GRAY;
            else if (state.contains("ENGINEERING_FAULT")) bgColor=Color.RED;
            else if (state.contains("ENGINEERING_OK")) bgColor=Color.YELLOW;
            else if (state.contains("ACTIVE")) bgColor=Color.BLUE;
            else if (state.contains("OPERATIONAL:READY:NORMAL:NOMINAL")) bgColor=greenColor;
            subsStatePanel.setBackground(bgColor);
        }
    }

    public SubsystemPanel(String title) {
        this.title = title;
        this.initComponents();
    }

    public void setSubsystem(GeneralGUISubsystem subs) {
        this.subs = subs;
    }
    
    public void setcontrolRealHardwareLabelText(String atext) {
        this.controlRealHardwareLabel.setText(atext);
    }
    
    public void update(PublishedState state) { 
        SwingUtilities.invokeLater(new UpdateSubsystemPanel(state));
    }
    
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form Description">                          
    private void initComponents() {
        
        //Subsystem State Panel
        controlRealHardwareLabel.setFont(bigFont); // NOI18N
        subsystemStateLabel.setFont(bigFont);
      
//        subsStatePanel.setBorder(BorderFactory.createTitledBorder(title));
        subsStatePanel.setBackground(Color.GRAY);
        subsStatePanel.setPreferredSize(new Dimension(400,50));        
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.anchor = GridBagConstraints.LINE_START;
        gbc0.gridx = 0;
        gbc0.gridy = 0;       
        subsStatePanel.add(subsystemStateLabel, gbc0);
        //end Subsystem State Panel
        
        /**
         ******************************************************************************
         **  Control Panel
         ******************************************************************************
         */
        updateStateWithSensorsButton.addActionListener((ActionEvent evt) -> {
            updateStateWithSensorsActionPerformed(evt);
        });
        
        completeInitializationButton.addActionListener((ActionEvent evt) -> {
            completeInitializationActionPerformed(evt);
        });
        
        abortButton.addActionListener((ActionEvent evt) -> {
            abortActionPerformed(evt);
        });
        
        shutdownButton.addActionListener((ActionEvent evt) -> {
            shutdownActionPerformed(evt);
        });

        controlPanel.setLayout(new java.awt.GridBagLayout());
        GridBagConstraints gbc1 = new java.awt.GridBagConstraints();
        gbc1.anchor = GridBagConstraints.FIRST_LINE_START;
        gbc1.fill = GridBagConstraints.HORIZONTAL;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        controlPanel.add(updateStateWithSensorsButton,gbc1);
        gbc1.gridy++;
        controlPanel.add(completeInitializationButton,gbc1);
        gbc1.gridy++;
        controlPanel.add(abortButton,gbc1);
        gbc1.gridy++;
        controlPanel.add(shutdownButton,gbc1);
         /**
         ******************************************************************************
         **  Control Panel
         ******************************************************************************
         */
        
        //Whole Panel
        setLayout(new GridBagLayout());
        setBorder(BorderFactory.createTitledBorder(title));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.NORTHWEST;
        gbc.insets = insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        add(subsStatePanel,gbc);
        gbc.gridx++;
        gbc.gridheight = 2;
        add(controlPanel,gbc);
        gbc.gridx = 0;
        gbc.gridheight = 1;
        gbc.gridy++;
        add(controlRealHardwareLabel, gbc);
        //end Whole Panel
        
    }
    
    private void updateStateWithSensorsActionPerformed(ActionEvent evt) {                                                   
        subs.updateStateWithSensors();
    }
    
    private void completeInitializationActionPerformed(ActionEvent evt) {                                                   
        subs.completeInitialization();
    }
    
    private void abortActionPerformed(ActionEvent evt) {                                      
        subs.abortMyDestinationSubsystem();
    } 
    
    private void shutdownActionPerformed(ActionEvent evt) {                                      
        subs.shutdownMyDestinationSubsystem();
    }
    
     public static void main(String[] argv) {
        
        SubsystemPanel d = new SubsystemPanel("FCS");
        JFrame frame = new JFrame("Subsystem Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }   


    
}
