/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByPlutoGateway;
import org.lsst.ccs.subsystems.fcs.config.CANopenHardwareConfig;
import org.lsst.ccs.subsystems.fcs.config.PlutoGatewayConfig;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.bigFont;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 *
 * @author virieux
 */
public class PlutoGatewayPanel extends JPanel {
    
    /** Variables declaration **/
    String gwName;
    //general informations panel
    JPanel generalInfoPanel;
    private final JLabel nLabel = new JLabel("Name: ");
    private final JLabel snLabel = new JLabel("Serial number: ");
    private final JLabel nIDLabel = new JLabel("CANopen node: ");
    private final JLabel bLabel = new JLabel("booted: ");
    private final JLabel iLabel = new JLabel("initialized: ");
    private final JLabel nameLabel = new JLabel("Unknown");
    private final JLabel serialLabel = new JLabel("XXXXXXXXX");
    private final JLabel nodeIDLabel = new JLabel("999");

    private final JLabel bootedLabel = new JLabel("false");
    private final JLabel initLabel = new JLabel("false");
    
    private  class GuiInitialization implements Runnable {
        
        CANopenHardwareConfig canOpenHardwareConfig;
        PlutoGatewayConfig  gwConfig;

        public GuiInitialization(CANopenHardwareConfig canOpenHardwareConfig,
                PlutoGatewayConfig gwConfig) {
            this.canOpenHardwareConfig = canOpenHardwareConfig;
            this.gwConfig = gwConfig;
        }

        @Override
        public void run() {           
             //General Informations Panel
            gwName = canOpenHardwareConfig.getName();
            nameLabel.setText(canOpenHardwareConfig.getName());
            serialLabel.setText(canOpenHardwareConfig.getSerialNB());
            nodeIDLabel.setText(canOpenHardwareConfig.getNodeID());
            bootedLabel.setText(Boolean.toString(canOpenHardwareConfig.isBooted()));
            initLabel.setText(Boolean.toString(canOpenHardwareConfig.isInitialized()));           
         }
    }
    
     /**
     * Creates new form PlutoGatewayPanel
     */
    public PlutoGatewayPanel() {
        initComponents();
    }
    
    public void initializeGui(CANopenHardwareConfig canOpenHardwareConfig,
            PlutoGatewayConfig gwConfig) {
        SwingUtilities.invokeLater(new PlutoGatewayPanel.GuiInitialization(canOpenHardwareConfig,gwConfig));
    }

    public void updatePlutoGateway(StatusDataPublishedByPlutoGateway status) {
        SwingUtilities.invokeLater(new PlutoGatewayPanel.UpdatePlutoGateway(status));
    }
    
    class UpdatePlutoGateway implements Runnable {
        
        StatusDataPublishedByPlutoGateway s;

        public UpdatePlutoGateway(StatusDataPublishedByPlutoGateway status) {
            this.s = status;
        }

        @Override
        public void run() {
                //General Informations Panel
                bootedLabel.setText(Boolean.toString(s.isBooted()));
                initLabel.setText(Boolean.toString(s.isInitialized()));               
            }
    }
    
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form description">                          
    private void initComponents() {
        
         /**
         ******************************************************************************
         **  General Informations Panel
         ******************************************************************************
         */
        generalInfoPanel = new JPanel();
        generalInfoPanel.setBorder(BorderFactory.createTitledBorder("General Informations"));
        generalInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.insets = insets_std;
        //first colomn
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        gbc3.anchor = GridBagConstraints.LINE_START;

        generalInfoPanel.add(nLabel,gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(snLabel,gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(nIDLabel,gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(bLabel,gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(iLabel,gbc3);
        //second colomn
        gbc3.gridx++;
        gbc3.gridy = 0;
        gbc3.anchor = GridBagConstraints.LINE_END;
        generalInfoPanel.add(nameLabel,gbc3);
        nameLabel.setFont(bigFont);
        gbc3.gridy++;
        generalInfoPanel.add(serialLabel,gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(nodeIDLabel,gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(bootedLabel,gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(initLabel,gbc3);
         /**
         ******************************************************************************
         **  End of General Informations Panel
         ******************************************************************************
         */
        
         /**
         ******************************************************************************
         **  Whole Panel
         ******************************************************************************
         */
        
        setBorder(javax.swing.BorderFactory.createLineBorder(Color.GREEN));
        //setForeground(new java.awt.Color(204, 204, 255));
        setLayout(new java.awt.GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_std;
        gbc.anchor = GridBagConstraints.NORTHWEST;

        gbc.gridx = 0;
        gbc.gridy = 0;
        add(generalInfoPanel,gbc);
        
        
         /**
         ******************************************************************************
         **  end of Whole Panel
         ******************************************************************************
         */
        
    }
    
    public static void main(String[] argv) {
        JFrame frame = new JFrame("Pluto Gateway Panel");
        PlutoGatewayPanel p = new PlutoGatewayPanel();
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }
    
}
