/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import static javax.swing.JTable.AUTO_RESIZE_ALL_COLUMNS;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations.Parameter;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.bigFont;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.nicePink;

/**
 * To display the parameters of an EPOS controller.
 * @author virieux
 */
public class EPOSParametersPanel extends JPanel {
    
    private JTable paramsTable;
    private JScrollPane jScrollPane;
    private final JLabel mLabel = new JLabel("Parameters defined for mode: ");
    private final JLabel modeLabel = new JLabel("Unknown Mode");
    /**
     * Creates new form EPOSControllerPanel
     */
    public EPOSParametersPanel() {
        initComponents();
    }
   
    
    public void initializeGUI(String mode, Map<String, Integer> paramsMap) {
        SwingUtilities.invokeLater(new EPOSParametersPanel.GuiInitialization(mode,paramsMap));
    }
    
    private  class GuiInitialization implements Runnable {
        
        String modeInString;
        Map<String, Integer> paramsMap;

        public GuiInitialization(String mode, Map<String, Integer> paramsMap) {
            this.modeInString = mode;
            this.paramsMap = paramsMap;
        }

        @Override
        public void run() { 
            modeLabel.setText(modeInString);            
            DefaultTableModel paramsTableModel = (DefaultTableModel)paramsTable.getModel();
            if (!(paramsMap == null)) {
                for (Map.Entry<String,Integer> entry : paramsMap.entrySet()) {
                    String paramName = entry.getKey();
                    int configValue = entry.getValue().intValue();
                    Parameter param = Parameter.valueOf(paramName);
                    Object[] tab = {paramName,param.getIndex(),param.getSubindex(),
                        param.getSize(),param.isSigned(),configValue};
                    paramsTableModel.addRow(tab);
                }  
            }
            paramsTableModel.fireTableDataChanged();
        }
    }
    
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form description">                          
    private void initComponents() {
        
         /**
         ******************************************************************************
         **  Parameters Table
         ******************************************************************************
         */
        
        paramsTable = new JTable();

        paramsTable.setModel(new DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Parameter Name", "Index", "Subindex", "Size", "Signed","Decimal Value"
            }
        ) {
            Class[] types = new Class [] {
                String.class, String.class, String.class, String.class, Boolean.class, Integer.class
            };
            boolean[] canEdit = new boolean [] {
                false, false, false, false, false, false
            };

            @Override
            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });

        TableColumn column = null;
        for (int i = 0; i < 6; i++) {
            column = paramsTable.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setPreferredWidth(250); //first column is bigger
            } else if (i == 5) {
                column.setPreferredWidth(120); //6th column is bigger
            }
        }
        //paramsTable.setPreferredScrollableViewportSize(new Dimension(1000,200));
        paramsTable.setAutoResizeMode(AUTO_RESIZE_ALL_COLUMNS);
        jScrollPane = new JScrollPane(paramsTable);
        jScrollPane.setMinimumSize(new java.awt.Dimension(400, 50));
        jScrollPane.setPreferredSize(new java.awt.Dimension(500, 100));
        paramsTable.setFillsViewportHeight(true);
        
         /**
         ******************************************************************************
         **  end ofParameters Table
         ******************************************************************************
         */
        
         /**
         ******************************************************************************
         **  Whole Panel
         ******************************************************************************
         */
        setBorder(BorderFactory.createLineBorder(nicePink));
        //setForeground(new java.awt.Color(204, 204, 255));
        setLayout(new java.awt.GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_std;
        gbc.anchor = GridBagConstraints.NORTHWEST;
        gbc.gridx = 0;
        gbc.gridy = 0;
        add(mLabel,gbc);
        gbc.gridx++;
        modeLabel.setFont(bigFont);
        add(modeLabel,gbc);
        gbc.gridx--;
        gbc.gridy++;
        gbc.gridwidth = 4;
        add(jScrollPane,gbc);
         /**
         ******************************************************************************
         **  end of Whole Panel
         ******************************************************************************
         * **/
    }
    
   public static void main(String[] argv) {

        EPOSParametersPanel p = new EPOSParametersPanel();
        Map<String, Integer> paramsMap = new HashMap<String, Integer>();
        paramsMap.put("ContinuousCurrentLimit",3440);
        paramsMap.put("OutputCurrentLimit",6880);
        paramsMap.put("MaxSpeedInCurrentMode",2000);
        p.initializeGUI("CURRENT",paramsMap);

        JFrame frame = new JFrame("EPOS Parameters");
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }
    
}
