/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations.EposMode;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.config.CANopenHardwareConfig;
import org.lsst.ccs.subsystems.fcs.config.EPOSControllerConfig;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.bigFont;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.greenColor;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;
import org.lsst.ccs.utilities.logging.Logger;

/**
 * A Panel to display data coming from an EPOS motor controller.
 * @author virieux
 */
public class EPOSControllerPanel extends JPanel {
    
    protected static final Logger fcslog = Logger.getLogger("org.lsst.ccs.subsystems.fcs");
    private GeneralGUISubsystem subs;
    private String controllerName;
    
    /** Variables declaration **/
    //general informations panel
    JPanel generalInfoPanel;
    private final JLabel nLabel = new JLabel("Name: ");
    private final JLabel snLabel = new JLabel("Serial number: ");
    private final JLabel nIDLabel = new JLabel("CANopen node: ");
    private final JLabel bLabel = new JLabel("booted: ");
    private final JLabel iLabel = new JLabel("initialized: ");
    private final JLabel nameLabel = new JLabel("Unknown");
    private final JLabel serialLabel = new JLabel("XXXXXXXXX");
    private final JLabel nodeIDLabel = new JLabel("999");

    private final JLabel bootedLabel = new JLabel("false");
    private final JLabel initLabel = new JLabel("false");
    //Fault Panel
    JPanel faultPanel;
    DigitalSwitch faultSwitch = new DigitalSwitch();
    JLabel errorRegisterLabel = new JLabel("99=XXXXXXXX error");
    JLabel errorHistoryNameLabel = new JLabel("Error History:");
    JLabel errorHistoryLabel = new JLabel();
    
    //mode panel
    JPanel modePanel;
    private final JLabel mLabel = new JLabel("EPOS mode: ");    
    private final JLabel modeLabel = new JLabel("UNKNOWN");
    
    //control Panel
    JPanel controlPanel;
    JButton checkFaultButton = new JButton("CheckFault");
    JButton faultResetButton = new JButton("FaultReset");
    JButton refreshButton = new JButton("Refresh");
    
    
    //panel for CURRENT mode parameters
    EPOSParametersPanel currentParamsPanel = new EPOSParametersPanel();
    //panel for PROFILE_POSITION mode parameters
    EPOSParametersPanel profile_positionParamsPanel = new EPOSParametersPanel();
    //panel for HOMING mode parameters
    EPOSParametersPanel homingParamsPanel = new EPOSParametersPanel();
    
    // End of variables declaration                   
    
    /**
     * Creates new form EPOSControllerPanel
     */
    public EPOSControllerPanel() {
        initComponents();
    }
    
    public void setSubsystem(GeneralGUISubsystem subs) {      
        this.subs = subs;
    }
   
    
    public void initializeGui(CANopenHardwareConfig canOpenHardwareConfig,
            EPOSControllerConfig eposConfig) {
        SwingUtilities.invokeLater(new GuiInitialization(canOpenHardwareConfig,eposConfig));
    }

    public void updateController(StatusDataPublishedByEPOSController status) {
        SwingUtilities.invokeLater(new UpdateController(status));
    }
    
    
    private  class GuiInitialization implements Runnable {
        
        CANopenHardwareConfig canOpenHardwareConfig;
        EPOSControllerConfig  ctlConfig;

        public GuiInitialization(CANopenHardwareConfig canOpenHardwareConfig,
                EPOSControllerConfig anEPOSConfig) {
            this.canOpenHardwareConfig = canOpenHardwareConfig;
            this.ctlConfig = anEPOSConfig;
        }

        @Override
        public void run() {           
             //General Informations Panel
            controllerName = canOpenHardwareConfig.getName();
            nameLabel.setText(canOpenHardwareConfig.getName());
            serialLabel.setText(canOpenHardwareConfig.getSerialNB());
            nodeIDLabel.setText(canOpenHardwareConfig.getNodeID());
            bootedLabel.setText(Boolean.toString(canOpenHardwareConfig.isBooted()));
            initLabel.setText(Boolean.toString(canOpenHardwareConfig.isInitialized()));
            
            //Fault Panel
            faultSwitch.setColor(Color.GRAY);
            errorRegisterLabel.setText("Unkown ERROR");

            //panel for CURRENT mode parameters
            currentParamsPanel.initializeGUI(EposMode.CURRENT.toString(),ctlConfig.getParamsForCurrent());
            //panel for PROFILE_POSITION mode parameters
            profile_positionParamsPanel.initializeGUI(EposMode.PROFILE_POSITION.toString(),ctlConfig.getParamsForProfilePosition());
            //panel for HOMING mode parameters
            homingParamsPanel.initializeGUI(EposMode.HOMING.toString(),ctlConfig.getParamsForHoming());
        }
    }
    
    class UpdateController implements Runnable {
        
        StatusDataPublishedByEPOSController s;

        public UpdateController(StatusDataPublishedByEPOSController status) {
            this.s = status;
        }

        @Override
        public void run() {
                //General Informations Panel
                bootedLabel.setText(Boolean.toString(s.isBooted()));
                initLabel.setText(Boolean.toString(s.isInitialized()));
                
                //Mode Panel
                modeLabel.setText(s.getMode());
                modeLabel.setFont(bigFont);
                //Fault Panel
                if (s.isInitialized()) {
                    faultSwitch.setColor(s.isInError()? Color.RED : greenColor);
                    errorRegisterLabel.setText(s.getErrorRegister());
                    //error History
                    String[] historyList = s.getErrorHistory();
                    if (historyList == null) errorHistoryLabel.setText("no error");
                    if (historyList.length > 0) {
                        StringBuilder sb = new StringBuilder("<html>");
                        for (int i=0; i<s.getErrorHistory().length; i++ ) {
                            if (i>0) sb.append("<br>");
                            sb.append(historyList[i]);

                        }
                        sb.append("</html>");
                        errorHistoryLabel.setText(sb.toString());
                    }
                } else {
                    errorRegisterLabel.setText("Not initialized");
                }
                
            }
    }
    
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form description">                          
    private void initComponents() {
        //Buttons
        checkFaultButton.addActionListener(new ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                checkFaultActionPerformed(evt);
            }
        });
        
        faultResetButton.addActionListener(new ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                faultResetActionPerformed(evt);
            }
        });
        
        refreshButton.addActionListener(new ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                refreshActionPerformed(evt);
            }
        });        
        
         /**
         ******************************************************************************
         **  General Informations Panel
         ******************************************************************************
         */
        generalInfoPanel = new JPanel();
        generalInfoPanel.setBorder(BorderFactory.createTitledBorder("General Informations"));
        generalInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.insets = insets_std;
        //first colomn
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        gbc3.anchor = GridBagConstraints.LINE_START;

        generalInfoPanel.add(nLabel,gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(snLabel,gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(nIDLabel,gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(bLabel,gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(iLabel,gbc3);
        //second colomn
        gbc3.gridx++;
        gbc3.gridy = 0;
        gbc3.anchor = GridBagConstraints.LINE_END;
        generalInfoPanel.add(nameLabel,gbc3);
        nameLabel.setFont(bigFont);
        gbc3.gridy++;
        generalInfoPanel.add(serialLabel,gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(nodeIDLabel,gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(bootedLabel,gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(initLabel,gbc3);
         /**
         ******************************************************************************
         **  End of General Informations Panel
         ******************************************************************************
         */

         /**
         ******************************************************************************
         **  Mode Panel
         ******************************************************************************
         */
        modePanel = new JPanel();
        modePanel.setBorder(BorderFactory.createTitledBorder("EPOS mode"));
        modePanel.setPreferredSize(new Dimension(160,50));
        modePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = insets_std;
        //first colomn
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        gbc2.anchor = GridBagConstraints.LINE_START;
        //modePanel.add(mLabel,gbc2);
        //second colomn
//        gbc2.gridx++;
//        gbc2.anchor = GridBagConstraints.LINE_END;
        modeLabel.setFont(bigFont);
        modePanel.add(modeLabel,gbc2);
         /**
         ******************************************************************************
         **  end of Mode Panel
         ******************************************************************************
         */
         /**
         ******************************************************************************
         **  Fault Panel
         ******************************************************************************
         */       
        faultPanel = new JPanel();
        faultPanel.setBorder(BorderFactory.createTitledBorder("Error"));
        faultPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.anchor = GridBagConstraints.CENTER;
        faultPanel.add(faultSwitch,gbc1);
        gbc1.gridy++;
        errorRegisterLabel.setFont(bigFont);
        faultPanel.add(errorRegisterLabel,gbc1);
        gbc1.gridy++;
        faultPanel.add(errorHistoryNameLabel,gbc1);
        gbc1.gridy++;
        faultPanel.add(errorHistoryLabel,gbc1);
         /**
         ******************************************************************************
         **  end of Fault Panel
         ******************************************************************************
         */
        /******************************************************************************
         **  Control Panel
         ******************************************************************************
         */
        controlPanel = new JPanel();
        controlPanel.setLayout(new java.awt.GridBagLayout());
        GridBagConstraints gbc4 = new java.awt.GridBagConstraints();
        gbc4.anchor = GridBagConstraints.FIRST_LINE_START;
        gbc4.fill = GridBagConstraints.HORIZONTAL;
        gbc4.insets = insets_std;
        gbc4.gridx = 0;
        gbc4.gridy = 0;
        controlPanel.add(refreshButton,gbc4);
        gbc4.gridy++;
        controlPanel.add(checkFaultButton,gbc4);
        gbc4.gridx++;
        controlPanel.add(faultResetButton,gbc4);
        
        
         /**
         ******************************************************************************
         **  End of Control Panel
         ******************************************************************************
         */
         /**
         ******************************************************************************
         **  Whole Panel
         ******************************************************************************
         */
        
        setBorder(javax.swing.BorderFactory.createLineBorder(Color.GREEN));
        //setForeground(new java.awt.Color(204, 204, 255));
        setLayout(new java.awt.GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_std;
        gbc.anchor = GridBagConstraints.NORTHWEST;

        gbc.gridx = 0;
        gbc.gridy = 0;
        add(generalInfoPanel,gbc);
        
        gbc.gridx++;
        add(faultPanel,gbc);
        
        gbc.gridx = 0;
        gbc.gridy++;
        add(modePanel,gbc);
        
        gbc.gridx++;
        add(controlPanel,gbc);
        
        gbc.gridx = 0;
        gbc.gridy++;
        gbc.gridwidth = 4;
        add(currentParamsPanel,gbc);
        gbc.gridy++;
        add(profile_positionParamsPanel,gbc);
        gbc.gridy++;
        add(homingParamsPanel,gbc);
        
         /**
         ******************************************************************************
         **  end of Whole Panel
         ******************************************************************************
         */
        
        
    }
    
    private void checkFaultActionPerformed(java.awt.event.ActionEvent evt) {
        subs.sendCommandSwingWorker("checkFault",1000,controllerName);
    }
    
    private void faultResetActionPerformed(java.awt.event.ActionEvent evt) {
        subs.sendCommandSwingWorker("faultReset",1000,controllerName);
    } 
    
    private void refreshActionPerformed(java.awt.event.ActionEvent evt) {
        subs.sendCommandSwingWorker("publishData",1000,controllerName);
    }    
    
    public static void main(String[] argv) {

        EPOSControllerPanel p = new EPOSControllerPanel();
        
        CANopenHardwareConfig hConfig = new CANopenHardwareConfig("hooksController", "1b", "79007141",false,false);
        Map<String, Integer> paramsMapCurrent = new HashMap<>();
        paramsMapCurrent.put("ContinuousCurrentLimit",3440);
        paramsMapCurrent.put("OutputCurrentLimit",6880);
        paramsMapCurrent.put("MaxSpeedInCurrentMode",2000);
        Map<String, Integer> paramsMapProfile_Position = new HashMap<>();        
        paramsMapProfile_Position.put("MinPositionLimit", -300);
        paramsMapProfile_Position.put("MaxPositionLimit", 550000);
        Map<String, Integer> paramsMapHoming = new HashMap<>();
        paramsMapHoming.put("HomeOffset", 0);
        EPOSControllerConfig config = new EPOSControllerConfig("hooksController");
        config.setParamsForCurrent(paramsMapCurrent);
        config.setParamsForProfilePosition(paramsMapProfile_Position);
        config.setParamsForHoming(paramsMapHoming);

        p.initializeGui(hConfig,config);

        JFrame frame = new JFrame("EPOS Controller");
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }
}
