/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.config.CANopenHardwareConfig;
import org.lsst.ccs.subsystems.fcs.config.CanOpenProxyConfig;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;
import org.lsst.ccs.utilities.logging.Logger;

/**
 *
 * @author virieux
 */
public class CanOpenHardwarePanel extends JPanel {
    
    // Variables declaration 
    protected static final Logger fcslog = Logger.getLogger("org.lsst.ccs.subsystems.fcs");

                     
    private JLabel bootedNodesNBLabel;
    private JLabel expectedNodesNBLabel;
    private JLabel hardwareBootTimeoutLabel;
    private JPanel hardwarePanel;
    private JTable hardwareTable;
    private JLabel bootedNodesNBNameLabel;
    private JLabel hardwareBootTimeoutNameLabel;
    private JLabel expectedNodesNBNameLabel;
    private JLabel portNumberNameLabel;    
    private JLabel portNumberLabel; 
    private JScrollPane jScrollPane;
    // End of variables declaration 
    
    
    /** Initialization of the GUI for data stored in tcpConfiguration. **/
    private  class GuiInitialization implements Runnable {
        
        CanOpenProxyConfig canOpenProxyConfig;

        public GuiInitialization(CanOpenProxyConfig aConfig) {
            this.canOpenProxyConfig = aConfig;
        }

        @Override
        public void run() {
            /** CANopen hardware list panel **/
    
            portNumberLabel.setText(Integer.toString(canOpenProxyConfig.getPortNumber()));
            expectedNodesNBLabel.setText(Integer.toString(canOpenProxyConfig.getExpectedNodesNB()));
            hardwareBootTimeoutLabel.setText(Long.toString(canOpenProxyConfig.getHardwareBootTimeout()));
            CANopenHardwareConfig clampHConfig = new CANopenHardwareConfig("Unknown","Unknown","Unknown",false,false);
            CANopenHardwareConfig carrierHConfig = new CANopenHardwareConfig("Unknown","Unknown","Unknown",false,false);
            //configure HardwareTable
            CANopenHardwareConfig[] list = canOpenProxyConfig.getHardwareConfigList();
            int rowNB = list.length;
            bootedNodesNBLabel.setText(Integer.toString(rowNB));
            DefaultTableModel hardwareTableModel = (DefaultTableModel)hardwareTable.getModel();
            for (int i=0; i<rowNB; i++) { 
                Object[] tab = {list[i].getName(),list[i].getNodeID(),list[i].getSerialNB(),
                    list[i].isBooted(),list[i].isInitialized()};
                hardwareTableModel.addRow(tab);
            }   
            hardwareTableModel.fireTableDataChanged();

        }
    }
    
    
    class UpdateCanOpenHardwarePanel implements Runnable {
        
        StatusDataPublishedByHardware s;

        public UpdateCanOpenHardwarePanel(StatusDataPublishedByHardware status) {
            this.s = status;
        }
        
        @Override
        public void run() {
            DefaultTableModel hardwareTableModel = (DefaultTableModel)hardwareTable.getModel();
            int rowNB = hardwareTableModel.getRowCount();
            for (int i=0; i<rowNB; i++) {                
                if ((hardwareTableModel.getValueAt(i, 0)).equals(s.getName())) {
                    hardwareTableModel.setValueAt(s.isBooted(), i, 3);
                    hardwareTableModel.setValueAt(s.isInitialized(), i, 4);
                }
            }   
            hardwareTableModel.fireTableDataChanged();
        }
    }
    
     /**
     * Creates new form CanOpenHardware
     */
    public CanOpenHardwarePanel() {
        initComponents();
    }
    
    
    public void initializeGui(CanOpenProxyConfig tcpProxyConfig) {
        SwingUtilities.invokeLater(new GuiInitialization(tcpProxyConfig));
    }
    
    public void updateCanOpenHardwarePanel(StatusDataPublishedByHardware status) {
        SwingUtilities.invokeLater(new UpdateCanOpenHardwarePanel(status));
    }
   
    

    
    
        @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form description">                          
    private void initComponents() {

        hardwarePanel = new JPanel();        
        bootedNodesNBNameLabel = new JLabel("Number of booted CANopen Nodes:");
        bootedNodesNBLabel = new JLabel("0");
        
        hardwareBootTimeoutNameLabel = new JLabel("Hardware boot timeout:");
        hardwareBootTimeoutLabel = new JLabel("0");
        
        expectedNodesNBNameLabel = new JLabel("Number of expected CANopen Nodes:");
        expectedNodesNBLabel = new JLabel("0");
        
        portNumberNameLabel = new JLabel("Port number:");
        portNumberLabel = new JLabel("0");

         /**
         ******************************************************************************
         **  CANopen Hardware Panel
         ******************************************************************************
         */
        
        jScrollPane = new JScrollPane();
        hardwareTable = new JTable();
        hardwareTable.setModel(new DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Name", "Node ID", "Serial NB", "Booted", "Initialized"
            }
        ) {
            Class[] types = new Class [] {
                String.class, String.class, Object.class, Boolean.class, Boolean.class
            };
            boolean[] canEdit = new boolean [] {
                false, false, false, false, false
            };

            @Override
            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        TableColumn column = null;
        for (int i = 0; i < 5; i++) {
            column = hardwareTable.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setPreferredWidth(150); //first column is bigger
            }
        }
        jScrollPane.setViewportView(hardwareTable);
        

        
        /** General info panel **/
        JPanel generalInfoPanel = new JPanel();
        generalInfoPanel.setBorder(BorderFactory.createTitledBorder("General Informations"));
        generalInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc4 = new GridBagConstraints();
        gbc4.insets = insets_std;
        //first colomn
        gbc4.gridx = 0;
        gbc4.gridy = 0;
        gbc4.anchor = GridBagConstraints.LINE_START;
        generalInfoPanel.add(portNumberNameLabel,gbc4);
        gbc4.gridy++;
        generalInfoPanel.add(hardwareBootTimeoutNameLabel,gbc4);
        gbc4.gridy++;
        generalInfoPanel.add(expectedNodesNBNameLabel,gbc4);
        gbc4.gridy++;
        generalInfoPanel.add(bootedNodesNBNameLabel,gbc4);
        //second colomn
        gbc4.gridx++;
        gbc4.gridy = 0;
        gbc4.anchor = GridBagConstraints.LINE_END;
        generalInfoPanel.add(portNumberLabel,gbc4);
        gbc4.gridy++;
        generalInfoPanel.add(hardwareBootTimeoutLabel,gbc4);
        gbc4.gridy++;
        generalInfoPanel.add(expectedNodesNBLabel,gbc4);
        gbc4.gridy++;
        generalInfoPanel.add(bootedNodesNBLabel,gbc4);
        /** end of General info panel **/
        
        hardwarePanel.setBorder(BorderFactory.createLineBorder(new Color(255, 0, 255)));
        hardwarePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.anchor = GridBagConstraints.NORTHWEST;
        gbc0.insets = insets_std;      
        gbc0.gridx = 0;
        gbc0.gridy = 0;       
        hardwarePanel.add(generalInfoPanel, gbc0);
        gbc0.gridx = 0;
        gbc0.gridy++;
        hardwarePanel.add(jScrollPane,gbc0);
         /**
         ******************************************************************************
         **  end of CANopen Hardware Panel
         ******************************************************************************
         */
        //Whole Panel
        GridBagConstraints gbc = new GridBagConstraints();
       
        gbc.anchor = java.awt.GridBagConstraints.BASELINE_LEADING;
        gbc.insets = insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;    
        add(hardwarePanel, gbc);

    }
    
    public static void main(String[] argv) {
        
        CanOpenHardwarePanel p = new CanOpenHardwarePanel();
        
        CANopenHardwareConfig config1 = new CANopenHardwareConfig("plutoGateway", "1", "22d6",false,false);
        CANopenHardwareConfig config2 = new CANopenHardwareConfig("hooksController", "1b", "79007141",false,false);
        CANopenHardwareConfig config3 = new CANopenHardwareConfig("carrierController", "1a", "80003184",false,false);
        CANopenHardwareConfig[] configList = {config1,config2,config3};
        CanOpenProxyConfig tcpConfig = new CanOpenProxyConfig("Toto",52000,3,2000,configList);

        
        p.initializeGui(tcpConfig);
        
        JFrame frame = new JFrame("CANopen Hardware");
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        
        StatusDataPublishedByHardware s1 = new StatusDataPublishedByHardware("plutoGateway",true,false);
        p.updateCanOpenHardwarePanel(s1);
        StatusDataPublishedByHardware s2 = new StatusDataPublishedByHardware("hooksController",true,true);
        p.updateCanOpenHardwarePanel(s2);
        StatusDataPublishedByHardware s3 = new StatusDataPublishedByHardware("carrierController",false,true);
        p.updateCanOpenHardwarePanel(s3);

    }
    
}
