package org.lsst.ccs.subsystems.fcs.singlefiltertest.ui;

import javax.swing.JScrollPane;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.SingleFilterTestConfig;

import javax.swing.*;
import java.io.PrintWriter;
import org.lsst.ccs.bus.DataStatusListener;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByBasicAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClampActuator;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;

/**
 *
 * @author max
 */
public class SingleFilterTestGUISubsystem extends Subsystem implements DataStatusListener {

    private static final String destination = "single-filter-test";
    //private static final Logger log = Logger.getLogger("org.lsst.ccs.subsystems.fcs");
    private PrintWriter out = new PrintWriter(System.out, true);
//    private SingleFilterTestAssembly assembly;
    private final FilterExchangeMainPanel assembly;
//    private CarouselTablePanel carouselTable;
    private long lastHeartBeat = 0, lastStateRequest = 0;
    private boolean initialized = false;
    String stateCorrelId;
    JScrollPane pane;

    public SingleFilterTestGUISubsystem() {
        assembly = new FilterExchangeMainPanel(this);
        pane = new JScrollPane(assembly);
    }

    public void initGui() {
        setName("SingleFilterTestGUIModule");        
        setListenToStatus(true);
        setStatusBroadcastPeriod(0);
        start();
    }

    public JComponent getGuiLayout() {
        return pane;
    }

    public void resetGui() {
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        SingleFilterTestGUISubsystem t = new SingleFilterTestGUISubsystem();

        JFrame frame = new JFrame("Single Filter Test Subsystem");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }

    public void setPrintWriter(PrintWriter out) {
        this.out = out;
    }

    @Override
    public void onReply(CommandReply s) {
        //FIXME temporary fix to prevent multiple GUIs from interfering with each other.
        //See https://jira.slac.stanford.edu/browse/LSSTCCS-9
        if (s.getCorrelId().equals(stateCorrelId)) {
            
            SingleFilterTestConfig config = (SingleFilterTestConfig) s.getReply();
            assembly.initializeGui(config);
            initialized = true;
        }
    }



    @Override
    public void onDataArrival(String source, long timestamp, String dataType, Object s) {
         //If this data status is not for us we forget it.
        if (!source.equals(destination)) return;
        if (initialized) {
            switch (dataType){
                            case "carouselClamp":
                                log.debug(getName() + " read data dataType:carouselClamp");
                                assembly.updateClamp((StatusDataPublishedByClamp) s);
                                lastHeartBeat = timestamp;
                                break;
                                
                            case "actuator":
                                log.debug(getName() + " read data dataType:actuator");
                                assembly.updateActuator((StatusDataPublishedByClampActuator) s);
                                lastHeartBeat = timestamp;
                                break;
                                
                            case "carousel":
                                log.debug(getName() + " read data dataType:carousel");
                                assembly.updateCarousel((StatusDataPublishedByCarousel) s);
                                lastHeartBeat = timestamp;
                                break;
                                
                            case "autochangerLatch":
                                log.debug(getName() + " read data dataType:autochangerLatch");
                                assembly.updateLatch((StatusDataPublishedByAutochangerLatch) s);
                                lastHeartBeat = timestamp;
                                break;
                                
                            case "autochanger":
                                log.debug(getName() + " read data dataType:autochanger");
                                assembly.updateAutoChanger ((StatusDataPublishedByBasicAutoChanger) s);
                                lastHeartBeat = timestamp;
                                break;                                
                                                             
                            default:
                                log.warning(getName() + " An unexpected dataType was read on the status bus:" + dataType);
                                break;
                            
                        }
        } else {
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastStateRequest > 2000) {
                lastStateRequest = currentTime;
                ModuleInvokerCommand cmd = new ModuleInvokerCommand("getFullState");
                sendCommand(cmd);
                stateCorrelId = cmd.getCorrelId();
            }
        }
    }

    private void sendCommand(ModuleInvokerCommand cmd) {
        cmd.setDestination(destination);
        updateCurrentSubsystem();
        fac.sendCommand(cmd);
    }

    
}
