package org.lsst.ccs.subsystems.fcs.loader.ui;

import javax.swing.JFrame;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUISubsystem;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderConfig;
import javax.swing.JScrollPane;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.ModuleInvokerCommand;

import org.lsst.ccs.bus.Agent;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;

/**
 *
 * @author F
 */
public class LoaderGUISubsystem extends GeneralGUISubsystem {
    
    private static final String clampModuleName = "clamp";
    private static final String carrierModuleName = "carrier";
    private long lastHeartBeat = 0, lastStateRequest = 0;
    String stateCorrelId;
    
    //actions timeout
    long updateCarrierPositionTimeout;
    long openHooksTimeout;
    long closeHooksTimeout;
    long clampHooksTimeout;
    long homingHooksTimeout;
    long goToHandoffTimeout;
    long goToStorageTimeout;
    long quickStopTimeout;


    


    public LoaderGUISubsystem(String name, 
            Agent.AgentType type, 
            String destination) {
        super(name, type, destination);
        this.topPanel = new LoaderTopPanel(this);
        pane = new JScrollPane(topPanel);
        openHooksTimeout = 0;
        closeHooksTimeout = 0;
        clampHooksTimeout = 0;
        homingHooksTimeout = 0;
        goToHandoffTimeout = 0;
        goToStorageTimeout = 0;
        abortTimeout = 1000;
        quickStopTimeout = 1000;
        updateStateWithSensorsTimeout = 1000;
        updateCarrierPositionTimeout = 1000;
    }
    
    
    
    
    
    
    
    
    @Override
    public void onReply(CommandReply s) {
        //FIXME temporary fix to prevent multiple GUIs from interfering with each other.
        //See https://jira.slac.stanford.edu/browse/LSSTCCS-9
        if (s.getCorrelId().equals(stateCorrelId)) {
            //This is the first Status Message after the GUI has started
            LoaderConfig config = (LoaderConfig) s.getReply();

            log.debug("--- Got a reply from subs");
            ((LoaderTopPanel)topPanel).initializeGui(config);
            initialized = true;
        }
    }

    @Override
    public void onDataArrival(String source, long timestamp, String dataType, Object s) {
        //If this data status is not for us we forget it.
        if (!source.equals(destination)) {
            return;
        }
        if (initialized) {
            switch (dataType) {
                case "loaderGeneral":
                    log.debug(getName() + " read data dataType:loaderGeneral");
                    ((LoaderTopPanel)topPanel).updateLoaderGeneral((StatusDataPublishedByLoader) s);
                    lastHeartBeat = timestamp;
                    break;
                    
                case "loaderClamp":
                    log.debug(getName() + " read data dataType:loaderClamp");
                    ((LoaderTopPanel)topPanel).updateClamp((StatusDataPublishedByLoaderClamp) s);
                    lastHeartBeat = timestamp;
                    break;
                    
                case "loaderCarrier":
                    log.debug(getName() + " read data dataType:loaderCarrier");
                    ((LoaderTopPanel)topPanel).updateCarrier((StatusDataPublishedByLoaderCarrier) s);
                    lastHeartBeat = timestamp;
                    break;
                    
                case "tcpProxy":
                    log.debug(getName() + " read data dataType:tcpProxy");
                    ((LoaderTopPanel)topPanel).updateCanOpenHardwarePanel((StatusDataPublishedByHardware) s);
                    lastHeartBeat = timestamp;
                    break;                               

                case "carrierController":
                    log.debug(getName() + " read data dataType:loaderCarrierController");
                    ((LoaderTopPanel)topPanel).updateCarrierController((StatusDataPublishedByEPOSController) s);
                    lastHeartBeat = timestamp;
                    break;

               case "hooksController":
                    log.debug(getName() + " read data dataType:loaderClampController");
                    ((LoaderTopPanel)topPanel).updateClampController((StatusDataPublishedByEPOSController) s);
                    lastHeartBeat = timestamp;
                    break;
                default:
                    log.warning(getName() + " An unexpected dataType was read on the status bus:" + dataType);
                    break;
            }
        } else {
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastStateRequest > 2000) {
                lastStateRequest = currentTime;
                ModuleInvokerCommand cmd = new ModuleInvokerCommand("getFullState");
                sendAsynchronousCommand(cmd);
                stateCorrelId = cmd.getCorrelId();
            }
        }
    }
    
    protected void loadFilter() {
        System.out.println(destination + "loadFilterInCamera with timeout=" + goToHandoffTimeout);
        log.info("Loading filter in camera");log.info("/timeout=" + goToHandoffTimeout);
        new CommandSwingWorker("loadFilterInCamera",this.goToHandoffTimeout).execute();
    }
    
    protected void unloadFilter() {
        System.out.println(destination + "unloadFilterFromCamera with timeout=" + goToStorageTimeout);
        log.info("Loading filter in camera");log.info("/timeout=" + goToStorageTimeout);
        new CommandSwingWorker("unloadFilterFromCamera",this.goToStorageTimeout).execute();
    }
    
    protected void updateCarrierPosition() {
        System.out.println(destination + "updateCarrierPosition with updateCarrierPositionTimeout=" + updateCarrierPositionTimeout);
        log.info("Updating carrier position"); log.info("/timeout=" + updateCarrierPositionTimeout);
        new CommandSwingWorker("updatePosition",updateCarrierPositionTimeout,carrierModuleName).execute();
    }
        
    protected void openHooks() {
        log.info("Opening Hooks"); log.info("/timeout=" + openHooksTimeout);
        new CommandSwingWorker("openHooks",openHooksTimeout).execute();
    }
    
    protected void closeHooks() {
        log.info("Closing Hooks");System.out.println("/timeout=" + closeHooksTimeout); 
        new CommandSwingWorker("closeHooks",this.closeHooksTimeout).execute();
    }

    protected void clampHooks() {
        log.info("Clamping Hooks");log.info("/timeout=" + clampHooksTimeout);
        new CommandSwingWorker("clampHooks",this.clampHooksTimeout).execute();
    }
    

    protected void goToHomePosition() {
        log.info("Clamp going to Home Position");log.info("/timeout=" + homingHooksTimeout);
        new CommandSwingWorker("goToHomePosition",this.homingHooksTimeout, clampModuleName).execute();
    }
    
    protected void goToClosePosition() {
        log.info("Going to Close Position");log.info("/timeout=" + clampHooksTimeout);
        new CommandSwingWorker("goToClampedPosition",this.clampHooksTimeout,clampModuleName).execute();
    }
    
    protected void goToHandOff() {
        log.info("Carrier going to Handoff Position");log.info("/timeout=" + goToHandoffTimeout);
        new CommandSwingWorker("goToHandOff",this.goToHandoffTimeout, carrierModuleName).execute();        
    }

    protected void goToStorage() {
        System.out.println(destination + "goToStorage with goToStorageTimeout=" + goToStorageTimeout);
        log.info("Carrier going to Storage Position");log.info("/timeout=" + goToStorageTimeout);
        new CommandSwingWorker("goToStorage",this.goToStorageTimeout, carrierModuleName).execute();
    }
    
     /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        
        LoaderGUISubsystem t = new LoaderGUISubsystem("LoaderGUIModule",
                    Agent.AgentType.CONSOLE,
                    "testbenchLPSC");
            
        JFrame frame = new JFrame("Loader View GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }
    




}
