/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.lsst.ccs.state.PublishedState;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.carousel.config.CarouselConfig;
import org.lsst.ccs.subsystems.fcs.config.CanOpenProxyConfig;
import org.lsst.ccs.subsystems.fcs.config.EPOSControllerConfig;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenHardwarePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUISubsystem;
import org.lsst.ccs.subsystems.fcs.ui.commons.SubsystemPanel;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.retrieveControllerInfo;
import org.lsst.ccs.subsystems.fcs.ui.commons.TopPanel;

/**
 *
 * @author virieux
 */
public class CarouselTopPanel extends TopPanel {
    
    private GeneralGUISubsystem subs;
    private JTabbedPane jTabbedPane;
    CarouselMainPanel carouselMainPanel;
    private CanOpenHardwarePanel hardwarePanel;
    private EPOSControllerPanel carouselControllerPanel;


    
    /** Initialization of the GUI for data stored in tcpConfiguration. **/
    private  class GuiInitialization implements Runnable {
        
        CarouselConfig carouselConfig;
        CanOpenProxyConfig canOpenProxyConfig;
        EPOSControllerConfig controllerConfig;


        public GuiInitialization(CarouselConfig carouselConfig) {
            this.carouselConfig = carouselConfig;
            this.canOpenProxyConfig = carouselConfig.getTcpProxyConfig();
            this.controllerConfig = carouselConfig.getControllerConfig();
        }

        @Override
        public void run() {
            
            /** Carousel Main Panel **/
            carouselMainPanel.initializeGui(carouselConfig);
            
            /** CANopen hardware list panel **/
            hardwarePanel.initializeGui(canOpenProxyConfig);
            
            /** Controller Panel **/
            carouselControllerPanel.initializeGui(retrieveControllerInfo(canOpenProxyConfig,controllerConfig), controllerConfig);
                    
        }
    }
    
    public CarouselTopPanel() {
        initComponents();
    }

    public CarouselTopPanel(GeneralGUISubsystem subs) {
        this.subs = subs;
        initComponents();
        this.carouselControllerPanel.setSubsystem(subs);
    }
    
    @Override
    public SubsystemPanel getSubsystemPanel() {
        return carouselMainPanel.getSubsystemPanel();
    }
    
    public void initializeGui(CarouselConfig carouselConfig) {
        SwingUtilities.invokeLater(new GuiInitialization(carouselConfig));
    }
   
    
    void updateCanOpenHardwarePanel(StatusDataPublishedByHardware s) {
        hardwarePanel.updateCanOpenHardwarePanel(s);
    }

    void updateCarouselController(StatusDataPublishedByEPOSController s) {
        carouselControllerPanel.updateController(s);    
    }

    
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form description">                          
    private void initComponents() {
        //carousel main panel
        carouselMainPanel = new CarouselMainPanel();
        //because the CarouselMainPanel is too big we need a scrollBar.
        JScrollPane mainViewScrollPane = new JScrollPane(carouselMainPanel);
        mainViewScrollPane.createVerticalScrollBar();
        mainViewScrollPane.setPreferredSize(new Dimension(1200,600));
        //CANopen devices panel
        hardwarePanel = new CanOpenHardwarePanel();       
        //controllers Panels
        carouselControllerPanel = new EPOSControllerPanel();     

        //TabbedPane
        jTabbedPane = new JTabbedPane();  
        jTabbedPane.setBorder(BorderFactory.createLineBorder(new java.awt.Color(0, 150, 180)));
        jTabbedPane.addTab("Carousel Main View", mainViewScrollPane);
        jTabbedPane.addTab("Carousel CANopen Devices", hardwarePanel);
        jTabbedPane.addTab("Carousel Controller", carouselControllerPanel);


        
        //Whole Panel
        setLayout(new GridBagLayout());
        setForeground(new Color(204, 204, 255));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = java.awt.GridBagConstraints.BASELINE_LEADING;
        gbc.gridx = 0;
        gbc.gridy = 0;    
        add(jTabbedPane, gbc);
    }
    
    public static void main(String[] argv) {
        
        CarouselTopPanel d = new CarouselTopPanel();
        JFrame frame = new JFrame("Carousel Top Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }
    
}
