/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.carousel.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.bus.Agent;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.carousel.config.CarouselConfig;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUISubsystem;

/**
 *
 * @author virieux
 */
public class CarouselGUI extends GeneralGUISubsystem{
    private long lastHeartBeat = 0, lastStateRequest = 0;
    String stateCorrelId;

    public CarouselGUI(String name, Agent.AgentType type, String destination) {
        super(name, type, destination);
        this.topPanel = new CarouselTopPanel(this);
        pane = new JScrollPane(topPanel);
    }
    
    @Override
    public void onReply(CommandReply s) {
        //FIXME temporary fix to prevent multiple GUIs from interfering with each other.
        //See https://jira.slac.stanford.edu/browse/LSSTCCS-9
        if (s.getCorrelId().equals(stateCorrelId)) {
            //This is the first Status Message after the GUI has started
            CarouselConfig config = (CarouselConfig) s.getReply();

            log.debug(getName() + "--- Got a reply from subs");
            ((CarouselTopPanel)topPanel).initializeGui(config);
            initialized = true;
        }
    }

    @Override
    public void onDataArrival(String source, long timestamp, String dataType, Object s) {
        //If this data status is not for us we forget it.
        if (!source.equals(destination)) {
            return;
        }
        if (initialized) {
            switch (dataType) {
                    
                case "tcpProxy":
                    log.debug(getName() + " read data dataType:tcpProxy");
                    ((CarouselTopPanel)topPanel).updateCanOpenHardwarePanel((StatusDataPublishedByHardware) s);
                    lastHeartBeat = timestamp;
                    break;                               

                case "carouselController":
                    log.debug(getName() + " read data dataType:linearRailMasterController");
                    ((CarouselTopPanel)topPanel).updateCarouselController((StatusDataPublishedByEPOSController) s);
                    lastHeartBeat = timestamp;
                    break;
                   
                default:
                    log.warning(getName() + " An unexpected dataType was read on the status bus:" + dataType);
                    break;
            }
        } else {
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastStateRequest > 2000) {
                lastStateRequest = currentTime;
                ModuleInvokerCommand cmd = new ModuleInvokerCommand("getFullState");
                sendAsynchronousCommand(cmd);
                stateCorrelId = cmd.getCorrelId();
            }
        }    
    }
    
     /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        CarouselGUI t = new CarouselGUI("CarouselGUI",
                Agent.AgentType.CONSOLE,
                "carousel");

        JFrame frame = new JFrame("Carousel View GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }    
    
}
