/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterPresenceStatus;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.ui.commons.FilterPanel;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.bigFont;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_big;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;
import org.lsst.ccs.utilities.logging.Logger;

/**
 *
 * @author virieux
 */
public class AutochangerTwoLatchesPanel extends JPanel {
    
    static final Logger fcslog = Logger.getLogger("org.lsst.ccs.subsystems.fcs");
    
    private AutochangerGUI subs;
   

    private final JLabel latchesState = new JLabel("UNKNOWN STATE");
    private final JLabel latchesStateLabel = new JLabel("LATCHES STATE :");
    private final JLabel xMinusLabel = new JLabel("X-");
    private final JLabel xMinuxLabel2 = new JLabel("X-");
    private final JLabel xPlusLabel = new JLabel("X+");
    private final JLabel xPlusLabel2 = new JLabel("X+");
    private AutochangerLatchPanel latchXminusPanel;
    private AutochangerLatchPanel latchXplusPanel;
 
    private final FilterPanel filterPanel = new FilterPanel();
    //private VerticalProgressBarPanel currentProgressBarPanel;
    private JButton closeLatchesButton;
    private JButton openLatchesButton;
    private JButton updateStateWithSensorsButton;
    private JButton abortButton;
    // End of variables declaration 

    public AutochangerTwoLatchesPanel() {
        initComponents();
    }

    public void setSubs(AutochangerGUI subs) {
        this.subs = subs;
    }
    
    
    public void updateLatch(StatusDataPublishedByAutochangerLatch s) {
        fcslog.finest(getName() + " Data published by Latch= " + s.toString());
        String latchName = s.getName();
        
        if (latchName.contains("Xminus")) {
            latchXminusPanel.updateLatch(s);
        } else if (latchName.contains("Xplus")) {
            latchXplusPanel.updateLatch(s);
        } else {
            fcslog.error(getName() + " received autochanger Latch status with an unknown name. "
                    + "Can't update the GUI.");
            assert false : "Latch name should contains Xminus or Xplus.";
        }
    }
    
    public void updateLatches(StatusDataPublishedByAutochangerTwoLatches s) {
        SwingUtilities.invokeLater(new UpdateLatches(s));
    }
    
     class UpdateLatches implements Runnable {
        
        StatusDataPublishedByAutochangerTwoLatches s;

        public UpdateLatches(StatusDataPublishedByAutochangerTwoLatches status) {
            this.s = status;
        }

        @Override
        public void run() {
            latchesState.setText(s.getLockStatus().toString());
            filterPanel.setIsFilterInHouse(s.getFilterPresenceStatus().equals(FilterPresenceStatus.ENGAGED));
            if (s.getFilterPresenceStatus().equals(FilterPresenceStatus.UNKNOWN)) {
                filterPanel.setColor(Color.YELLOW);
            }
        } 
     }
    
    
     /** This method is called from within the constructor to
     * initialize the form.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form Description">                          
    private void initComponents() {

        //X- and X+ label
        Font xFont = new Font("Tahoma", 1, 18);
        xMinusLabel.setFont(xFont); // NOI18N      
        xMinuxLabel2.setFont(xFont); // NOI18N
        xPlusLabel2.setFont(xFont); // NOI18N       
        xPlusLabel.setFont(xFont); // NOI18N
        JPanel latchesPanel = new JPanel();
        JPanel latchesStatePanel = new JPanel();
        JPanel controlPanel = new JPanel();
        latchXminusPanel = new AutochangerLatchPanel();
        latchXplusPanel = new AutochangerLatchPanel();
        
//        currentProgressBarPanel = new VerticalProgressBarPanel("Current",-1200,1200,0);
//        currentProgressBarPanel.setStringPainted(false);

        
        filterPanel.setColor(Color.gray);
        
        updateStateWithSensorsButton = new JButton("Read sensors and update state");
        openLatchesButton = new JButton("Open");
        closeLatchesButton = new JButton("Close");
        abortButton = new JButton("Abort");
        
         /**
         ******************************************************************************
         **  Latches State Panel
         ******************************************************************************
         */
        latchesState.setFont(bigFont); // NOI18N
        latchesState.setBorder(javax.swing.BorderFactory.createEtchedBorder(new java.awt.Color(255, 255, 255), new java.awt.Color(255, 255, 255)));
        latchesStatePanel.setLayout(new java.awt.GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = insets_std;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        latchesStatePanel.add(latchesStateLabel, gbc2);
        gbc2.gridx++;
        latchesStatePanel.add(latchesState, gbc2);       
        /**
         ******************************************************************************
         **  end of Latches State Panel
         ******************************************************************************
         */
        
         /**
         ******************************************************************************
         **  Latches Panel
         ******************************************************************************
         */
        latchesPanel.setLayout(new java.awt.GridBagLayout());
        latchesPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.YELLOW), "Latches State"));
        GridBagConstraints gbc1 = new java.awt.GridBagConstraints();
        gbc1.insets = insets_std;
        
        latchXminusPanel.setLatchName("Latch 1");
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        latchesPanel.add(latchXminusPanel, gbc1);
        
        latchXplusPanel.setLatchName("Latch 2");
        gbc1.gridx++;
        latchesPanel.add(latchXplusPanel, gbc1);

        /**
         ******************************************************************************
         **  End of Hooks Panel
         ******************************************************************************
         */
        
         /**
         ******************************************************************************
         **  Control Panel
         ******************************************************************************
         */
        controlPanel.setLayout(new java.awt.GridBagLayout());
        GridBagConstraints gbc3 = new java.awt.GridBagConstraints();
        gbc3.anchor = GridBagConstraints.FIRST_LINE_START;
        gbc3.fill = GridBagConstraints.HORIZONTAL;
        gbc3.insets = insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        controlPanel.add(updateStateWithSensorsButton,gbc3);
        gbc3.gridy++;
        controlPanel.add(openLatchesButton,gbc3);
        gbc3.gridy++;
        controlPanel.add(closeLatchesButton,gbc3);
        gbc3.gridy++;
        controlPanel.add(abortButton,gbc3);
         /**
         ******************************************************************************
         **  End of Control Panel
         ******************************************************************************
         */
        
         /**
         ******************************************************************************
         **  Whole Panel
         ******************************************************************************
         */
        setBorder(javax.swing.BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.PINK),"AUTOCHANGER LATCHES"));
        //setBorder(javax.swing.BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.PINK),"LOADER CLAMP"));
        //setForeground(new java.awt.Color(204, 204, 255));
        setLayout(new java.awt.GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_std;
        gbc.anchor = GridBagConstraints.WEST;

        gbc.gridx = 0;
        gbc.gridy = 0;
        add(xMinusLabel, gbc);
        gbc.anchor = GridBagConstraints.EAST;
        gbc.gridx = 3;
        add(xPlusLabel, gbc);
        
        gbc.gridx = 0;       
        gbc.gridwidth = 4;
        gbc.anchor = GridBagConstraints.CENTER;
        add(latchesStatePanel, gbc);
        gbc.gridy++;
        add(latchesPanel, gbc);
        
        gbc.insets = insets_big;
        gbc.insets = new Insets(14,30,6,30);
        gbc.gridx = 0;
        gbc.gridy++;
//        gbc.gridwidth = 1;
//        add(currentProgressBarPanel, gbc);
//        gbc.gridx++;
        add(filterPanel,gbc);
        gbc.gridx++;
        gbc.anchor = GridBagConstraints.EAST;
        add(controlPanel,gbc);
        
    }    
    
    public static void main(String[] argv) {
        
        AutochangerTwoLatchesPanel d = new AutochangerTwoLatchesPanel();
        JFrame frame = new JFrame("Autochanger Latches Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }
    
}
