/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.autochanger.config.AutochangerTrucksConfig;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerMainPanel.fcslog;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.bigFont;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.greenColor;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 *
 * @author virieux
 */
public class AutochangerTrucksPanel extends JPanel {
    
    private AutochangerGUI subs;
    
    private final DigitalSwitch limitSwitchUpDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch standbyDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch inTravelDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch handoffDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch onlineDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch limitSwitchDownDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch inErrorDigitalSwitch = new DigitalSwitch();
    private final JLabel cajLabel = new JLabel("Trucks position");
    private final JLabel limitSUjLabel = new JLabel("Limit Switch Up");
    private final JLabel standbyjLabel = new JLabel("Standby");
    private final JLabel inTraveljLabel = new JLabel("In Travel");
    private final JLabel handoffjLabel = new JLabel("Hand-Off");
    private final JLabel onlinejLabel = new JLabel("On Line");
    private final JLabel limitSDjLabel = new JLabel("Limit Switch Down");
    private final JLabel inErrorjLabel = new JLabel("In Error");
    private final JLabel handoffSensorsErrorjLabel = new JLabel();
    private final JLabel standbySensorsErrorjLabel = new JLabel();
    //parameters Panel
    private final JLabel acjLabel = new JLabel("Actual Position (in mm): ");
    private final JLabel spjLabel = new JLabel("Speed (in rpm/s): ");
    private final JLabel cujLabel = new JLabel("Current (in mA): ");
    private final JLabel actualPositionjLabel = new JLabel("0");
    private final JLabel speedjLabel = new JLabel("0");
    private final JLabel currentjLabel = new JLabel("0");
    private final JProgressBar positionProgressBar = new JProgressBar(1,0,500);
    //general informations panel
    private final JLabel stjLabel = new JLabel("Standby Position (in mm): ");
    private final JLabel onjLabel = new JLabel("Online Position (in mm): ");
    private final JLabel hojLabel = new JLabel("Hand-Off Position (in mm): ");
    private final JLabel smjLabel = new JLabel("Speed max (in rpm/mn): ");
    private final JLabel cmjLabel = new JLabel("Current max (in mA): ");
    private final JLabel standbyPositionjLabel = new JLabel(Integer.toString(0));
    private final JLabel handoffPositionjLabel = new JLabel(Double.toString(0));
    private final JLabel onlinePositionjLabel = new JLabel(Double.toString(0));
    private final JLabel speedMaxjLabel = new JLabel(Integer.toString(0));
    private final JLabel currentMaxjLabel = new JLabel(Integer.toString(0));
    
    //control panel
    private final JButton updateStateWithSensorsButton = new JButton("updateStateWithSensors");
    private final JButton updatePositionButton = new JButton("updatePosition");
    private final JButton goToStandbyButton = new JButton("goToStandby");
    private final JButton goToHandoffButton = new JButton("goToHandOff");
    private final JButton goToOnlineButton = new JButton("goToOnline");
    private final JButton quickStopButton = new JButton("QuickStop");
    private final JButton abortButton = new JButton("Abort");
    //private final JButton shutdownButton = new JButton("Shutdown FCS");
    
    //Master Controller Fault Panel
    JPanel faultMasterCtlPanel;
    DigitalSwitch faultMasterCtlSwitch = new DigitalSwitch();
    //Slave Controller Fault Panel
    JPanel faultSlaveCtlPanel;
    DigitalSwitch faultSlaveCtlSwitch = new DigitalSwitch();    

    // End of variables declaration 
    
     /**
     * Creates new form AutochangerTrucksPanel
     */
    public AutochangerTrucksPanel() {
        initComponents();
    }

    public void setSubsystem(AutochangerGUI subs) {
        this.subs = subs;
    }
    

    
    public void initializeGui(AutochangerTrucksConfig config) {
        SwingUtilities.invokeLater(new AutochangerTrucksPanel.GuiInitialization(config));
    }

    public void updateTrucks(StatusDataPublishedByAutoChangerTrucks status) {
        SwingUtilities.invokeLater(new UpdateTrucks(status));
    }
    
    
    private  class GuiInitialization implements Runnable {
        
        AutochangerTrucksConfig autochangerTrucksConfig;

        public GuiInitialization(AutochangerTrucksConfig aConfig) {
            this.autochangerTrucksConfig = aConfig;
        }

        @Override
        public void run() {           
             //General Informations Panel
            double standbyPositionInMm = autochangerTrucksConfig.getStandbyPosition() / 1000;
            double handoffPositionInMm = autochangerTrucksConfig.getHandoffPosition() / 1000;
            double onlinePositionInMm = autochangerTrucksConfig.getOnlinePosition() / 1000;
            standbyPositionjLabel.setText(Double.toString(standbyPositionInMm));
            handoffPositionjLabel.setText(Double.toString(handoffPositionInMm));
            onlinePositionjLabel.setText(Double.toString(onlinePositionInMm));
            speedMaxjLabel.setText(Integer.toString(autochangerTrucksConfig.getMaxSpeed()));
            currentMaxjLabel.setText(Integer.toString(autochangerTrucksConfig.getMaxCurrent()));
            
            //position progress bar
            positionProgressBar.setMinimum(autochangerTrucksConfig.getStandbyPosition());
            positionProgressBar.setMaximum(autochangerTrucksConfig.getOnlinePosition());
            positionProgressBar.setValue(0);
            
            //Fault Panel
            faultMasterCtlSwitch.setColor(Color.GRAY);
            
            
        }
    }  
    
    
    class UpdateTrucks implements Runnable {
        
        StatusDataPublishedByAutoChangerTrucks s;

        public UpdateTrucks(StatusDataPublishedByAutoChangerTrucks status) {
            this.s = status;
        }

        @Override
        public void run() {
//            //TODO put the values of the limit switch sensors.
//            limitSwitchUpDigitalSwitch.setColor(s.isLimitSwitchUpInError() ? Color.RED : Color.gray);
//            limitSwitchDownDigitalSwitch.setColor(s.isLimitSwitchDownInError() ? Color.RED : Color.gray);
            fcslog.debug("update of Trucks Panel with s=" + s.toString());
            
            handoffDigitalSwitch.setColor((s.getHandoffSensorValue0() == 1
                    && s.getHandoffSensorValue1() == 1) ? greenColor : Color.gray);
            
            onlineDigitalSwitch.setColor((s.getOnlineSensorValue0() == 1
                    && s.getOnlineSensorValue1() == 1) ? greenColor : Color.gray);
            
            standbyDigitalSwitch.setColor((s.getStandbySensorValue0() == 1 
                    && s.getStandbySensorValue1() == 1) ? greenColor : Color.gray);
            
            inTravelDigitalSwitch.setColor(
                    (s.getHandoffSensorValue0() == 0 
                    && s.getHandoffSensorValue1() == 0
                    && s.getOnlineSensorValue0() == 0
                    && s.getOnlineSensorValue1() == 0
                    && s.getStandbySensorValue0() == 0                    
                    && s.getStandbySensorValue1() == 0                  
                    ) ? Color.YELLOW : Color.gray);
            //TODO the ERROR Digital Switch is red as soon as there is an error 
            //on the carrier position sensors.
            inErrorDigitalSwitch.setColor((s.isHandoffInError() 
                    ||s.isStandbyInError())? Color.RED  : greenColor);
            inErrorjLabel.setText((s.isHandoffInError() 
                    || s.isStandbyInError()) ? "IN ERROR"  : "NO ERROR");
            handoffSensorsErrorjLabel.setText(s.isHandoffInError() ? "<HTML>Handoff sensors<BR>in error</HTML>" : null);
            standbySensorsErrorjLabel.setText(s.isStandbyInError() ? "<HTML>Standby sensors<BR>in error</HTML>" : null);
            
            positionProgressBar.setValue(s.getPosition());
            positionProgressBar.setForeground(Color.PINK);
            
            double actualPositionInMm = s.getPosition() / 1000;
            actualPositionjLabel.setText(Double.toString(actualPositionInMm));
            speedjLabel.setText(Integer.toString(s.getSpeed()));
            currentjLabel.setText(Integer.toString(s.getCurrent()));
            
            //controller errors - fault panel
            faultMasterCtlSwitch.setColor(s.isMasterControllerInFault()? Color.RED : greenColor);
            faultSlaveCtlSwitch.setColor(s.isSlaveControllerInFault()? Color.RED : greenColor);
            
            
        }
    }
    
       /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form Description">                          
    private void initComponents() {
        /*
        **  Add graphical components to the main panel
        */
        
        updateStateWithSensorsButton.addActionListener(new ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                updateStateWithSensorsActionPerformed(evt);
            }
        });
        
        updatePositionButton.addActionListener(new ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                updatePositionActionPerformed(evt);
            }
        });
        
        goToHandoffButton.addActionListener(new ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                goToHandoffActionPerformed(evt);
            }
        });
        
        goToOnlineButton.addActionListener(new ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                goToOnlineActionPerformed(evt);
            }
        });
        
        goToStandbyButton.addActionListener(new ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                goToStandbyActionPerformed(evt);
            }
        });
        
        quickStopButton.addActionListener(new ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                quickStopActionPerformed(evt);
            }
        });

        abortButton.addActionListener(new ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                abortActionPerformed(evt);
            }
        });
        
//        shutdownButton.addActionListener(new ActionListener() {
//            public void actionPerformed(java.awt.event.ActionEvent evt) {
//                shutdownActionPerformed(evt);
//            }
//        });
        
        setBorder(javax.swing.BorderFactory.createTitledBorder("AUTOCHANGER TRUCKS"));
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.NORTHWEST;
        gbc.insets = insets_std;
        
        gbc.weightx = 1.0;
        
        gbc.anchor = GridBagConstraints.NORTH;
        gbc.gridx = 2;
        gbc.gridy = 0;
        cajLabel.setFont(bigFont);
        add(cajLabel, gbc);
        
        //sensors in the 2 first columns 
        limitSwitchUpDigitalSwitch.setColor(Color.gray);
        standbyDigitalSwitch.setColor(Color.gray);
        inTravelDigitalSwitch.setColor(Color.gray);
        handoffDigitalSwitch.setColor(Color.gray);
        onlineDigitalSwitch.setColor(Color.gray);
        limitSwitchDownDigitalSwitch.setColor(Color.gray);

        gbc.anchor = GridBagConstraints.EAST;
        gbc.gridx = 0;
        gbc.gridy = 1;
        add(limitSUjLabel, gbc); 
        gbc.gridx++;
        add(limitSwitchUpDigitalSwitch, gbc);
        
        gbc.anchor = GridBagConstraints.NORTHEAST;
        gbc.gridx = 0;
        gbc.gridy++;
        add(standbyjLabel, gbc);
        gbc.gridx++;
        add(standbyDigitalSwitch, gbc);
        
        gbc.anchor = GridBagConstraints.EAST;
        gbc.gridx = 0;
        gbc.gridy++;
        add(inTraveljLabel, gbc);
        gbc.gridx++;
        add(inTravelDigitalSwitch, gbc);
        
        
        gbc.gridx = 0;
        gbc.gridy++;
        add(handoffjLabel, gbc);
        gbc.gridx++;
        add(handoffDigitalSwitch, gbc);
        
                
        gbc.gridx = 0;
        gbc.gridy++;
        add(onlinejLabel, gbc);
        gbc.gridx++;
        add(onlineDigitalSwitch, gbc);
        
        gbc.anchor = GridBagConstraints.NORTHEAST;
        gbc.gridx = 0;
        gbc.gridy++;
        add(limitSDjLabel, gbc);
        gbc.gridx++;
        add(limitSwitchDownDigitalSwitch, gbc);
        

        
        
        //carrier position progress bar in the column 2
        gbc.anchor = GridBagConstraints.CENTER;
        gbc.gridwidth = 1;
        gbc.gridheight = 4;
        gbc.fill = GridBagConstraints.VERTICAL;
        gbc.gridx = 2;
        gbc.gridy = 2;
        positionProgressBar.setBorderPainted(true);
        positionProgressBar.setValue(400);
        positionProgressBar.setStringPainted(true);
        add(positionProgressBar, gbc);
        gbc.gridheight = 1;
        
        
        //sensor in Error Panel
        //creation Error Panel
        JPanel errorjPanel = new JPanel();
        errorjPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = insets_std;
        inErrorDigitalSwitch.setSize(60);
        inErrorDigitalSwitch.setColor(Color.RED);
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        errorjPanel.add(inErrorDigitalSwitch, gbc1);
        gbc1.gridy++;        
        errorjPanel.add(inErrorjLabel, gbc1);
        gbc1.gridy++;        
        errorjPanel.add(standbySensorsErrorjLabel, gbc1);
        gbc1.gridy++;        
        errorjPanel.add(handoffSensorsErrorjLabel, gbc1);
        //error panel on the grid
        gbc.gridx = 3;
        gbc.gridy = 4;
        gbc.anchor = GridBagConstraints.CENTER;
        gbc.gridheight = 1;
        add(errorjPanel, gbc);
        
        /**
         ******************************************************************************
         **  Parameters Panel
         ******************************************************************************
         */
        JPanel paramPanel = new JPanel();
        //paramPanel.setPreferredSize(new Dimension(200,50));
        paramPanel.setBorder(javax.swing.BorderFactory.createLineBorder(Color.BLACK));
        paramPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = insets_std;
        //first colomn
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        gbc2.anchor = GridBagConstraints.LINE_START;
        paramPanel.add(acjLabel,gbc2);
        gbc2.gridy++;
        paramPanel.add(spjLabel,gbc2);
        gbc2.gridy++;
        paramPanel.add(cujLabel,gbc2);
        //second colomn
        gbc2.gridx++;
        gbc2.gridy = 0;
        gbc2.anchor = GridBagConstraints.LINE_END;
        actualPositionjLabel.setText("0");
        paramPanel.add(actualPositionjLabel,gbc2);
        gbc2.gridy++;
        speedjLabel.setText("0");
        paramPanel.add(speedjLabel,gbc2);
        gbc2.gridy++;
        currentjLabel.setText("0");
        paramPanel.add(currentjLabel,gbc2);
        
        //parameters panel on the grid
        gbc.gridx = 3;
        gbc.gridy = 2;
        add(paramPanel, gbc);
         /**
         ******************************************************************************
         **  End of parameters Panel
         ******************************************************************************
         */
        
         /**
         ******************************************************************************
         **  General Informations Panel
         ******************************************************************************
         */
        JPanel generalInfoPanel = new JPanel();
        generalInfoPanel.setBorder(BorderFactory.createTitledBorder("General Informations"));
        generalInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.insets = insets_std;
        //first colomn
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        gbc3.anchor = GridBagConstraints.LINE_START;
        generalInfoPanel.add(onjLabel,gbc3);
        gbc3.gridy++; 
        generalInfoPanel.add(hojLabel,gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(stjLabel,gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(smjLabel,gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(cmjLabel,gbc3);
        //second colomn
        gbc3.gridx++;
        gbc3.gridy = 0;
        gbc3.anchor = GridBagConstraints.LINE_END;
        generalInfoPanel.add(onlinePositionjLabel,gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(handoffPositionjLabel,gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(standbyPositionjLabel,gbc3);
        gbc3.gridy++;        
        generalInfoPanel.add(speedMaxjLabel,gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(currentMaxjLabel,gbc3);

        //General Informations panel on the grid
        gbc.gridx = 3;
        gbc.gridy = 5;
        add(generalInfoPanel, gbc);
         /**
         ******************************************************************************
         **  End of parameters Panel
         ******************************************************************************
         */
         /**
         ******************************************************************************
         **  Master Controller Fault Panel
         ******************************************************************************
         */  
        
        faultMasterCtlPanel = new JPanel();
        faultMasterCtlPanel.setBorder(BorderFactory.createTitledBorder("Master Ctl"));
        faultMasterCtlPanel.setLayout(new GridBagLayout());
        faultMasterCtlPanel.setPreferredSize(new Dimension(100,100));
        
        faultMasterCtlSwitch.setColor(Color.GRAY);
        faultMasterCtlSwitch.setSize(50);
        
        GridBagConstraints gbcf = new GridBagConstraints();
        gbcf.insets = insets_std;
        gbcf.gridx = 0;
        gbcf.gridy = 0;
        gbcf.anchor = GridBagConstraints.CENTER;
        faultMasterCtlPanel.add(faultMasterCtlSwitch,gbcf);
        
        //
        //Master Controller Fault panel on the grid
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        add(faultMasterCtlPanel, gbc);
         /**
         ******************************************************************************
         **  end of Master Controller Fault Panel
         ******************************************************************************
         */ 
        
         /**
         ******************************************************************************
         **  Slave Controller Fault Panel
         ******************************************************************************
         */  
        
        faultSlaveCtlPanel = new JPanel();
        faultSlaveCtlPanel.setBorder(BorderFactory.createTitledBorder("Slave Ctl"));
        faultSlaveCtlPanel.setLayout(new GridBagLayout());
        faultSlaveCtlPanel.setPreferredSize(new Dimension(100,100));
        
        faultSlaveCtlSwitch.setColor(Color.GRAY);
        faultSlaveCtlSwitch.setSize(50);
        
        GridBagConstraints gbcfSlave = new GridBagConstraints();
        gbcfSlave.insets = insets_std;
        gbcfSlave.gridx = 0;
        gbcfSlave.gridy = 0;
        gbcfSlave.anchor = GridBagConstraints.CENTER;
        faultSlaveCtlPanel.add(faultSlaveCtlSwitch,gbcfSlave);
        
        //
        //Slave Controller Fault panel on the grid
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        add(faultSlaveCtlPanel, gbc);
         /**
         ******************************************************************************
         **  end of Slave Controller Fault Panel
         ******************************************************************************
         */         
        
        /**
         ******************************************************************************
         **  Control Panel
         ******************************************************************************
         */
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new java.awt.GridBagLayout());
        GridBagConstraints gbc4 = new java.awt.GridBagConstraints();
        gbc4.anchor = GridBagConstraints.FIRST_LINE_START;
        gbc4.fill = GridBagConstraints.HORIZONTAL;
        gbc4.insets = insets_std;
        gbc4.gridx = 0;
        gbc4.gridy = 0;
        controlPanel.add(updateStateWithSensorsButton,gbc4);
        gbc4.gridy++;
        controlPanel.add(updatePositionButton,gbc4);
        gbc4.gridy++;
        controlPanel.add(goToOnlineButton,gbc4);
        gbc4.gridy++;
        controlPanel.add(goToHandoffButton,gbc4);
        gbc4.gridy++;
        controlPanel.add(goToStandbyButton,gbc4);
////        gbc4.gridy++;
////        controlPanel.add(quickStopButton,gbc4);
        gbc4.gridy++;
        controlPanel.add(abortButton,gbc4);
//        gbc4.gridy++;
//        controlPanel.add(shutdownButton,gbc4);
        //
        //Control panel on the grid
        gbc.gridx = 4;
        gbc.gridy = 3;
        gbc.weighty = 3;
        gbc.gridwidth =2;
        add(controlPanel, gbc);
         /**
         ******************************************************************************
         **  End of Control Panel
         ******************************************************************************
         */       
        
        
    }
    
    private void updateStateWithSensorsActionPerformed(java.awt.event.ActionEvent evt) {                                                   
        subs.updateStateWithSensors();
    }
    
    private void updatePositionActionPerformed(java.awt.event.ActionEvent evt) {                                                   
        subs.updateTrucksPosition();
    } 

    private void goToHandoffActionPerformed(java.awt.event.ActionEvent evt) {                                                 
        subs.goToHandOff();
    } 
    
    private void goToOnlineActionPerformed(java.awt.event.ActionEvent evt) {                                                       
        subs.goToOnline();
    }

    private void goToStandbyActionPerformed(java.awt.event.ActionEvent evt) {                                                       
        subs.goToStandby();
    }                                                      

    private void quickStopActionPerformed(java.awt.event.ActionEvent evt) {                                                          
        subs.stopMyDestinationSubsystem();
    }                                                         

    private void abortActionPerformed(java.awt.event.ActionEvent evt) {                                      
        subs.abortMyDestinationSubsystem();
    } 
    
//    private void shutdownActionPerformed(java.awt.event.ActionEvent evt) {                                      
//        subs.shutdownMyDestinationSubsystem();
//    }

    
    public static void main(String[] argv) {
        
        AutochangerTrucksPanel d = new AutochangerTrucksPanel();
        JFrame frame = new JFrame("Autochanger Trucks Main Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }
}
