/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.autochanger.config.AutochangerConfig;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.config.CanOpenProxyConfig;
import org.lsst.ccs.subsystems.fcs.config.EPOSControllerConfig;
import org.lsst.ccs.subsystems.fcs.config.PlutoGatewayConfig;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenHardwarePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUISubsystem;
import org.lsst.ccs.subsystems.fcs.ui.commons.PlutoGatewayPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.SubsystemPanel;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.*;
import org.lsst.ccs.subsystems.fcs.ui.commons.TopPanel;

/**
 *
 * @author virieux
 */
public class AutochangerTopPanel extends TopPanel {
    
    private GeneralGUISubsystem subs;
    private JTabbedPane jTabbedPane;
    AutochangerMainPanel autochangerMainPanel;
    private CanOpenHardwarePanel hardwarePanel;
    private EPOSControllerPanel linearRailMasterControllerPanel;
    private EPOSControllerPanel linearRailSlaveControllerPanel;
    private EPOSControllerPanel latchXminusControllerPanel;
    private EPOSControllerPanel latchXplusControllerPanel;
    private EPOSControllerPanel onlineClampControllerPanel;
    private PlutoGatewayPanel plutoGatewayPanel;






        
    /** Initialization of the GUI for data stored in tcpConfiguration. **/
    private  class GuiInitialization implements Runnable {
        
        AutochangerConfig autochangerConfig;
        CanOpenProxyConfig canOpenProxyConfig;
        EPOSControllerConfig lrMasterCtlConfig;
        EPOSControllerConfig lrSlaveCtlConfig;
        EPOSControllerConfig latchXminusCtlConfig;
        EPOSControllerConfig latchXplusCtlConfig;
        EPOSControllerConfig onlineCtlConfig;
        PlutoGatewayConfig gwConfig;

        public GuiInitialization(AutochangerConfig autochangerConfig) {
            this.autochangerConfig = autochangerConfig;
            this.canOpenProxyConfig = autochangerConfig.getTcpProxyConfig();
            this.lrMasterCtlConfig = autochangerConfig.getLinearRailMasterControllerConfig();
            this.lrSlaveCtlConfig = autochangerConfig.getLinearRailSlaveControllerConfig();
            this.latchXminusCtlConfig = autochangerConfig.getLatchXminusControllerConfig();
            this.latchXplusCtlConfig = autochangerConfig.getLatchXplusControllerConfig();
            this.onlineCtlConfig = autochangerConfig.getOnlineClampControllerConfig();
            this.gwConfig = autochangerConfig.getGwConfig();
            
        }

        @Override
        public void run() {
            
            /** Autochanger Main Panel **/
            autochangerMainPanel.initializeGui(autochangerConfig);
            
            /** CANopen hardware list panel **/
            hardwarePanel.initializeGui(canOpenProxyConfig);
            
            /** Linear Rail Master Controller Panel **/
            linearRailMasterControllerPanel.initializeGui(retrieveControllerInfo(canOpenProxyConfig,lrMasterCtlConfig), lrMasterCtlConfig);
            
            /** Linear Rail Slave Controller Panel**/
            linearRailSlaveControllerPanel.initializeGui(retrieveControllerInfo(canOpenProxyConfig,lrSlaveCtlConfig), lrSlaveCtlConfig);

            /** Latch Xminus Controller Panel**/
             latchXminusControllerPanel.initializeGui(retrieveControllerInfo(canOpenProxyConfig,latchXminusCtlConfig), latchXminusCtlConfig);

             /** Latch Xplus Controller Panel**/
             latchXplusControllerPanel.initializeGui(retrieveControllerInfo(canOpenProxyConfig,latchXplusCtlConfig), latchXplusCtlConfig);
           
            /** Online Clamp Controller Panel**/
            onlineClampControllerPanel.initializeGui(retrieveControllerInfo(canOpenProxyConfig,onlineCtlConfig), onlineCtlConfig);  
            
            /** PlutoGateway Panel**/
           plutoGatewayPanel.initializeGui(retrieveDeviceInfo(canOpenProxyConfig,gwConfig.getName()), gwConfig);
           }
    }
    
    public AutochangerTopPanel() {
        initComponents();
    }

    public AutochangerTopPanel(AutochangerGUI subs) {
        this.subs = subs;
        initComponents();
        this.autochangerMainPanel.setSubsystem(subs);
        this.linearRailMasterControllerPanel.setSubsystem(subs);
        this.linearRailSlaveControllerPanel.setSubsystem(subs);
        this.latchXminusControllerPanel.setSubsystem(subs);
        this.latchXplusControllerPanel.setSubsystem(subs);
        this.onlineClampControllerPanel.setSubsystem(subs);
    }
    
    @Override
    public SubsystemPanel getSubsystemPanel() {
        return this.autochangerMainPanel.getSubsystemPanel();
    }
    
    public void initializeGui(AutochangerConfig autochangerConfig) {
        SwingUtilities.invokeLater(new GuiInitialization(autochangerConfig));
    }
   
    
    void updateCanOpenHardwarePanel(StatusDataPublishedByHardware s) {
        hardwarePanel.updateCanOpenHardwarePanel(s);
    }

    void updateLinearRailMasterController(StatusDataPublishedByEPOSController s) {
        linearRailMasterControllerPanel.updateController(s);    
    }

    void updateLinearRailSlaveController(StatusDataPublishedByEPOSController s) {
        linearRailSlaveControllerPanel.updateController(s);
    }
    
    void updateLatchXminusController(StatusDataPublishedByEPOSController s) {
        latchXminusControllerPanel.updateController(s);
    }
    
    void updateLatchXplusController(StatusDataPublishedByEPOSController s) {
        latchXplusControllerPanel.updateController(s);
    }    

    void updateOnlineClampController(StatusDataPublishedByEPOSController s) {
        onlineClampControllerPanel.updateController(s);
    }
    
    void updateTrucks(StatusDataPublishedByAutoChangerTrucks s) {
        fcslog.finest(" Data published by Trucks= " + s.toString());
        this.autochangerMainPanel.updateTrucks(s);
    }
    
    void updateAutochanger(StatusDataPublishedByAutoChanger s) {
        this.autochangerMainPanel.update(s);
    }
    
    void updateLatch(StatusDataPublishedByAutochangerLatch s) {
        this.autochangerMainPanel.updateLatch(s);
    }
    
    void updateLatches(StatusDataPublishedByAutochangerTwoLatches s) {
        this.autochangerMainPanel.updateLatches(s);
    }    
    
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form description">                          
    private void initComponents() {
        //autochanger main panel
        autochangerMainPanel = new AutochangerMainPanel();
        //because the AutoChangerMainPanel is too big we need a scrollBar.
        JScrollPane mainViewScrollPane = new JScrollPane(autochangerMainPanel);
        mainViewScrollPane.createVerticalScrollBar();
        mainViewScrollPane.setPreferredSize(new Dimension(1200,600));
        //CANopen devices panel
        hardwarePanel = new CanOpenHardwarePanel();       
        //controllers Panels
        linearRailMasterControllerPanel = new EPOSControllerPanel();     
        linearRailSlaveControllerPanel = new EPOSControllerPanel();
        latchXminusControllerPanel = new EPOSControllerPanel();
        latchXplusControllerPanel = new EPOSControllerPanel();
        onlineClampControllerPanel = new EPOSControllerPanel();
        //plutoGatewayPanel
        plutoGatewayPanel = new PlutoGatewayPanel();
        //TabbedPane
        jTabbedPane = new JTabbedPane();  
        jTabbedPane.setBorder(BorderFactory.createLineBorder(new java.awt.Color(0, 150, 180)));
        jTabbedPane.addTab("Autochanger Main View", mainViewScrollPane);
        jTabbedPane.addTab("Autochanger CANopen Devices", hardwarePanel);
        jTabbedPane.addTab("Linear Rail Master Controller", linearRailMasterControllerPanel);
        jTabbedPane.addTab("Linear Rail Slave Controller", linearRailSlaveControllerPanel);
        jTabbedPane.addTab("LatchXminus Controller", latchXminusControllerPanel);
        jTabbedPane.addTab("LatchXplus Controller", latchXplusControllerPanel);
        jTabbedPane.addTab("Online Clamp Controller", onlineClampControllerPanel);
        jTabbedPane.addTab("Pluto Gateway", plutoGatewayPanel);

        
        //Whole Panel
        setLayout(new GridBagLayout());
        setForeground(new Color(204, 204, 255));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = java.awt.GridBagConstraints.BASELINE_LEADING;
        gbc.gridx = 0;
        gbc.gridy = 0;    
        add(jTabbedPane, gbc);
    }
    
    public static void main(String[] argv) {
        
        AutochangerTopPanel d = new AutochangerTopPanel();
        JFrame frame = new JFrame("Autochanger High Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }
    
}
