/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.greenColor;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_big;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;
import org.lsst.ccs.utilities.logging.Logger;

/**
 *
 * @author virieux
 */
public class AutochangerLatchPanel extends JPanel {

    static final Logger log = Logger.getLogger("org.lsst.ccs.subsystems.fcs");
    
    // Variables declaration  
    private DigitalSwitch unlockSensorDS;
    private DigitalSwitch lockSensorDS;
    private DigitalSwitch filterEngagedSensorDS;
    private DigitalSwitch errorDS;
    
    private JLabel latchName;  
    private JLabel unlockLabel;
    private JLabel lockLabel;
    private JLabel errorLabel;
    private JLabel filterEngagedLabel;
    private JLabel lockStatus; //is it useful to display the lockStatus ?
    //Controller Fault Panel
    JPanel faultPanel;
    DigitalSwitch faultSwitch;
    // End of variables declaration 
    
    public AutochangerLatchPanel() {
        initComponents();
    }
    
    void setLatchName(String name) {
        latchName.setText(name);
    }    
    
    public void updateLatch(StatusDataPublishedByAutochangerLatch status) {
        SwingUtilities.invokeLater(new UpdateLatch(status));
    }    
    
    class UpdateLatch implements Runnable {

        StatusDataPublishedByAutochangerLatch s;

        public UpdateLatch(StatusDataPublishedByAutochangerLatch status) {
            this.s = status;
        }
        
        @Override
        public void run() {
           
            latchName.setText(s.getName());
            unlockSensorDS.setColor(s.getUnlockSensorValue() == 1 ? greenColor : Color.gray);
            lockSensorDS.setColor(s.getLockSensorValue() == 1 ? greenColor : Color.gray);
            filterEngagedSensorDS.setColor(s.getFilterPresenceSensorValue() == 1 ? greenColor : Color.gray);
            boolean inTravel = (s.getUnlockSensorValue() == 0) && (s.getLockSensorValue() == 0);
            if (s.isInError()) {
                errorDS.setColor(Color.RED);
                errorLabel.setText("IN ERROR");
            } else if (inTravel) {
                errorDS.setColor(Color.YELLOW);
                errorLabel.setText("IN TRAVEL");
            } else if (s.getLockStatus().equals(FcsEnumerations.LockStatus.UNKNOWN)) {
                errorDS.setColor(Color.DARK_GRAY);
                errorLabel.setText("UNKNOWN");
            } else {
                errorDS.setColor(Color.GREEN);
                errorLabel.setText("NO ERROR");
            }
            lockStatus.setText(s.getLockStatus());
            Color latchLockStatusColor = Tools.getLockSensorColor(s.getLockStatus());
            lockStatus.setBackground(latchLockStatusColor);
        }
    }    

   
    
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form description"> 
    private void initComponents() {

        
        unlockSensorDS = new DigitalSwitch();
        unlockSensorDS.setColor(Color.gray);
        lockSensorDS = new DigitalSwitch();
        lockSensorDS.setColor(Color.gray);
        filterEngagedSensorDS = new DigitalSwitch();
        filterEngagedSensorDS.setColor(Color.gray);
        errorDS = new DigitalSwitch();
        errorDS.setColor(Color.gray);
        
        latchName = new JLabel("myLatch");
        unlockLabel = new JLabel("<html><P align=\"center\">UNLOCK<br>SENSOR</p></html>");
        lockLabel = new JLabel("<html><P align=\"center\">LOCK<br>SENSOR</p></html>");
        errorLabel = new JLabel("ERROR");
        filterEngagedLabel = new JLabel("<html><P align=\"center\">FILTER<br>ENGAGED</p></html>");
        lockStatus = new JLabel("UNKNOWN STATE");
        



         /*******************************************************************************
         **  Controller Fault Panel
         ******************************************************************************
         */  
        
        faultPanel = new JPanel();
        faultSwitch = new DigitalSwitch();
        faultSwitch.setColor(Color.GRAY);
        faultPanel.setBorder(BorderFactory.createTitledBorder("Controller"));
        faultPanel.setLayout(new GridBagLayout());
        faultPanel.setPreferredSize(new Dimension(100,100));
        
        faultSwitch.setColor(Color.GRAY);
        faultSwitch.setSize(50);
        
        GridBagConstraints gbcf = new GridBagConstraints();
        gbcf.insets = insets_std;
        gbcf.gridx = 0;
        gbcf.gridy = 0;
        gbcf.anchor = GridBagConstraints.CENTER;
        faultPanel.add(faultSwitch,gbcf);
        
         /*******************************************************************************
         **  end of Controller Fault Panel
         ******************************************************************************
         */
        
         /*******************************************************************************
         **  Whole Panel
         ******************************************************************************
         */

        setBorder(BorderFactory.createEtchedBorder());
        setForeground(new Color(204, 204, 255));
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_big;
        
        gbc.gridx=0;
        gbc.gridy=0;
        add(latchName,gbc);
//        gbc.gridy++;
//        add(lockStatus,gbc);
        
        gbc.gridx=1;
        gbc.gridy=0;
        add(unlockSensorDS,gbc);
        gbc.gridy++;
        add(unlockLabel,gbc);

        gbc.gridx=2;
        gbc.gridy=0;
        add(lockSensorDS,gbc);
        gbc.gridy++;
        add(lockLabel,gbc);  

        gbc.gridx=3;
        gbc.gridy=0;
        add(filterEngagedSensorDS,gbc);
        gbc.gridy++;
        add(filterEngagedLabel,gbc); 

        gbc.gridx=4;
        gbc.gridy=0;
        add(errorDS,gbc);
        gbc.gridy++;
        add(errorLabel,gbc);
        
        gbc.gridx=5;
        gbc.gridy=0;
        gbc.gridheight = 2;
        add(faultPanel,gbc);
        
    }
    
    public static void main(String[] argv) {
        
        AutochangerLatchPanel d = new AutochangerLatchPanel();
        JFrame frame = new JFrame("Autochanger Latch Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }
    
}
